/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

public class SimpleDelta {
    protected int kind = 0;
    protected int changeFlags = 0;

    public void added() {
        this.kind = 1;
    }

    public void changed(int n) {
        this.kind = 4;
        this.changeFlags |= n;
    }

    public int getFlags() {
        return this.changeFlags;
    }

    public int getKind() {
        return this.kind;
    }

    public void modifiers() {
        this.changed(2);
    }

    public void removed() {
        this.kind = 2;
        this.changeFlags = 0;
    }

    public void superTypes() {
        this.changed(2048);
    }

    protected void toDebugString(StringBuffer stringBuffer) {
        stringBuffer.append("[");
        switch (this.getKind()) {
            case 1: {
                stringBuffer.append('+');
                break;
            }
            case 2: {
                stringBuffer.append('-');
                break;
            }
            case 4: {
                stringBuffer.append('*');
                break;
            }
            default: {
                stringBuffer.append('?');
            }
        }
        stringBuffer.append("]: {");
        this.toDebugString(stringBuffer, this.getFlags());
        stringBuffer.append("}");
    }

    protected boolean toDebugString(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        if ((n & 2) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("MODIFIERS CHANGED");
            bl = true;
        }
        if ((n & 0x800) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("SUPER TYPES CHANGED");
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toDebugString(stringBuffer);
        return stringBuffer.toString();
    }
}

