/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceImport;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.ImportDeclarationElementInfo;
import org.rubypeople.rdt.internal.core.MemberElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyField;
import org.rubypeople.rdt.internal.core.RubyImport;
import org.rubypeople.rdt.internal.core.RubyMethod;
import org.rubypeople.rdt.internal.core.RubyType;

public class RubyTypeElementInfo
extends MemberElementInfo {
    protected static final ImportDeclarationElementInfo[] NO_IMPORTS = new ImportDeclarationElementInfo[0];
    protected static final RubyField[] NO_FIELDS = new RubyField[0];
    protected static final RubyMethod[] NO_METHODS = new RubyMethod[0];
    protected static final RubyType[] NO_TYPES = new RubyType[0];
    protected String superclassName;
    protected String[] includedModuleNames;
    protected String sourceFileName;
    protected String namespaceName;
    private ISourceImport[] imports;
    protected IType handle = null;

    public IType getEnclosingType() {
        IRubyElement iRubyElement = this.handle.getParent();
        if (iRubyElement != null && iRubyElement.getElementType() == 3) {
            try {
                return (IType)((RubyElement)iRubyElement).getElementInfo();
            }
            catch (RubyModelException rubyModelException) {
                return null;
            }
        }
        return null;
    }

    public IField[] getFields() {
        RubyField[] rubyFieldArray = this.getFieldHandles();
        int n = rubyFieldArray.length;
        IField[] iFieldArray = new IField[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                IField iField;
                iFieldArray[n2] = iField = (IField)rubyFieldArray[n2].getElementInfo();
            }
            catch (RubyModelException rubyModelException) {}
            ++n2;
        }
        return iFieldArray;
    }

    public RubyField[] getFieldHandles() {
        int n = this.children.length;
        if (n == 0) {
            return NO_FIELDS;
        }
        RubyField[] rubyFieldArray = new RubyField[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IRubyElement iRubyElement = this.children[n3];
            if (iRubyElement instanceof RubyField) {
                rubyFieldArray[n2++] = (RubyField)iRubyElement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_FIELDS;
        }
        if (n2 < n) {
            RubyField[] rubyFieldArray2 = rubyFieldArray;
            rubyFieldArray = new RubyField[n2];
            System.arraycopy(rubyFieldArray2, 0, rubyFieldArray, 0, n2);
        }
        return rubyFieldArray;
    }

    public String getFileName() {
        return this.sourceFileName;
    }

    public IType getHandle() {
        return this.handle;
    }

    public ISourceImport[] getImports() {
        if (this.imports == null) {
            try {
                IImportDeclaration[] iImportDeclarationArray = this.handle.getRubyScript().getImports();
                int n = iImportDeclarationArray.length;
                if (n == 0) {
                    this.imports = NO_IMPORTS;
                } else {
                    ImportDeclarationElementInfo[] importDeclarationElementInfoArray = new ImportDeclarationElementInfo[n];
                    int n2 = 0;
                    while (n2 < n) {
                        importDeclarationElementInfoArray[n2] = (ImportDeclarationElementInfo)((RubyImport)iImportDeclarationArray[n2]).getElementInfo();
                        ++n2;
                    }
                    this.imports = importDeclarationElementInfoArray;
                }
            }
            catch (RubyModelException rubyModelException) {
                this.imports = NO_IMPORTS;
            }
        }
        return this.imports;
    }

    public String[] getIncludedModuleNames() {
        if (this.handle.getElementName().length() == 0) {
            return null;
        }
        return this.includedModuleNames;
    }

    public IType[] getMemberTypes() {
        RubyType[] rubyTypeArray = this.getMemberTypeHandles();
        int n = rubyTypeArray.length;
        IType[] iTypeArray = new IType[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                IType iType;
                iTypeArray[n2] = iType = (IType)rubyTypeArray[n2].getElementInfo();
            }
            catch (RubyModelException rubyModelException) {}
            ++n2;
        }
        return iTypeArray;
    }

    public RubyType[] getMemberTypeHandles() {
        int n = this.children.length;
        if (n == 0) {
            return NO_TYPES;
        }
        RubyType[] rubyTypeArray = new RubyType[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IRubyElement iRubyElement = this.children[n3];
            if (iRubyElement instanceof RubyType) {
                rubyTypeArray[n2++] = (RubyType)iRubyElement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_TYPES;
        }
        if (n2 < n) {
            RubyType[] rubyTypeArray2 = rubyTypeArray;
            rubyTypeArray = new RubyType[n2];
            System.arraycopy(rubyTypeArray2, 0, rubyTypeArray, 0, n2);
        }
        return rubyTypeArray;
    }

    public IMethod[] getMethods() {
        RubyMethod[] rubyMethodArray = this.getMethodHandles();
        int n = rubyMethodArray.length;
        IMethod[] iMethodArray = new IMethod[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                IMethod iMethod = (IMethod)rubyMethodArray[n3].getElementInfo();
                iMethodArray[n2++] = iMethod;
            }
            catch (RubyModelException rubyModelException) {}
            ++n3;
        }
        return iMethodArray;
    }

    public RubyMethod[] getMethodHandles() {
        int n = this.children.length;
        if (n == 0) {
            return NO_METHODS;
        }
        RubyMethod[] rubyMethodArray = new RubyMethod[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IRubyElement iRubyElement = this.children[n3];
            if (iRubyElement instanceof RubyMethod) {
                rubyMethodArray[n2++] = (RubyMethod)iRubyElement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_METHODS;
        }
        if (n2 < n) {
            RubyMethod[] rubyMethodArray2 = rubyMethodArray;
            rubyMethodArray = new RubyMethod[n2];
            System.arraycopy(rubyMethodArray2, 0, rubyMethodArray, 0, n2);
        }
        return rubyMethodArray;
    }

    public char[] getName() {
        return this.handle.getElementName().toCharArray();
    }

    public String getNamespace() {
        return this.namespaceName;
    }

    public String getSuperclassName() {
        String[] stringArray;
        if (this.handle.getElementName().length() == 0 && (stringArray = this.includedModuleNames) != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return this.superclassName;
    }

    protected void setHandle(IType iType) {
        this.handle = iType;
    }

    protected void setNamespaceName(String string) {
        this.namespaceName = string;
    }

    protected void setSourceFileName(String string) {
        this.sourceFileName = string;
    }

    protected void setSuperclassName(String string) {
        this.superclassName = string;
    }

    protected void setIncludedModuleNames(String[] stringArray) {
        this.includedModuleNames = stringArray;
    }

    public String toString() {
        return "Info for " + this.handle.toString();
    }
}

