/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.event.AbstractTrigger;
import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.event.Trigger;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.MessageImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;

public class AntBuildTrigger
extends AbstractTrigger
implements Trigger {
    private boolean _onlyonce = true;
    private String _target = null;
    private Collection _builds = new ArrayList();
    private String _buildFilePattern;
    private String _prefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(IvyEvent event) {
        File f = this.getBuildFile(event);
        if (f.exists()) {
            if (this._onlyonce && this.isBuilt(f)) {
                Message.verbose("target build file already built, skipping: " + f);
            } else {
                Ant ant = new Ant();
                Project project = (Project)IvyContext.getContext().get("ant-project");
                if (project == null) {
                    project = new Project();
                    project.init();
                }
                ant.setProject(project);
                ant.setTaskName("ant");
                ant.setAntfile(f.getAbsolutePath());
                ant.setInheritAll(false);
                String target = this.getTarget();
                if (target != null) {
                    ant.setTarget(target);
                }
                Map atts = event.getAttributes();
                Iterator iter = atts.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)atts.get(key);
                    Property p = ant.createProperty();
                    p.setName(this._prefix == null ? key : this._prefix + key);
                    p.setValue(value);
                }
                Message.verbose("triggering build: " + f + " target=" + target + " for " + event);
                MessageImpl impl = IvyContext.getContext().getMessageImpl();
                try {
                    IvyContext.getContext().setMessageImpl(null);
                    ant.execute();
                    this.markBuilt(f);
                }
                finally {
                    IvyContext.getContext().setMessageImpl(impl);
                }
                Message.debug("triggered build finished: " + f + " target=" + target + " for " + event);
            }
        } else {
            Message.verbose("no build file found for dependency, skipping: " + f);
        }
    }

    private void markBuilt(File f) {
        this._builds.add(f.getAbsolutePath());
    }

    private boolean isBuilt(File f) {
        return this._builds.contains(f.getAbsolutePath());
    }

    private File getBuildFile(IvyEvent event) {
        return new File(IvyPatternHelper.substituteTokens(this.getBuildFilePattern(), event.getAttributes()));
    }

    public String getBuildFilePattern() {
        return this._buildFilePattern;
    }

    public void setAntfile(String pattern) {
        this._buildFilePattern = pattern;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public boolean isOnlyonce() {
        return this._onlyonce;
    }

    public void setOnlyonce(boolean onlyonce) {
        this._onlyonce = onlyonce;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
        if (!prefix.endsWith(".")) {
            this._prefix = this._prefix + ".";
        }
    }
}

