/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.epic.debug.PerlDebugPlugin;

public class LaunchShortcut
implements ILaunchShortcut {
    private static final String DEBUG_LAUNCH_CONFIGURATION_PERL = "org.epic.debug.launchConfigurationPerl";

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IFile) {
            this.launch((IFile)((IStructuredSelection)selection).getFirstElement(), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        FileEditorInput editorInput = (FileEditorInput)editor.getEditorInput();
        this.launch(editorInput.getFile(), mode);
    }

    private void launch(IFile bin, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(bin, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(IFile bin, String mode) {
        ILaunchConfiguration configuration = null;
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                String projectName = config.getAttribute("ATTR_PROJECT_NAME", null);
                String programFile = config.getAttribute("ATTR_STARTUP_FILE", null);
                String name = bin.getName();
                if (programFile != null && programFile.equals(name) && projectName != null && projectName.equals(bin.getProject().getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        configuration = candidateCount < 1 ? this.createConfiguration(bin) : (ILaunchConfiguration)candidateConfigs.get(0);
        return configuration;
    }

    private ILaunchConfiguration createConfiguration(IFile file) {
        ILaunchConfiguration config = null;
        String projectName = file.getProjectRelativePath().toString();
        ILaunchConfigurationType[] configType = this.getLaunchManager().getLaunchConfigurationTypes();
        ILaunchConfigurationType type = null;
        int i = 0;
        while (i < configType.length) {
            if (configType[i].getIdentifier().equals(DEBUG_LAUNCH_CONFIGURATION_PERL)) {
                type = configType[i];
            }
            ++i;
        }
        try {
            if (type != null) {
                ILaunchConfigurationWorkingCopy wc = type.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file.getName()));
                wc.setAttribute("ATTR_STARTUP_FILE", projectName);
                wc.setAttribute("ATTR_PROJECT_NAME", file.getProject().getName());
                wc.setAttribute("ATTR_WORKING_DIRECTORY", null);
                config = wc.doSave();
            }
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
        return config;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

