/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.popupmenus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceAction;
import org.epic.core.Constants;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.popupmenus.PopupMessages;
import org.epic.perleditor.views.ExplainErrorsView;

public class ExplainErrorsRulerAction
extends ResourceAction
implements IUpdate {
    IVerticalRulerInfo ruler;
    ITextEditor editor;
    ArrayList markers;

    public ExplainErrorsRulerAction(IVerticalRulerInfo ruler, ITextEditor editor) {
        super(PopupMessages.getBundle(), "ExplainErrorsRulerAction.");
        this.ruler = ruler;
        this.editor = editor;
    }

    public void run() {
        ExplainErrorsView view = null;
        IWorkbenchPage activePage = PerlEditorPlugin.getWorkbenchWindow().getActivePage();
        try {
            view = (ExplainErrorsView)activePage.showView("org.epic.perleditor.views.ExplainErrorsView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        view.explain(this.markers);
    }

    public void update() {
        this.getMarkersForLine(this.ruler.getLineOfLastMouseButtonActivity() + 1);
        this.setEnabled(this.markers.size() > 0);
    }

    private List getMarkersForLine(int aLine) {
        this.markers = new ArrayList();
        IDocumentProvider provider = this.editor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.editor.getEditorInput());
        if (model != null) {
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation)) continue;
                MarkerAnnotation a = (MarkerAnnotation)o;
                try {
                    IMarker marker = a.getMarker();
                    int markerLineNumber = (Integer)marker.getAttribute("lineNumber");
                    if (!marker.getType().equals(Constants.PROBLEM_MARKER) || markerLineNumber != aLine) continue;
                    this.markers.add(marker);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return this.markers;
    }
}

