/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.builders;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.epic.core.ResourceMessages;
import org.epic.core.decorators.PerlDecorator;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.util.PerlValidator;

class PerlBuilderJob
extends Job {
    public static final String JOB_FAMILY = "PerlBuilder.jobFamily";
    private final List dirtyResources;
    private final Set validatedResources;

    public PerlBuilderJob(List dirtyResources, Set successResources) {
        super(ResourceMessages.getString("PerlBuilderJob.name"));
        this.validatedResources = successResources;
        this.dirtyResources = dirtyResources;
    }

    public boolean belongsTo(Object family) {
        return super.belongsTo(family) || JOB_FAMILY.equals(family);
    }

    public Collection getDirtyResources() {
        return Collections.unmodifiableList(this.dirtyResources);
    }

    public Collection getValidatedResources() {
        return Collections.unmodifiableSet(this.validatedResources);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("", this.dirtyResources.size());
        Iterator i = this.dirtyResources.iterator();
        while (i.hasNext()) {
            if (monitor.isCanceled()) break;
            IResource resource = (IResource)i.next();
            monitor.subTask(resource.getProjectRelativePath().toString());
            this.buildResource(resource);
            i.remove();
            monitor.worked(1);
        }
        monitor.done();
        PerlDecorator decorator = PerlDecorator.getPerlDecorator();
        if (decorator != null) {
            decorator.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)decorator, this.validatedResources.toArray()));
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void buildResource(IResource resource) {
        try {
            if (PerlValidator.instance().validate(resource)) {
                this.validatedResources.add(resource);
                this.markParentFoldersUpdated(resource);
            }
        }
        catch (CoreException e) {
            PerlEditorPlugin.getDefault().getLog().log((IStatus)new MultiStatus(PerlEditorPlugin.getPluginId(), 0, new IStatus[]{e.getStatus()}, "An unexpected exception occurred while validating " + resource.getProjectRelativePath(), (Throwable)e));
        }
        catch (Exception e) {
            PerlEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "An unexpected exception occurred while validating " + resource.getProjectRelativePath(), (Throwable)e));
        }
    }

    private void markParentFoldersUpdated(IResource resource) {
        while ((resource = resource.getParent()) != null) {
            if (resource.getType() != 2) continue;
            this.validatedResources.add(resource);
        }
    }
}

