<?php
	/**
	 * Contact Module
	 * @author Johnny Biemans <j.biemans@connectux.com>
	 */
	class ContactListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function ContactListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getContactProperties();

			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "icon_index", true, 0, _("Icon"), _("Sort On Icon"));
			$this->addColumn($this->tablecolumns, "fileas", true, 1, _("File As"), _("Sort On File As"));
			$this->addColumn($this->tablecolumns, "display_name", true, 2, _("Full Name"), _("Sort On Display Name"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "email_address_1", true, 3, _("Email Address 1"), _("Sort On Email Address 1"));
			$this->addColumn($this->tablecolumns, "email_address_2", false, 3, _("Email Address 2"), _("Sort On Email Address 2"));
			$this->addColumn($this->tablecolumns, "email_address_3", false, 3, _("Email Address 3"), _("Sort On Email Address 3"));
			$this->addColumn($this->tablecolumns, "home_telephone_number", true, 4, _("Home Telephonenumber"), _("Sort On Home Telephonenumber"));
			$this->addColumn($this->tablecolumns, "cellular_telephone_number", true, 5, _("Cellular Telephonenumber"), _("Sort On Cellular Telephonenumber"));
			$this->addColumn($this->tablecolumns, "categories", false, 4, _("Categories"), _("Sort On Categories"));

			$this->addColumn($this->tablecolumns, "business_telephone_number", false, 99, _("Business Telephonenumber"), _("Sort On Business Telephonenumber"));
			$this->addColumn($this->tablecolumns, "office_telephone_number", false, 99, _("Office Telephonenumber"), _("Sort On Office Telephonenumber"));
			$this->addColumn($this->tablecolumns, "business_fax_number", false, 99, _("Business Faxnumber"), _("Sort On Business Faxnumber"));
			$this->addColumn($this->tablecolumns, "company_name", false, 99, _("Company Name"), _("Sort On Company Name"));
			$this->addColumn($this->tablecolumns, "department_name", false, 99, _("Department Name"), _("Sort On Department Name"));
			$this->addColumn($this->tablecolumns, "office_location", false, 99, _("Office Location"), _("Sort On Office Location"));
			$this->addColumn($this->tablecolumns, "profession", false, 99, _("Profession"), _("Sort On Profession"));
			$this->addColumn($this->tablecolumns, "manager_name", false, 99, _("Manager name"), _("Sort On Manager Name"));
			$this->addColumn($this->tablecolumns, "assistant", false, 99, _("Assistant"), _("Sort On Assistant"));
			$this->addColumn($this->tablecolumns, "nickname", false, 99, _("Nickname"), _("Sort On Nickname"));
			$this->addColumn($this->tablecolumns, "spouse_name", false, 99, _("Spouse Name"), _("Sort On Spouse Name"));
			$this->addColumn($this->tablecolumns, "birthday", false, 99, _("Birthday"), _("Sort On Birthday"));
			$this->addColumn($this->tablecolumns, "business_address", false, 99, _("Business Address"), _("Sort On Business Address"));
			$this->addColumn($this->tablecolumns, "home_address", false, 99, _("Home Address"), _("Sort On Home Address"));
			$this->addColumn($this->tablecolumns, "other_address", false, 99, _("Office Address"), _("Sort On Other Address"));
			$this->addColumn($this->tablecolumns, "mailing_address", false, 99, _("Mailing Address"), _("Sort On Mailing Address"));
			$this->addColumn($this->tablecolumns, "im", false, 99, _("IM"), _("Sort On IM"));
			$this->addColumn($this->tablecolumns, "webpage", false, 99, _("Webpage"), _("Sort On Webpage"));
			$this->addColumn($this->tablecolumns, "assistant_telephone_number", false, 99, _("Assistant Telephonenumber"), _("Sort On Assistant Telephonenumber"));
			$this->addColumn($this->tablecolumns, "business2_telephone_number", false, 99, _("Business Telephonenumber 2"), _("Sort On Business Telephonenumber 2"));
			$this->addColumn($this->tablecolumns, "callback_telephone_number", false, 99, _("Callback Telephonenumber"), _("Sort On Callback Telephonenumber"));
			$this->addColumn($this->tablecolumns, "car_telephone_number", false, 99, _("Car Telephonenumber"), _("Sort On Car Telephonenumber"));
			$this->addColumn($this->tablecolumns, "company_telephone_number", false, 99, _("Company Telephonenumber"), _("Sort On Company Telephonenumber"));
			$this->addColumn($this->tablecolumns, "home2_telephone_number", false, 99, _("Home Telephonenumber 2"), _("Sort On Home Telephonenumber 2"));
			$this->addColumn($this->tablecolumns, "home_fax_number", false, 99, _("Home Faxnumber"), _("Sort On Home Faxnumber"));
			$this->addColumn($this->tablecolumns, "isdn_number", false, 99, _("ISDN Number"), _("Sort On ISDN number"));
			$this->addColumn($this->tablecolumns, "other_telephone_number", false, 99, _("Other Telephonenumber"), _("Sort On Other Telephonenumber"));
			$this->addColumn($this->tablecolumns, "pager_telephone_number", false, 99, _("Pager Telephonenumber"), _("Sort On Pager Telephonenumber"));

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->sort = array();
			$this->sort[$this->properties["fileas"]] = TABLE_SORT_ASCEND;
			
			$this->start = 0;
		}
		
		/**
		 * Function which retrieves a list of contacts in a contact folder. It uses
		 * a restriction (start letter).		 
		 * @param object $store MAPI Message Store Object
		 * @param string $entryid entryid of the folder
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function messageList($store, $entryid, $action)
		{
			$result = false;

			// Retrieve the data for a normal table view with rows.
			if(isset($action["data_retrieval"]) && $action["data_retrieval"] == "normal") {
				// Use the parent class "messageList" method
				$result = parent::messageList($store, $entryid, $action);
			} else { // Retrieve the data for the address cards view
				if($store && $entryid) {
					$character = "a";
					if(isset($action["restriction"])) {
						if(isset($action["restriction"]["character"])) {
							$character = $action["restriction"]["character"];
						}
						if(isset($action["restriction"]["start"])) {
							// Set start variable
							$this->start = (int) $action["restriction"]["start"];
						}
					}
					
					$restriction = array();
					if($character != "...") {
						switch ($character){
							case "123":
								$restriction = array(
												RES_AND,
												array(
													array(
														RES_PROPERTY,
														array(RELOP => RELOP_GE,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => "0" 
															)
														)
													),
													array(
														RES_PROPERTY,
														array(RELOP => RELOP_LE,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => "9"
															)
														)
													)
												)
											);
								break;
							case "z":
								$restriction = array(
													RES_PROPERTY,
													array(RELOP => RELOP_GE,
														ULPROPTAG => $this->properties["fileas"],
														VALUE => array(
															$this->properties["fileas"] => "z" 
														)
													)
												);
								break;
							default:
								$restriction = array(
												RES_AND,
												array(
													array(
														RES_PROPERTY,
														array(
															RELOP => RELOP_GE,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => $character
															)
														)
													),
													array(
														RES_PROPERTY,
														array(
															RELOP => RELOP_LT,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => chr(ord($character)+1)
															)
														)
													)
												)
											);
							break;
						}
					}

					$sort = array($this->properties["fileas"]=>TABLE_SORT_ASCEND);

					$data = array();
					$data["attributes"] = array("type" => "list");
					
					$firstSortColumn = reset(array_keys($this->sort)); // get first key of the sort array
					$data["sort"] = array();
					$data["sort"]["attributes"] = array();
					$data["sort"]["attributes"]["direction"] = (isset($this->sort[$firstSortColumn]) && $this->sort[$firstSortColumn] == TABLE_SORT_ASCEND) ? "asc" : "desc";
					$data["sort"]["_content"] = array_search($firstSortColumn, $this->properties);
	
					$data = array_merge($data, $GLOBALS["operations"]->getTable($store, $entryid, $this->properties, $sort, $this->start, false, $restriction));
					
					array_push($this->responseData["action"], $data);
					$GLOBALS["bus"]->addData($this->responseData);
					
					$result = true;
				} 
			}
			
			return $result;
		}
	}
?>
