<?php
	/**
	* This is the entry point for every request that should return HTML
	* 
	* (one exception is that it also returns translated text for javascript)
	*
	* @author Michael Erkens <michael@connectux.com>
	*/

	// load config file
	if (!file_exists("config.php")){
		die("<strong>config.php is missing!</strong>");
	}
	include("config.php");

	// This checks whether the Multi-User Calendar is present
	define('MUC_AVAILABLE', (is_file('client/modules/multiusercalendarmodule.js')));
	
	ob_start();

	// Start the session
	session_name(COOKIE_NAME);
	session_start();
	
	// check if config is correct
	if (defined("CONFIG_CHECK")){
		include("server/class.configcheck.php");
		new ConfigCheck(CONFIG_CHECK);
	}

	// Include the files
	require("mapi/mapi.util.php");
	require("mapi/mapicode.php");
	require("mapi/mapidefs.php");
	require("mapi/mapitags.php");
	require("mapi/mapiguid.php");
	require("server/util.php");

	require("server/core/constants.php");
	require("server/core/class.conversion.php");
	require("server/core/class.mapisession.php");
	
	require("server/core/class.request.php");
	require("server/core/class.settings.php");
	require("server/core/class.language.php");

	require("server/core/class.state.php");
	
	// Destroy session if an user loggs out
	if($_GET && array_key_exists("logout", $_GET)) {
		$_SESSION = array();
		
		if (isset($_COOKIE[session_name()])) {
			setcookie(session_name(), '', time()-42000, '/');
		}
		session_destroy();

		header("Refresh: 0; url=index.php");
		exit;
	}

	// Set the session variables if it is posted
	if($_POST && array_key_exists("username", $_POST) && array_key_exists("password", $_POST)) {
		$_SESSION["username"] = utf8_to_windows1252($_POST["username"]);
		$_SESSION["password"] = utf8_to_windows1252($_POST["password"]);
	}
	
	
	// Create global mapi object. This object is used in many other files
	$GLOBALS["mapisession"] = new MAPISession();
	if (isset($_SESSION["username"]) && isset($_SESSION["password"])) {
		$hresult = $GLOBALS["mapisession"]->logon($_SESSION["username"], $_SESSION["password"], DEFAULT_SERVER);
		if ($hresult != NOERROR){
			// login failed, remove session
			$_SESSION = array();
			$_SESSION["hresult"] = $hresult;
		}
	}

	// Check if user is authenticated
	if ($GLOBALS["mapisession"]->isLoggedOn()) {
		// Authenticated
		
		// Create globals settings object
		$GLOBALS["settings"] = new Settings();
		
		// Create global language object
		$GLOBALS["language"] = new Language();

		// Set session settings (language & style)
		foreach($GLOBALS["settings"]->getSessionSettings() as $key=>$value){
			$_SESSION[$key] = $value;
		}
		
		// Get settings from post or session or settings
		if (isset($_REQUEST["language"]) && $GLOBALS["language"]->is_language($_REQUEST["language"])) {
			$lang = $_REQUEST["language"];
			$GLOBALS["settings"]->set("global/language", $lang);
		} else if(isset($_SESSION["lang"])) {
			$lang = $_SESSION["lang"];
		} else $lang = $GLOBALS["settings"]->get("global/language", LANG);
		
		$GLOBALS["language"]->setLanguage($lang);

		if($_GET && array_key_exists("logon", $_GET)) {
			if($_REQUEST && $_REQUEST["action_url"] != "") {
				// if action attributes are passed in POST variable then append it to URL for
				// further processing
				$url = "index.php" . $_REQUEST["action_url"];
				header("Refresh: 0; url=$url");
				exit;
			} else {
				header("Refresh: 0; url=index.php");
				exit;
			}
		}

		// add extra header
		header("X-Zarafa: ".phpversion("mapi").(defined("SVN") ? "-".SVN:""));

		// external files who need our login
		if ($_GET && array_key_exists("load", $_GET)) {

			// Get Attachment data from state and put it into the $_SESSION
			$attachment_state = new State('attachments');
			$attachment_state->open();
			$_SESSION['files'] = $attachment_state->read("files");
			$_SESSION['deleteattachment'] = $attachment_state->read("deleteattachment");
			$attachment_state->close();

			switch ($_GET["load"]) {
				case "translations.js":
					include("client/translations.js.php");
					break;
				case "dialog":
					include("client/dialog.php");
					break;
				case "upload_attachment":
					include("server/upload_attachment.php");
					break;
				case "download_attachment":
					include("client/download_attachment.php");
					break;
				default:
					include("client/webclient.php");
					break;
			}

			// Get Attachment data from $_SESSION and put it into the state
			$attachment_state = new State('attachments');
			$attachment_state->open();
			$attachment_state->write("files", $_SESSION['files']);
			$attachment_state->write("deleteattachment", $_SESSION['deleteattachment']);
			$attachment_state->close();
			// Prevent the SESSION data to be stored elsewhere
			unset($_SESSION['files'], $_SESSION['deleteattachment']);

		} else {
			// Clean up old state files in tmp/session/
			$state = new State("index");
			$state->clean();

			// Clean up old attachments in tmp
			cleanTemp();
					
			// clean search folders
			cleanSearchFolders();

			// Include webclient
			include("client/webclient.php");
		}
	} else { // Not authenticated, goto login page
		// Create global language object
		$GLOBALS["language"] = new Language();
		$GLOBALS["language"]->setLanguage(LANG);

		include("client/login.php");
	}
?>
