/**
 * --View--
 * @author	Michael Erkens <m.erkens@zarafa.com>
 * @classDescription	View base class
 *  
 * DEPENDS ON:
 * |------> view.js
 * |----+-> *listmodule.js
 * |    |----> listmodule.js
 */

/**
 * TODO: implement default functions
 */

View.prototype.constructor = View;

/**
 * @constructor
 * @param {Int} moduleID
 * @param {HtmlElement} element
 * @param {Object} events
 * @param {XmlElement} data
 */
function View(moduleID, element, events, data)
{
}

/**
 * Function will render the view and execute this.resizeView when done
 */
View.prototype.initView = function()
{
}

View.prototype.destructor = function()
{
}

View.prototype.execute = function()
{
}

View.prototype.showEmptyView = function()
{
}

/**
 * Function will resize all elements in the view
 */
View.prototype.resizeView = function()
{
}

/**
 * Function will show Loading text in view
 */
View.prototype.loadMessage = function()
{
	if (this.element){
		dhtml.removeEvents(this.element);
		dhtml.deleteAllChildren(this.element);
	
		this.element.innerHTML = "<center>" + _("Loading") + "...</center>";
		document.body.style.cursor = "wait";
	}
}

/**
 * Function will delete load text in view
 */
View.prototype.deleteLoadMessage = function()
{
	if (this.element){
		dhtml.deleteAllChildren(this.element);
		document.body.style.cursor = "default";
	}
}

/**
 * Get/Set cursor position, default is to ignore
 */
 
View.prototype.setCursorPosition = function(id)
{
}

View.prototype.getCursorPosition = function()
{
	return;
}

/*
 * Modify the data set in the constructor
 */
View.prototype.setData = function(data)
{
}

View.prototype.getRowNumber = function(elemid)
{
	return;
}

View.prototype.getElemIdByRowNumber = function(rownum)
{
	return;
}

View.prototype.getRowCount = function()
{
	return;
}

