/**
 * ItemModule
 * The module to load, save and delete one item. 
 */
ItemModule.prototype = new Module;
ItemModule.prototype.constructor = ItemModule;
ItemModule.superclass = Module.prototype;

function ItemModule(id, element)
{
	if(arguments.length > 0) {
		this.init(id, element);
	}
}

/**
 * Function which intializes the module.
 * @param integer id id
 * @param object element the element for the module
 */ 
ItemModule.prototype.init = function(id, element)
{
	ItemModule.superclass.init.call(this, id, element);
	
	this.storeid = false;
	this.parententryid = false;
	this.messageentryid = false;
	
	this.rootentryid = false;
	this.attachNum = false;
	
	this.attachments = new Array();
	this.newattachments = new Array();
	this.deletedattachments = new Object();
	this.owner = false;

	// Contains all the properties for the item in this module
	this.itemProps = new Object();

}

/**
 * Function which execute an action. This function is called by the XMLRequest object.
 * @param string type the action type
 * @param object action the action tag 
 */ 
ItemModule.prototype.execute = function(type, action)
{
	switch(type)
	{
		case "item":
			this.item(action);
			webclient.menu.showMenu();
			break;
	}
}

/**
 * Function which sets the properties for the item.
 * @param object action the action tag 
 */  
ItemModule.prototype.item = function(action)
{

	var message = action.getElementsByTagName("item")[0];

	if(message && message.childNodes) {
		// remember item properties
		this.updateItemProps(message);
		
		if(message.getElementsByTagName("conflictitems").length) {
			var conflict = dhtml.getElementById("conflict");
			dhtml.addEvent(this, conflict, "click", eventConflictClick);
			conflict.style.display = "block";
			if(typeof parentWebclient != "undefined" && parentWebclient) {
				var specialfolder = parentWebclient.hierarchy.isSpecialFolder('conflicts', dhtml.getXMLValue(message, "parent_entryid", ""));
			}else{
				var specialfolder = webclient.hierarchy.isSpecialFolder('conflicts', dhtml.getXMLValue(message, "parent_entryid", ""));
			}
			if(specialfolder){
				dhtml.addElement(conflict, "p", false, false, _('You made changes to another copy of this item. Click here to replace the existing item with this version.'));
			}else{
				dhtml.addElement(conflict, "p", false, false, _('You made changes to another copy of this item. This is the most recent version. Click here to see the other versions.'));
			}
			//this function adds one extra row, which spoils the layout, to fix that layout call resizeBody.
			if(typeof resizebody != "undefined")
				resizeBody();
		}else{
		    var conflictElement = dhtml.getElementById("conflict");
		    
		    if(conflictElement)
		        conflictElement.style.display = "none";
		}
		
		this.setRecipients(message);
		var attachments = message.getElementsByTagName("attachment");
	
		if(attachments && attachments.length > 0) {
			for(var i = 0; i < attachments.length; i++)
			{
				var attach_num = attachments[i].getElementsByTagName("attach_num")[0];
				var attach_method = attachments[i].getElementsByTagName("attach_method")[0];
				var name = attachments[i].getElementsByTagName("name")[0];
				var size = attachments[i].getElementsByTagName("size")[0];
				
				if(attach_num && attach_num.firstChild) {
					var attachment = new Object();
					attachment["attach_num"] = attach_num.firstChild.nodeValue;
					
					if(attach_method && attach_method.firstChild) {
						attachment["attach_method"] = attach_method.firstChild.nodeValue;
					}
					
					if(name && name.firstChild) {
						attachment["name"] = name.firstChild.nodeValue;
					}
					
					if(size && size.firstChild) {
						attachment["size"] = size.firstChild.nodeValue;
					}
					
					this.attachments.push(attachment);
				}
			}
		}
	
		this.setProperties(message);
		this.setAttachments(message);
		this.setBody(message);
		this.setFrom(message);
	}
	
	if(this.executeOnLoad) {
		this.executeOnLoad();
	}
}	

ItemModule.prototype.setProperties = function(message)
{
	for(var i = 0; i < message.childNodes.length; i++)
	{
		var property = message.childNodes[i];

		if(property) {
			var element = dhtml.getElementById(property.tagName);
			
			if(element) {
				// exclude "attachments" and "recipients" because we know that these are not
				// directly used as a value in the form. they are processed by 'setAttachments'
				// and 'setRecipients'.
				if (property.tagName == "attachments" || property.tagName == "recipients")
					continue;

				if(property.attributes && property.attributes.length > 0) {
					for(var j = 0; j < property.attributes.length; j++)
					{
						var item = property.attributes.item(j);
						if (item.nodeName!="type"){
							element.setAttribute(item.nodeName, item.nodeValue);
						}
					}
				}
				var value = "";
				if (property.firstChild){
					value = property.firstChild.nodeValue;
				}
				if (property.getAttribute("type") == "timestamp"){		
					value = strftime(_("%a %x %X"), property.firstChild.nodeValue);
				}
				if (value == null){
					value = "";
				}
				switch(element.tagName.toLowerCase()) 
				{
					case "span": 
					case "div": 
						element.innerHTML = value.htmlEntities();
						break; 
					default:
					case "input": 
					case "textarea": 
						element.value = value;
						break; 
				}
			}
		}
	}
} 

/**
 * Function which sets the attachments
 */ 
ItemModule.prototype.setAttachments = function()
{
	var attachmentsElement = dhtml.getElementById("itemattachments");

	if(attachmentsElement) {
		attachmentsElement.innerHTML = "";
			
		// Message attachments
		this.addAttachments(attachmentsElement, this.attachments);
		// Uploaded attachments
		this.addAttachments(attachmentsElement, this.newattachments);
	
		if(attachmentsElement.innerHTML.length <= 0) {
			attachmentsElement.innerHTML = "&nbsp;";
		}
		
		if(attachmentsElement.offsetHeight > 30) {
			attachmentsElement.style.height = "32px";
		}
	}
}

/**
 * Function which adds the attachments to the view.
 * @param object attachmentsElement element
 * @param array attachments the attachments 
 */  
ItemModule.prototype.addAttachments = function(attachmentsElement, attachments)
{
	if(attachments && attachments.length > 0) {
		for(var i = 0; i < attachments.length; i++)
		{
			var attachment = attachments[i];
			
			if(attachment["attach_num"]) {
				if(typeof(this.deletedattachments[attachment["attach_num"]]) == "undefined") {
					if(name && name.firstChild) {
						attachment["name"] = name.firstChild.nodeValue;
					}
					
					var kb = "0";
					if(attachment["size"]) {
						kb = Math.round(attachment["size"] / 1024) + _("kb");
						if(attachment["size"] < 1024) {
							kb = attachment["size"] + _("B");
						}
					}
					
					var attachmentElement = dhtml.addElement(attachmentsElement, "span");
					attachmentElement.innerHTML = attachment["name"] + " (" + kb + "); ";
				}
			}
		}
	}
}

/**
 * Function which sets the body
 * @param object message the action tag  
 */ 
ItemModule.prototype.setBody = function(message)
{
	var html_body = dhtml.getElementById("html_body");
	
	if(html_body) {
		var body = message.getElementsByTagName("body")[0];

		if(body && body.childNodes.length > 0) {
			var content = "";
			var element = body.firstChild;
			for(var i = 0; i < body.childNodes.length; i++)
			{
				content += element.nodeValue;
				element = element.nextSibling;
			}

			html_body.value = content;
		}
	}
}

/**
 * Function which sets the From field
 * @param object message the action tag  
 */ 
ItemModule.prototype.setFrom = function(message)
{
	var fromSelect = dhtml.getElementById("from", "select");
	
	var message_flags = parseInt(dhtml.getXMLValue(message, "message_flags", 0), 10);
	if (fromSelect && (message_flags & MSGFLAG_UNSENT)==MSGFLAG_UNSENT){

		var sent_representing_name = dhtml.getXMLValue(message, "sent_representing_name", "");
		var sent_representing_email_address = dhtml.getXMLValue(message, "sent_representing_email_address", "").toLowerCase();

		if(sent_representing_name != "" && sent_representing_email_address != ""){
			var emailString = sent_representing_name + " <" + sent_representing_email_address + ">";
			// Set the selected FROM address (only works when item is already in the list)
			fromSelect.value = emailString;
			if(fromSelect.value != emailString){
				fromSelect.options[fromSelect.options.length] = new Option(emailString);
				fromSelect.options[fromSelect.options.length-1].selected = true;
			}
			var fromRow = dhtml.getElementById("from_row", "tr");
			if(fromRow && fromSelect.options.length > 0){
				fromRow.style.display = "";
			}
		}

	}
}

/**
 * Function which sets the data for this module.
 * @param string storeid store id
 * @param string parententryid parent entry id 
 */  
ItemModule.prototype.setData = function(storeid, parententryid)
{
	if(storeid) {
		this.storeid = storeid;
	}
	
	if(parententryid) { 
		this.parententryid = parententryid;
	}
}

/**
 * Function which opens one item.
 * @param string entryid message entryid
 * @param string rootentryid the root entryid, used for embedded message in embedded message ... (optional)
 * @param array attachNum the attachment numbers, used for embedded message in embedded message ... (optional)
 */ 
ItemModule.prototype.open = function(entryid, rootentryid, attachNum)
{
	if(entryid) {
		this.messageentryid = entryid;
		
		if(rootentryid) {
			this.rootentryid = rootentryid;
		} else {
			this.rootentryid = entryid;
		}
		
		this.attachNum = attachNum;
	
		var data = new Object();
		data["store"] = this.storeid;
		data["parententryid"] = this.parententryid;
		data["entryid"] = entryid;
		
		if(rootentryid) {
			data["rootentryid"] = rootentryid;
			
			if(attachNum && attachNum.push) {
				data["attachments"] = new Object();
				data["attachments"]["attach_num"] = new Array();
				
				for(var i = 0; i < attachNum.length; i++)
				{
					data["attachments"]["attach_num"].push(attachNum[i]);
				}
			}
		}
		
		webclient.xmlrequest.addData(this, "open", data);
		webclient.xmlrequest.sendRequest();
	} else {
		webclient.menu.showMenu();
	}
}

/**
 * Function which saves an item.
 * @param object props the properties to be saved
 * @param string dialog_attachments used to add attachments (optional)   
 */ 
ItemModule.prototype.save = function(props, send, recipients, dialog_attachments)
{
	var data = new Object();
	if(this.storeid) {
		data["store"] = this.storeid;
	}
	
	if(this.parententryid)
		data["parententryid"] = this.parententryid;
		
	data["props"] = props;
	if (recipients)
		data["recipients"] = recipients;

	if (dialog_attachments)
		data["dialog_attachments"] = dialog_attachments;
	
	if(this.message_action) {
		data["message_action"] = new Object();
		data["message_action"]["action_type"] = this.message_action;
		data["message_action"]["entryid"] = this.message_action_entryid;
	}
	
	if(send) {
		data["send"] = true;
	}

	if(parentWebclient) {
		parentWebclient.xmlrequest.addData(this, "save", data, webclient.modulePrefix);
		parentWebclient.xmlrequest.sendRequest(true);
	} else {
		webclient.xmlrequest.addData(this, "save", data);
		webclient.xmlrequest.sendRequest();
	}
}

/**
 * Function which deletes an item 
 */ 
ItemModule.prototype.deleteMessage = function()
{
	if(this.messageentryid) {
		var data = new Object();
		data["store"] = this.storeid;
		data["parententryid"] = this.parententryid;
		data["entryid"] = this.messageentryid;

		/**
		 * This function is also called from main window,
		 * so need to perform typeof() check.
		 */
		if(typeof(parentWebclient) != "undefined") {
			parentWebclient.xmlrequest.addData(this, "delete", data, webclient.modulePrefix);
			parentWebclient.xmlrequest.sendRequest(true);
		} else {
			webclient.xmlrequest.addData(this, "delete", data);
			webclient.xmlrequest.sendRequest();
		}
	}
}

ItemModule.prototype.setRecipients = function(message, actionType)
{
	var sender_email_address = dhtml.getXMLValue(message, "sent_representing_email_address", "").toLowerCase();
	var sender_email_name = dhtml.getXMLValue(message, "sent_representing_name", "");
	var sender_email_address = nameAndEmailToString(sender_email_name, sender_email_address);
	
	var elemdata = new Array();

	var recipients = message.getElementsByTagName("recipient");

	if(recipients && recipients.length > 0) {
		for(var i = 0; i < recipients.length; i++)
		{
			var recipient = recipients[i];
			if(dhtml.getXMLValue(recipient, "pr_recipient_flags", false)!= 3){
				var display_name = dhtml.getXMLValue(recipient, "display_name", "");
				var email_address = dhtml.getXMLValue(recipient, "email_address", "").toLowerCase();
				var type = dhtml.getXMLValue(recipient, "type", "");
				var entryid = dhtml.getXMLValue(recipient, "entryid", "");

				if (!(actionType && actionType == "replyall" && entryid==webclient.userEntryid)){
					if(type && email_address) {
					    if(typeof(elemdata[type]) == "undefined") elemdata[type] = new Array();
					    
                        elemdata[type].push(nameAndEmailToString(display_name,email_address,false));
					} else if(type && display_name) {
						// if unresolved email address
						var element = dhtml.getElementById(type);
						if(element){
							elemdata[type].push(display_name);
						}
					}
				}
			}else{
				this.owner = new Object;
				this.owner["display_name"] = dhtml.getXMLValue(recipient, "display_name", false);
				this.owner["email_address"] = dhtml.getXMLValue(recipient, "email_address", false);
				this.owner["type"] = dhtml.getXMLValue(recipient, "type", false);
				this.owner["recipienttype"] = dhtml.getXMLValue(recipient, "entryid", false);
				this.owner["recipient_flags"] = dhtml.getXMLValue(recipient, "recipient_flags", 1);
			}
		}
	}
	// create a unique array of elementdata
	// this stops entering same user in type field multiple times
	for(var type in elemdata){
		//create a unique array.
		var elementArray = uniqueArray(elemdata[type]);
		if(actionType == "replyall"){
			//flag to check whether the sender is already in to field or not?
			var tosenderflag = false;
			//check if the sender is already in to field or not, if yes then make the flag true and break;
			for(var y in elemdata["to"]){
				if(elemdata["to"][y].indexOf(sender_email_address)!=-1){
					tosenderflag = true;
					break;
				}
			}
			// now check if the sender is present in to and also in cc, 
			// if yes then remove from cc field
			if(type == "cc"){
				for(var x in elementArray){
					if(elementArray[x].indexOf(sender_email_address)!=-1){
						if(!tosenderflag){
							elementArray.splice(x,1);
						}
					}
				}
			}
		}
		//re assign the values
		elemdata[type] = elementArray;
	}
	// set the data to elements.
	for(var type in elemdata) {
	    var element = dhtml.getElementById(type);
	    
	    if(element) element.value += elemdata[type].join("; ");
    }
}

/**
 * Functions to do meeting requests. These are used from various modules, including the readitemmodule, the previewreaditemmodule and the appointmentitemmodule
 */
ItemModule.prototype.sendAcceptMeetingRequest = function(tentative)
{
	var req = new Object;
	
	req['entryid'] = this.messageentryid;
	req['store'] = this.storeid;
	req['tentative'] = tentative;
	
	if(typeof parentWebclient != "undefined") {
		parentWebclient.xmlrequest.addData(this, 'acceptMeetingRequest', req, webclient.modulePrefix);
		parentWebclient.xmlrequest.sendRequest(true);
	} else {
		webclient.xmlrequest.addData(this, 'acceptMeetingRequest', req);
		webclient.xmlrequest.sendRequest();
	}
}
/**
 * Functions to do meeting requests. These are used from various modules, including the readitemmodule, the previewreaditemmodule and the appointmentitemmodule
 */
ItemModule.prototype.sendProposalMeetingRequest = function(start, end, body)
{
	var req = new Object;
	var proposalinfo = new String();
	var gmt = new String(new Date(start));
	gmt = " "+ gmt.substring(gmt.indexOf(_("GMT")));
	
	req['entryid'] = this.messageentryid;
	req['store'] = this.storeid;
	req['tentative'] = 1;
	req['proposed_starttime'] = start;
	req['proposed_endtime'] = end;
	req['proposed_duration'] = 1;
	req['counter_proposal'] = true;
	req['body'] = (body)?body:null;

	webclient.xmlrequest.addData(this, 'acceptMeetingRequest', req);
	webclient.xmlrequest.sendRequest();
}


ItemModule.prototype.sendDeclineMeetingRequest = function()
{
	var req = new Object;
	
	req['entryid'] = this.messageentryid;
	req['store'] = this.storeid;
	
	if(typeof parentWebclient != "undefined") {
		parentWebclient.xmlrequest.addData(this, 'declineMeetingRequest', req, webclient.modulePrefix);
		parentWebclient.xmlrequest.sendRequest(true);
	} else {
		webclient.xmlrequest.addData(this, 'declineMeetingRequest', req);
		webclient.xmlrequest.sendRequest();
	}
}

ItemModule.prototype.acceptMeetingRequest = function()
{
	this.sendAcceptMeetingRequest(0);
}

ItemModule.prototype.proposalMeetingRequest = function(start, end, body)
{
	this.sendProposalMeetingRequest(start, end, body);
}

ItemModule.prototype.tentativeMeetingRequest = function()
{
	this.sendAcceptMeetingRequest(1);
}

ItemModule.prototype.removeFromCalendar = function()
{
	var req = new Object;
	
	req['entryid'] = this.messageentryid;
	req['store'] = this.storeid;
	
	if(typeof parentWebclient != "undefined") {
		parentWebclient.xmlrequest.addData(this, 'removeFromCalendar', req, webclient.modulePrefix);
		parentWebclient.xmlrequest.sendRequest(true);
	} else {
		webclient.xmlrequest.addData(this, 'removeFromCalendar', req);
		webclient.xmlrequest.sendRequest();
	}
}

ItemModule.prototype.resolveConflict = function()
{
	if(typeof parentWebclient != "undefined" && parentWebclient) {
		var wc = parentWebclient;
	}else{
		var wc = webclient;
	}
	if(wc.hierarchy.isSpecialFolder('conflicts', this.itemProps["parent_entryid"])){
		if(confirm(_("You will lose the modified data. Do you want to continue?"))){
			var data = new Object();
			data["store"] = this.storeid;
			data["parententryid"] = this.parententryid;
			data["entryid"] = this.messageentryid;
			if(typeof(this.itemProps["conflictitems"]["bin"]) == "string"){
				data["conflictentryid"] = this.itemProps["conflictitems"]["bin"];
			}else{
				data["conflictentryid"] = this.itemProps["conflictitems"]["bin"][0];
			}
			wc.xmlrequest.addData(this, "resolveConflict", data, webclient.modulePrefix);
			wc.xmlrequest.sendRequest();
			dhtml.getElementById("conflict").style.display = "none";
			
			if(window.opener){
				window.opener.opener = top;
				window.opener.close()
				resizeBody();
			}
		}
	}else{
		var conflictitems = this.itemProps["conflictitems"]["bin"];
		if(typeof(conflictitems) == "string"){
			conflictitems = new Array(conflictitems);
		}
		for(var i=0;i<conflictitems.length;i++){
			if (typeof this.itemProps["message_class"] != "undefined"){
				var message_class = this.itemProps["message_class"];
			}else{
				message_class = "IPM.Note";
			}
			message_class = message_class.replace(/\./g, "_").toLowerCase();
			switch(message_class) {
				case "ipm_note":
				case "ipm_post":
				case "report_ipm_note_ndr":
				case "ipm_schedule_meeting_request":
				case "ipm_schedule_meeting_resp_pos":
				case "ipm_schedule_meeting_resp_tent":
				case "ipm_schedule_meeting_resp_neg":
				case "report_ipm_note_ipnnrn":
				case "report_ipm_note_ipnrn":
					message_class = "ipm_readmail";
					break;
			}
			if(message_class.indexOf("ipm_") >= 0) {
				message_class = message_class.substring(message_class.indexOf("_") + 1);
			}
			var uri = DIALOG_URL+"task=" + message_class + "_standard&storeid=" + this.storeid + "&entryid=" + conflictitems[i] + "&parententryid=" + this.parententryid;
			webclient.openWindow(false, message_class, uri);
		}
	}
}

ItemModule.prototype.declineMeetingRequest = function()
{
	this.sendDeclineMeetingRequest();
}

ItemModule.prototype.updateItemProps = function(item)
{
	this.itemProps = new Object();
	for(var j=0;j<item.childNodes.length;j++){
		if (item.childNodes[j].nodeType == 1){
			var prop_name = item.childNodes[j].tagName;
			var prop_val = dom2array(item.childNodes[j]);
			if (prop_val!==null){
				this.itemProps[prop_name] = prop_val;
			}
		}
	}
}

function eventConflictClick(moduleObject, element, event)
{
	moduleObject.resolveConflict();
}

/**
 * Function which deletes out-of-date meeting request.
 */
function eventPreviewItemNotCurrentClick(moduleObject, element, event)
{
	if (confirm(_("This meeting request is out-of-date and will now be deleted."))) {
		moduleObject.deleteMessage();
		
		//Close window if meeting request is opened.
		if (typeof(parentWebclient) != "undefined"){
			window.close();
		}
	}
}
