/**
 *@author Michael Erkens <m.erkens@connectux.com>
 */ 
addressbooklistmodule.prototype = new ListModule;
addressbooklistmodule.prototype.constructor = addressbooklistmodule;
addressbooklistmodule.superclass = ListModule.prototype;

function addressbooklistmodule(id, element, title, data)
{
	if(arguments.length > 0) {
		this.init(id, element, title, data);
	}
}

addressbooklistmodule.prototype.init = function(id, element, title, data)
{
	addressbooklistmodule.superclass.init.call(this, id, element, title, data);

	this.initializeView();

	this.action = "list";

	this.enableVariableColumns = false;
	
	// We don't want rowcolumn events since it makes it slower
    delete this.events["rowcolumn"];
    	
	var items = new Array();
	items.push(webclient.menu.createMenuItem("select", _("Select"), false, eventListContextMenuOpenMessage));
	this.contextmenu = items;
}

addressbooklistmodule.prototype.retrieveHierarchy = function()
{
	var data = new Object();
	if (this.source=="all"||this.source=="gab"){
		data["gab"] = "all";
	}
	if (this.source=="all"||this.source=="contacts"){
		data["contacts"] = {stores:{store:new Array(),folder:new Array()}}
		for(var i=0;i<parentWebclient.hierarchy.stores.length;i++){
			var store = parentWebclient.hierarchy.stores[i];
			switch(store.foldertype){
				case "contact":
					data["contacts"]["stores"]["folder"].push(store.id);
					break;
				case "all":
					data["contacts"]["stores"]["store"].push(store.id);
					break;
			}
		}
	}

	webclient.xmlrequest.addData(this, "hierarchy",data);
}

addressbooklistmodule.prototype.execute = function(type, action)
{
	webclient.menu.showMenu();
	
	switch(type)
	{
		case "list":
			this.messageList(action);
			break;
		case "hierarchy":
			this.updateHierarchy(action);
			break;
		case "item":
			this.item(action);
			break;
	}
}

addressbooklistmodule.prototype.list = function(action, noLoader, restriction)
{
	if(this.storeid) {
		if(action && action != false) {
			this.action = action;
		}
	
		var data = new Object();
		data["store"] = this.storeid;
		data["entryid"] = this.entryid;
		var contactfolder = dhtml.getElementById("addressbookfolders");
		if(contactfolder && contactfolder.value){
			data["store"] = contactfolder.options[ contactfolder.selectedIndex ].storeid;
		}
		
		this.sort = this.loadSortSettings();
		if(this.sort) {
			data["sort"] = new Object();
			data["sort"]["column"] = this.sort;
		}

		if(restriction) {
			data["restriction"] = new Object();
			data["restriction"]["name"] = new Array(restriction);
		} 

		if(typeof(this.groups)=="string"){
			data["groups"] = this.groups;
		}

		webclient.xmlrequest.addData(this, this.action, data);
		webclient.xmlrequest.sendRequest();

		if (!noLoader)
			this.viewController.loadMessage();
	}
}


/**
* This function will return the index of a property column in the table view
*
* TODO: move this to the table view, but for now I only need it here
*/
addressbooklistmodule.prototype.getPropertyIndex = function(fieldname)
{
	var result = -1, i = 0;
	while(result<0 && i<module.properties.length){
		var property = module.properties[i];
		if (property.id == fieldname){
			result = parseInt(property.order,10);
		}
		i++;
	}
	if (result == -1){
		result = false;
	}
	return result;
}

addressbooklistmodule.prototype.saveSortSettings = function (data)
{
	var path = "addressbook/sort";
	webclient.settings.deleteSetting(path);
	webclient.settings.setArray(path,data);
}

addressbooklistmodule.prototype.loadSortSettings = function ()
{
	var path = "addressbook/sort";
	
	var column = new Object();
	column["attributes"] = new Object();
	data = webclient.settings.get(path);
	for(var i in data){
		if(i != "prototype"){//workarround		
			column["attributes"]["direction"] = data[i];
			column["_content"] = i;
		}
	}
	if(!column["_content"]){
		var result = false;
	}else{
		var result = new Array(column);
	}
	return result;
}

addressbooklistmodule.prototype.updateHierarchy = function(action)
{
	var items = action.getElementsByTagName("folder");
	if (!items)
		return;

	var defaultEntryid = webclient.settings.get("addressbook/default/entryid","");
	var folderList = dhtml.getElementById("addressbookfolders");
	for(var i=0;i<items.length;i++){
		var folder = dom2array(items[i]);

		var name = folder.display_name;
		if (folder["parent_entryid"] && folder["parent_entryid"]!=folder["entryid"]){
			name = NBSP+NBSP+name;	
		}
		
		var newOption = dhtml.addElement(folderList, "option", null, null, name);
		newOption.value = folder["entryid"];
		if (folder["entryid"]==defaultEntryid){
			newOption.selected = true;
		}
		newOption.folderType = folder["type"];
		if (typeof(folder["storeid"])!="undefined")
			newOption.storeid = folder["storeid"];

	}
}

// Override listmodule's onOpenItem to do nothing; we don't want to open the item when it is clicked
addressbooklistmodule.prototype.onOpenItem = function() {
}
