<?php
	/**
	* This file is called every time the user request a dialog window
	*
	* To specify which dialog the user want, use the GET attribute 'type',
	* the types are specified in /client/layout/html
	*
	* @author Michael Erkens <michael@connectux.com>
	*/
	require("client/layout/dialogs/utils.php");

	if(isset($_POST["dialog_attachments"])) {
		include("server/upload_attachment.php");
	}
	
	$task = false;
	if(isset($_GET["task"])) {
		$task = $_GET["task"];
	}

	if($task) {
		// check for invalid characters in filename
		if (!isset($task) || preg_match("/[^a-z0-9\-\_]/i", $task)){
			trigger_error("invalid input", E_USER_ERROR);
		}
		
		$type = false;
		if(strpos($task, "_") > 0) {
			$type = substr($task, strrpos($task, "_") + 1);
			$task = substr($task, 0, strrpos($task, "_"));
		}

		if($type) {
			// check if file exists
			$filename = "client/layout/dialogs/" . $type . "/" . $task . ".php";
			
			if (!is_readable($filename)){
				// fallback to IPM.Note if message_class is IPM.Note.*
				if (substr($task,0,4)=="note"){
					$filename = "client/layout/dialogs/" . $type . "/readmail.php";
				}else{
					$filename = "client/layout/dialogs/not_implemented.php";
				}
			}
			include($filename);
			include("client/layout/dialogs/window.php");
		}else{
			echo "<html><head><title>Invalid tasktype</title></head><body><h1>Invalid tasktype</h1></body></html>";
		}
	}else{
		echo "<html><head><title>Invalid task</title></head><body><h1>Invalid task</h1></body></html>";
	}
?>
