'\"
'\" Generated from file '/usr/ports/obj/tklib-0.5/tklib-0.5/modules/ipentry/ipentry.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ipentry" n 0.3 ipentry "An IP address entry widget"
.BS
.SH NAME
ipentry \- An IP address entry widget
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBTk  8.4\fR
.sp
package require \fBipentry  ?0.3?\fR
.sp
\fB::ipentry::ipentry\fR \fIpathName\fR ?\fIoption\fR \fIvalue\fR...?
.sp
\fB::ipentry::ipentry6\fR \fIpathName\fR ?\fIoption\fR \fIvalue\fR...?
.sp
\fIpathName\fR \fBcomplete\fR
.sp
\fIpathName\fR \fBget\fR
.sp
\fIpathName\fR \fBinsert\fR \fIiplist\fR
.sp
\fIpathName\fR \fBicursor\fR \fIindex\fR
.sp
\fIpathName\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR...
.sp
\fIpathName\fR \fBcget\fR \fIoption\fR
.sp
.BE
.SH DESCRIPTION
This package provides a widget for the entering of a IP address.
.PP
.TP
\fB::ipentry::ipentry\fR \fIpathName\fR ?\fIoption\fR \fIvalue\fR...?
Creates a new IPv4 ipentry widget and configures it with the given options and
their values.
.TP
\fB::ipentry::ipentry6\fR \fIpathName\fR ?\fIoption\fR \fIvalue\fR...?
Creates a new ipentry widget for the entry of an IPv6 address. All options
are the same as the IPv4 widget.
.PP
Each widget created with the command above supports the following methods:
.TP
\fIpathName\fR \fBcomplete\fR
Returns a boolean value. True indicates that the entry contains a
complete IP address, meaning all fields have a value. In some cases
IPv6 address are valid when fields are missing. You will need to do your
own validation to detect this.
.TP
\fIpathName\fR \fBget\fR
Returns the contents of the entry as a list consisting of 4 or 8 elements.
.TP
\fIpathName\fR \fBinsert\fR \fIiplist\fR
IPv4
Takes a list of 4 elements and inserts one into each quad of the entry, in order.
All values in the list must be empty or integers. Values outside the range 0 to 255
are modified to be within the range.
IPv6
Takes a list of 8 elements and inserts one into each quad of the entry, in order.
All values in the list must be empty or 1 to 4 hex digits.
.TP
\fIpathName\fR \fBicursor\fR \fIindex\fR
Sets the position of the widgets insertion cursor. Only integer values between
0 and 15 are valid for ipentry and 0 to 31 for ipentry6.
Setting the icursor will only have an effect if the widget
already has the input focus.
.TP
\fIpathName\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR...
Modifies the configuration of the widget. For options and
their meaning see the widget options section.
.TP
\fIpathName\fR \fBcget\fR \fIoption\fR
Returns information about the current configuration of the widget, for
the specified option. For options and their meaning see the widget
options section.
.PP
.SH "WIDGET OPTIONS"
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-textvariable\fR
Database Name:	\fBtextvariable\fR
Database Class:	\fBVariable\fR

.fi
.IP
The name of a variable which holds the value of the IP address.
The value must be a string of the form NNN.NNN.NNN.NNN for IPv4 or
HHHH:HHHH:HHHH:HHHH:HHHH:HHHH:HHHH:HHHH for IPv6 where H is a hex digit.
The variable will be modified to represent a valid IP address if it is not
already.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-state\fR
Database Name:	\fBstate\fR
Database Class:	\fBState\fR

.fi
.IP
Specifies one of three states for the entry: \fBnormal\fR,
\fBdisabled\fR, or \fBreadonly\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-font\fR
Database Name:	\fBfont\fR
Database Class:	\fBFont\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-bd\fR
Database Name:	\fBborderWidth\fR
Database Class:	\fBBorderWidth\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-fg\fR
Database Name:	\fBforeground\fR
Database Class:	\fBForeground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-bg\fR
Database Name:	\fBbackground\fR
Database Class:	\fBBackground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-relief\fR
Database Name:	\fBrelief\fR
Database Class:	\fBRelief\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-highlightthickness\fR
Database Name:	\fBhighlightThickness\fR
Database Class:	\fBHighlightThickness\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-highlightcolor\fR
Database Name:	\fBhighlightColor\fR
Database Class:	\fBHighlightColor\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-highlightbackground\fR
Database Name:	\fBhighlightBackground\fR
Database Class:	\fBHighlightBackground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-selectbackground\fR
Database Name:	\fBselectBackground\fR
Database Class:	\fBBackground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-selectforeground\fR
Database Name:	\fBselectForeground\fR
Database Class:	\fBForeground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-selectborderwidth\fR
Database Name:	\fBselectBorderWidth\fR
Database Class:	\fBBorderWidth\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-disabledbackground\fR
Database Name:	\fBdisabledBackground\fR
Database Class:	\fBDisabledBackground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-disabledforeground\fR
Database Name:	\fBdisabledForeground\fR
Database Class:	\fBDisabledForeground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-readonlybackground\fR
Database Name:	\fBreadonlyBackground\fR
Database Class:	\fBReadonlyBackground\fR

.fi
.IP
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-insertbackground\fR
Database Name:	\fBinsertBackground\fR
Database Class:	\fBBackground\fR

.fi
.IP
Standard widget options. See \fBoptions\fR for a description of their
meanings and values.
.PP
.SH KEYWORDS
entry, ip address