<?php
/**
 * @category Horde
 * @package Horde
 */

namespace Horde;

/**
 * Horde base exception class, which includes the ability to take the
 * output of error_get_last() as $code and mask itself as that error.
 *
 * @category Horde
 * @package Horde
 */
class Exception extends ::Exception
{
    /**
     * Exception constructor
     *
     * If $code_or_lasterror is passed the return value of
     * error_get_last() (or a matching format), the exception will be
     * rewritten to have its file and line parameters match that of
     * the array, and any message in the array will be appended to
     * $message.
     *
     * @param string $message The exception message
     * @param mixed $code_or_lasterror Either a numeric error code, or
     * an array from error_get_last()
     */
    public function __construct($message = null, $code_or_lasterror = 0)
    {
        if (is_array($code_or_lasterror)) {
            if ($message) {
                $message .= $code_or_lasterror['message'];
            } else {
                $message = $code_or_lasterror['message'];
            }

            $this->file = $code_or_lasterror['file'];
            $this->line = $code_or_lasterror['line'];
            $code = $code_or_lasterror['type'];
        } else {
            $code = $code_or_lasterror;
        }

        parent::__construct($message, $code);
    }

}
