<?php
	/**
	 * Task Module
	 * @author Johnny Biemans <j.biemans@connectux.com>
	 */
	class TaskListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function TaskListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getTaskProperties();
			
			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "icon_index", true, 0, _("Icon"), _("Sort On Icon"), 25);
			$this->addColumn($this->tablecolumns, "complete", true, 1, _("Complete"), _("Sort On Complete"), 25);
			$this->addColumn($this->tablecolumns, "importance", true, 2, _("Priority"), _("Sort On Priority"));
			$this->addColumn($this->tablecolumns, "subject", true, 3, _("Subject"), _("Sort On Subject"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "duedate", true, 4, _("Due Date"), _("Sort On Due Date"));
			
			$this->addColumn($this->tablecolumns, "owner", true, 5, _("Owner"), _("Sort On Owner"));
			$this->addColumn($this->tablecolumns, "categories", false, 6, _("Categories"), _("Sort On Categories"));
			$this->addColumn($this->tablecolumns, "percent_complete", false, 7, _("% Completed"), _("Sort On Percent Completed"), 100);
			$this->addColumn($this->tablecolumns, "hidden_column", true, 8);
			
			
			/*
			*NOTE:
			*1)If value of visibility of any column in above table(i.e tablecolumns) is modifyed,
			*then the same is to be done in the table defined below(i.e insertcolumns) for the respective columns.
			*2)$name parameter of addInputColumn() should contain the value of id of corresponding header column.
			*/
			
			$userdata = $_SESSION["username"];
			$storeid = $data[0]["store"];
			$entryid = $data[0]["entryid"];
			
			$session = $GLOBALS["mapisession"]->getSession();			
			$store = mapi_openmsgstore($session, hex2bin($storeid));	
			$result = mapi_last_hresult();		
			$storeProps = mapi_getprops($store , array(PR_DISPLAY_NAME, PR_MDB_PROVIDER));			
			switch($storeProps[PR_MDB_PROVIDER]){
				  case ZARAFA_SERVICE_GUID:
					$readonly= "readonly";
				    break;
				  
				  case ZARAFA_STORE_PUBLIC_GUID:
				    $readonly = "";
				    break;
			}
			
			$username = mapi_zarafa_getuser_by_name($store,$userdata);			
			
			$this->insertcolumns = array();
			$this->addInputColumn($this->insertcolumns, "icon", "null", true, "", 0, "icon_index",false,  23);
			$this->addInputColumn($this->insertcolumns, "status", "checkbox", true, "", 1, "complete",false,  23);
			$this->addInputColumn($this->insertcolumns, "importance", "importance", true, "", 2, "importance",false);
			$this->addInputColumn($this->insertcolumns, "subject", "textbox", true, "", 3, "subject",_("Click here to add a new item"),PERCENTAGE);
			$this->addInputColumn($this->insertcolumns, "text_duedate", "datepicker", true, "readonly", 4,"duedate",false,150);

			$this->addInputColumn($this->insertcolumns, "owner", "textbox", true, $readonly, 5, "owner", w2u($username["fullname"]), 150);
			$this->addInputColumn($this->insertcolumns, "categories", "categories", false, "", 6, "categories",false, 150);
			$this->addInputColumn($this->insertcolumns, "text_percent_complete", "percent", false, "readonly", 7,"percent_complete",_("0%"), 100);
			$this->addInputColumn($this->insertcolumns, "hiddencolumn", "hidden", false, "", 8,"hidden_column");

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->sort = array();
			$this->sort[$this->properties["duedate"]] = TABLE_SORT_DESCEND;
			
			$this->start = 0;
		}
	}
?>
