taskitemmodule.prototype = new ItemModule;
taskitemmodule.prototype.constructor = taskitemmodule;
taskitemmodule.superclass = ItemModule.prototype;

function taskitemmodule(id)
{
	if(arguments.length > 0) {
		this.init(id);
	}
}

taskitemmodule.prototype.init = function(id)
{
	taskitemmodule.superclass.init.call(this, id);
}

taskitemmodule.prototype.executeOnLoad = function()
{
	initTask();
}

taskitemmodule.prototype.item = function(action)
{
	var dateFields = ["duedate", "startdate", "datecompleted"];

	for(var j=0; j<dateFields.length; j++){
		var dateElements = action.getElementsByTagName(dateFields[j]);
		for(var i=0; i<dateElements.length; i++){
			if (dateElements[i].attributes && dateElements[i].attributes["unixtime"]){
				dateElements[i].firstChild.nodeValue = strftime_gmt(_("%a %x"), dateElements[i].firstChild.nodeValue);
			}
		}
	}

	taskitemmodule.superclass.item.call(this, action);
}

