/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.MailSessionForm;

public final class SetUpMailSessionAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        String objectName = request.getParameter("objectName");
        String resourcetype = request.getParameter("resourcetype");
        String path = request.getParameter("path");
        String host = request.getParameter("host");
        String domain = request.getParameter("domain");
        MailSessionForm mailSessionForm = new MailSessionForm();
        mailSessionForm.setResourcetype(resourcetype);
        mailSessionForm.setPath(path);
        mailSessionForm.setHost(host);
        mailSessionForm.setDomain(domain);
        mailSessionForm.setType("javax.mail.Session");
        if (objectName == null) {
            mailSessionForm.setNodeLabel(resources.getMessage(locale, "resources.actions.mailsession.create"));
            mailSessionForm.setObjectName(null);
            mailSessionForm.setType("javax.mail.Session");
        } else {
            mailSessionForm.setNodeLabel(resources.getMessage(locale, "resources.actions.mailsession.edit"));
            mailSessionForm.setObjectName(objectName);
            String attribute = null;
            try {
                ObjectName oname = new ObjectName(objectName);
                attribute = "name";
                mailSessionForm.setName((String)this.mserver.getAttribute(oname, attribute));
                attribute = "mail.smtp.host";
                mailSessionForm.setMailhost((String)this.mserver.getAttribute(oname, attribute));
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
                return null;
            }
        }
        this.saveToken(request);
        request.setAttribute("mailSessionForm", (Object)mailSessionForm);
        return mapping.findForward("MailSession");
    }
}

