/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

public class Http11Processor
implements Processor,
ActionHook {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$coyote$http11$Http11Processor == null ? (class$org$apache$coyote$http11$Http11Processor = Http11Processor.class$("org.apache.coyote.http11.Http11Processor")) : class$org$apache$coyote$http11$Http11Processor));
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected InternalInputBuffer inputBuffer = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected boolean started = false;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected boolean expectation = false;
    protected Pattern[] restrictedUserAgents = null;
    protected int maxKeepAliveRequests = -1;
    protected SSLSupport sslSupport;
    protected Socket socket;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int timeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected int socketBuffer = -1;
    protected int maxSavePostSize = 4096;
    protected Pattern[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected char[] hostNameC = new char[0];
    protected ThreadPool threadPool;
    protected PoolTcpEndpoint endpoint;
    protected String server = null;
    static /* synthetic */ Class class$org$apache$coyote$http11$Http11Processor;

    public Http11Processor() {
        this(49152);
    }

    public Http11Processor(int headerBufferSize) {
        this.request = new Request();
        this.inputBuffer = new InternalInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer((InputBuffer)this.inputBuffer);
        this.response = new Response();
        this.response.setHook((ActionHook)this);
        this.outputBuffer = new InternalOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer((OutputBuffer)this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
        int foo = HexUtils.DEC[0];
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setEndpoint(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void addNoCompressionUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.noCompressionUserAgents = this.addREArray(this.noCompressionUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            log.error((Object)sm.getString("http11processor.regexp.error", (Object)userAgent), (Throwable)pse);
        }
    }

    public void setNoCompressionUserAgents(Pattern[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        if (noCompressionUserAgents != null) {
            StringTokenizer st = new StringTokenizer(noCompressionUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addNoCompressionUserAgent(st.nextToken().trim());
            }
        }
    }

    public void addCompressableMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeTypes(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        if (compressableMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressableMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressableMimeType(st.nextToken().trim());
            }
        }
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            } else {
                log.warn((Object)sm.getString("http11processor.filter.unknown", (Object)className));
            }
        }
        catch (Exception e) {
            log.error((Object)sm.getString("http11processor.filter.error", (Object)className), (Throwable)e);
        }
    }

    private String[] addStringArray(String[] sArray, String value) {
        String[] result = null;
        if (sArray == null) {
            result = new String[]{value};
        } else {
            result = new String[sArray.length + 1];
            for (int i = 0; i < sArray.length; ++i) {
                result[i] = sArray[i];
            }
            result[sArray.length] = value;
        }
        return result;
    }

    private Pattern[] addREArray(Pattern[] rArray, Pattern value) {
        Pattern[] result = null;
        if (rArray == null) {
            result = new Pattern[]{value};
        } else {
            result = new Pattern[rArray.length + 1];
            for (int i = 0; i < rArray.length; ++i) {
                result[i] = rArray[i];
            }
            result[rArray.length] = value;
        }
        return result;
    }

    private boolean inStringArray(String[] sArray, String value) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!sArray[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.restrictedUserAgents = this.addREArray(this.restrictedUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            log.error((Object)sm.getString("http11processor.regexp.error", (Object)userAgent), (Throwable)pse);
        }
    }

    public void setRestrictedUserAgents(Pattern[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        if (restrictedUserAgents != null) {
            StringTokenizer st = new StringTokenizer(restrictedUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addRestrictedUserAgent(st.nextToken().trim());
            }
        }
    }

    public String[] findRestrictedUserAgents() {
        String[] sarr = new String[this.restrictedUserAgents.length];
        for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
            sarr[i] = ((Object)this.restrictedUserAgents[i]).toString();
        }
        return sarr;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxSavePostSize(int msps) {
        this.maxSavePostSize = msps;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
        this.outputBuffer.setSocketBuffer(socketBuffer);
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setServer(String server) {
        this.server = server == null || server.equals("") ? null : server;
    }

    public String getServer() {
        return this.server;
    }

    public Request getRequest() {
        return this.request;
    }

    public void process(InputStream input, OutputStream output) throws IOException {
        int soTimeout;
        ThreadWithAttributes thrA = (ThreadWithAttributes)Thread.currentThread();
        RequestInfo rp = this.request.getRequestProcessor();
        thrA.setCurrentStage((Object)this.threadPool, "parsing http request");
        rp.setStage(1);
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.localName = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.inputBuffer.setInputStream(input);
        this.outputBuffer.setOutputStream(output);
        this.error = false;
        this.keepAlive = true;
        int keepAliveLeft = this.maxKeepAliveRequests;
        int oldSoTimeout = soTimeout = this.socket.getSoTimeout();
        int threadRatio = 0;
        threadRatio = this.threadPool.getCurrentThreadsBusy() > 0 ? this.threadPool.getCurrentThreadsBusy() * 100 / this.threadPool.getMaxThreads() : this.endpoint.getCurrentThreadsBusy() * 100 / this.endpoint.getMaxThreads();
        if (threadRatio > 33 && threadRatio <= 66) {
            soTimeout /= 2;
        } else if (threadRatio > 66 && threadRatio <= 90) {
            soTimeout /= 3;
            keepAliveLeft = 1;
        } else if (threadRatio > 90) {
            soTimeout /= 20;
            keepAliveLeft = 1;
        }
        if (soTimeout != oldSoTimeout) {
            try {
                this.socket.setSoTimeout(soTimeout);
            }
            catch (Throwable t) {
                log.debug((Object)sm.getString("http11processor.socket.timeout"), t);
                this.error = true;
            }
        }
        boolean keptAlive = false;
        while (this.started && !this.error && this.keepAlive) {
            try {
                if (!this.disableUploadTimeout && keptAlive && soTimeout > 0) {
                    this.socket.setSoTimeout(soTimeout);
                }
                this.inputBuffer.parseRequestLine();
                this.request.setStartTime(System.currentTimeMillis());
                thrA.setParam((Object)this.threadPool, (Object)this.request.requestURI());
                keptAlive = true;
                if (!this.disableUploadTimeout) {
                    this.socket.setSoTimeout(this.timeout);
                }
                this.inputBuffer.parseHeaders();
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.header.parse"), t);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sm.getString("http11processor.request.prepare") + " host header missing"));
                }
                this.response.setStatus(400);
                this.error = true;
            }
            thrA.setCurrentStage((Object)this.threadPool, "prepareRequest");
            rp.setStage(2);
            try {
                this.prepareRequest();
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.request.prepare"), t);
                }
                this.response.setStatus(400);
                this.error = true;
            }
            if (this.maxKeepAliveRequests > 0 && --keepAliveLeft == 0) {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    thrA.setCurrentStage((Object)this.threadPool, "service");
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("http11processor.request.process"), t);
                    this.response.setStatus(500);
                    this.error = true;
                }
            }
            try {
                thrA.setCurrentStage((Object)this.threadPool, "endRequestIB");
                rp.setStage(4);
                this.inputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("http11processor.request.finish"), t);
                this.response.setStatus(500);
                this.error = true;
            }
            try {
                thrA.setCurrentStage((Object)this.threadPool, "endRequestOB");
                rp.setStage(5);
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("http11processor.response.finish"), t);
                this.error = true;
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            thrA.setCurrentStage((Object)this.threadPool, "ended");
            rp.setStage(6);
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
        }
        rp.setStage(7);
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.sslSupport = null;
    }

    public void action(ActionCode actionCode, Object param) {
        block62: {
            if (actionCode == ActionCode.ACTION_COMMIT) {
                if (this.response.isCommitted()) {
                    return;
                }
                this.prepareResponse();
                try {
                    this.outputBuffer.commit();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_ACK) {
                if (this.response.isCommitted() || !this.expectation) {
                    return;
                }
                this.inputBuffer.setSwallowInput(true);
                try {
                    this.outputBuffer.sendAck();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
                try {
                    this.outputBuffer.flush();
                }
                catch (IOException e) {
                    this.error = true;
                    this.response.setErrorException((Exception)e);
                }
            } else if (actionCode == ActionCode.ACTION_CLOSE) {
                try {
                    this.outputBuffer.endRequest();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_RESET) {
                this.outputBuffer.reset();
            } else if (actionCode != ActionCode.ACTION_CUSTOM) {
                if (actionCode == ActionCode.ACTION_START) {
                    this.started = true;
                } else if (actionCode == ActionCode.ACTION_STOP) {
                    this.started = false;
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    try {
                        if (this.sslSupport == null) break block62;
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getInetAddress()) != null) {
                        this.remoteAddr = inetAddr.getHostAddress();
                    }
                    this.request.remoteAddr().setString(this.remoteAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.localName == null && this.socket != null && (inetAddr = this.socket.getLocalAddress()) != null) {
                        this.localName = inetAddr.getHostName();
                    }
                    this.request.localName().setString(this.localName);
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    if (this.remoteHost == null && this.socket != null) {
                        InetAddress inetAddr = this.socket.getInetAddress();
                        if (inetAddr != null) {
                            this.remoteHost = inetAddr.getHostName();
                        }
                        if (this.remoteHost == null) {
                            if (this.remoteAddr != null) {
                                this.remoteHost = this.remoteAddr;
                            } else {
                                this.request.remoteHost().recycle();
                            }
                        }
                    }
                    this.request.remoteHost().setString(this.remoteHost);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                    if (this.localAddr == null) {
                        this.localAddr = this.socket.getLocalAddress().getHostAddress();
                    }
                    this.request.localAddr().setString(this.localAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                    if (this.remotePort == -1 && this.socket != null) {
                        this.remotePort = this.socket.getPort();
                    }
                    this.request.setRemotePort(this.remotePort);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                    if (this.localPort == -1 && this.socket != null) {
                        this.localPort = this.socket.getLocalPort();
                    }
                    this.request.setLocalPort(this.localPort);
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                    if (this.sslSupport != null) {
                        InputFilter[] inputFilters = this.inputBuffer.getFilters();
                        ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                        this.inputBuffer.addActiveFilter(inputFilters[3]);
                        try {
                            Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                            if (sslO != null) {
                                this.request.setAttribute("javax.servlet.request.X509Certificate", (Object)sslO);
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                        }
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_SET_BODY_REPLAY) {
                    ByteChunk body = (ByteChunk)param;
                    SavedRequestInputFilter savedBody = new SavedRequestInputFilter(body);
                    savedBody.setRequest(this.request);
                    InternalInputBuffer internalBuffer = (InternalInputBuffer)this.request.getInputBuffer();
                    internalBuffer.addActiveFilter(savedBody);
                }
            }
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        long contentLength;
        ByteChunk uriBC;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        this.expectation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported HTTP version \"" + protocolMB + "\""));
            }
            this.response.setStatus(505);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        MessageBytes expectMB = null;
        if (this.http11) {
            expectMB = headers.getValue("expect");
        }
        if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
            this.inputBuffer.setSwallowInput(false);
            this.expectation = true;
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].matcher(userAgentValue).matches()) continue;
                this.http11 = false;
                this.keepAlive = false;
                break;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase().trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase().trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported transfer encoding \"" + encodingName + "\""));
                }
                this.response.setStatus(501);
            }
        }
        if ((contentLength = this.request.getContentLengthLong()) >= 0L && !this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getLocalPort());
            InetAddress localAddress = this.socket.getLocalAddress();
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    private boolean isCompressable() {
        long contentLength;
        MessageBytes userAgentValueMB;
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.noCompressionUserAgents.length; ++i) {
                if (!this.noCompressionUserAgents[i].matcher(userAgentValue).matches()) continue;
                return false;
            }
        }
        if (((contentLength = this.response.getContentLengthLong()) == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && (useCompression = this.isCompressable())) {
            this.response.setContentLength(-1);
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        long contentLength = this.response.getContentLengthLong();
        if (contentLength != -1L) {
            headers.setValue("Content-Length").setLong(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11 && this.keepAlive) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            headers.addValue("Transfer-Encoding").setString("chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
            headers.setValue("Content-Encoding").setString("gzip");
            headers.setValue("Vary").setString("Accept-Encoding");
        }
        String date = null;
        date = System.getSecurityManager() != null ? (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FastHttpDateFormat.getCurrentDate();
            }
        }) : FastHttpDateFormat.getCurrentDate();
        headers.setValue("Date").setString(date);
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            headers.addValue("Connection").setString("close");
        } else if (!this.http11 && !this.error) {
            headers.addValue("Connection").setString("keep-alive");
        }
        this.outputBuffer.sendStatus();
        if (this.server != null) {
            headers.setValue("Server").setString(this.server);
        } else {
            this.outputBuffer.write(Constants.SERVER_BYTES);
        }
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower((int)buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower((int)buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

