<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2376 $
 * $Id: InstallSchema_1004A.class.php 2376 2009-01-23 17:12:17Z ipso $
 * $Date: 2009-01-23 09:12:17 -0800 (Fri, 23 Jan 2009) $
 */

/**
 * @package Module_Install
 */
class InstallSchema_1004A extends InstallSchema_Base {

	function preInstall() {
		Debug::text('preInstall: '. $this->getVersion() , __FILE__, __LINE__, __METHOD__,9);

		$tables = $this->getDatabaseConnection()->MetaTables();
		if ( in_array( 'log', $tables ) ) {
			//Make sure this only runs for PGSQL databases.

			if ( strncmp($this->getDatabaseConnection()->databaseType,'postgres',8) == 0 ) {
				//Upgrading, rename log file.
				$query = 'alter table "log" rename to "system_log"';
				$this->getDatabaseConnection()->Execute($query);

				$query = 'alter index "log_id" rename to "system_log_id"';
				$this->getDatabaseConnection()->Execute($query);

				$query = 'alter index "log_user_id_table_name_action_id" rename to "system_log_user_id_table_name_action_id";';
				$this->getDatabaseConnection()->Execute($query);

				$query = 'alter table "log_id_seq" rename to "system_log_id_seq";';
				$this->getDatabaseConnection()->Execute($query);
			} else {
				Debug::text('preInstall: Not a PGSQL database, skipping special commands', __FILE__, __LINE__, __METHOD__,9);
			}
		}


		return TRUE;
	}


	function postInstall() {
		Debug::text('postInstall: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);

		return TRUE;

	}
}
?>
