/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.SimpleItem;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateCatalogParser {
    public static final String TAG_MODULE_UPDATES = "module_updates";
    public static final String TAG_MODULE = "module";
    public static final String TAG_MODULE_GROUP = "module_group";
    public static final String ATTR_MODULE_GROUP_NAME = "name";
    public static final String TAG_FEATURE = "feature";
    public static final String TAG_LICENSE = "license";
    public static final String TAG_NOTIFICATION = "notification";
    public static final String ATTR_NOTIFICATION_URL = "url";
    public static final String TAG_ERROR = "error";
    public static final String TAG_AUTH_ERROR = "auth_error";
    public static final String TAG_OTHER_ERROR = "other_error";
    public static final String ATTR_MESSAGE_ERROR = "message";
    public static final String TAG_ELEMENT_L10N = "l10n";
    public static final String TAG_MANIFEST = "manifest";
    private static final String TIME_STAMP_ATTRIBUTE_NAME = "timestamp";
    private static final String TIME_STAMP_FORMAT = "ss/mm/hh/dd/MM/yyyy";
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogParser");
    private static String GZIP_EXTENSION = ".gz";

    public static Map<String, UpdateItem> getUpdateItems(URL uRL, URL uRL2) {
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        Map<String, String> map = AutoupdateCatalogParser.getLicenses(uRL, uRL2);
        Date date = AutoupdateCatalogParser.getAutoupdateCatalogDate(uRL, uRL2);
        String string = null;
        if (date != null) {
            string = Utilities.formatDate(date);
        }
        try {
            List<SimpleItem> list = AutoupdateCatalogParser.createSimpleItems(AutoupdateCatalogParser.getDocument(uRL, uRL2));
            for (SimpleItem simpleItem : list) {
                if (simpleItem instanceof SimpleItem.License) continue;
                UpdateItem updateItem = simpleItem.toUpdateItem(map, string);
                hashMap.put(simpleItem.getId(), updateItem);
            }
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            ERR.log(Level.INFO, sAXException.getMessage(), sAXException);
        }
        return hashMap;
    }

    static Map<String, String> getLicenses(URL uRL, URL uRL2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            List<SimpleItem> list = AutoupdateCatalogParser.createSimpleItems(AutoupdateCatalogParser.getDocument(uRL, uRL2));
            for (SimpleItem simpleItem : list) {
                if (!(simpleItem instanceof SimpleItem.License)) continue;
                SimpleItem.License license = (SimpleItem.License)simpleItem;
                hashMap.put(license.getLicenseId(), license.getLicenseContent());
            }
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            ERR.log(Level.INFO, sAXException.getMessage(), sAXException);
        }
        return hashMap;
    }

    public static String getNotification(URL uRL, URL uRL2) {
        String string = null;
        try {
            Document document = AutoupdateCatalogParser.getDocument(uRL, uRL2);
            NodeList nodeList = document.getElementsByTagName(TAG_MODULE_UPDATES);
            assert (nodeList != null && nodeList.getLength() == 1);
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                String string2;
                Node node = nodeList2.item(i);
                if (1 != node.getNodeType()) continue;
                assert (node instanceof Element) : node + " is instanceof Element";
                String string3 = ((Element)node).getTagName();
                if (!TAG_NOTIFICATION.equals(string3)) continue;
                NodeList nodeList3 = node.getChildNodes();
                assert (nodeList3 != null && nodeList3.getLength() == 1) : "Notification " + node + " should contain only once data.";
                String string4 = nodeList3.item(0).getNodeValue();
                string = "";
                if (string4 != null && string4.length() > 0) {
                    string = string4;
                }
                if ((string2 = SimpleItem.getAttribute(node, ATTR_NOTIFICATION_URL)) != null && string2.length() > 0) {
                    string = string + (string.length() > 0 ? "<br>" : "") + "<a href=\"" + string2 + "\">" + string2 + "</a>";
                }
                break;
            }
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            ERR.log(Level.INFO, sAXException.getMessage(), sAXException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Document getDocument(URL uRL, URL uRL2) throws IOException, SAXException {
        Document document;
        block4: {
            InputStream inputStream = null;
            document = null;
            try {
                inputStream = AutoupdateCatalogParser.getInputStream(uRL, AutoupdateCatalogParser.isGZIP(uRL2));
                document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)false, null, (EntityResolver)org.netbeans.updater.XMLUtil.createAUResolver());
                Object var5_4 = null;
                if (inputStream == null) break block4;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
        if (uRL2 == null) return document;
        try {
            document.setDocumentURI(uRL2.toURI().toString());
            return document;
        }
        catch (URISyntaxException uRISyntaxException) {
            ERR.log(Level.INFO, uRISyntaxException.getMessage(), uRISyntaxException);
        }
        return document;
    }

    private static boolean isGZIP(URL uRL) {
        boolean bl = false;
        if (uRL != null) {
            bl = uRL.getPath().toLowerCase().endsWith(GZIP_EXTENSION);
        }
        ERR.log(Level.FINER, "Is GZIP " + uRL + " ? " + bl);
        return bl;
    }

    private static InputStream getInputStream(URL uRL, boolean bl) {
        BufferedInputStream bufferedInputStream = null;
        if (bl) {
            try {
                bufferedInputStream = new BufferedInputStream(new GZIPInputStream(uRL.openStream()));
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, "IOException " + iOException.getMessage() + " while reading GZIP stream " + uRL, iOException);
            }
        }
        if (bufferedInputStream == null) {
            try {
                bufferedInputStream = new BufferedInputStream(uRL.openStream());
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, "IOException " + iOException.getMessage() + " while reading stream " + uRL, iOException);
            }
        }
        return bufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Date getAutoupdateCatalogDate(URL uRL, URL uRL2) {
        InputStream inputStream;
        Date date;
        block13: {
            int n;
            date = null;
            inputStream = null;
            ERR.log(Level.FINER, "Inspect Autoupdate Catalog " + uRL);
            inputStream = AutoupdateCatalogParser.getInputStream(uRL, AutoupdateCatalogParser.isGZIP(uRL2));
            StringBuffer stringBuffer = new StringBuffer(1024);
            while ((n = inputStream.read()) != -1 && stringBuffer.length() < 1024) {
                stringBuffer.append((char)n);
            }
            ERR.log(Level.FINER, "Successfully checked " + uRL);
            String string = stringBuffer.toString();
            ERR.log(Level.FINEST, "Read string " + stringBuffer);
            String string2 = null;
            int n2 = string.indexOf(TIME_STAMP_ATTRIBUTE_NAME);
            if (n2 != -1 && (n2 = (string = string.substring(n2 + TIME_STAMP_ATTRIBUTE_NAME.length() + 1 + 1)).indexOf(62)) != -1) {
                string2 = string.substring(0, n2 - 1);
            }
            ERR.log(Level.FINEST, "Transposed time " + string2);
            if (string2 == null) {
                ERR.log(Level.INFO, "No timestamp is presented in " + uRL);
                break block13;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_STAMP_FORMAT);
            date = simpleDateFormat.parse(string2);
            ERR.log(Level.FINER, "Successfully read time " + date);
        }
        Object var11_12 = null;
        if (inputStream == null) return date;
        try {
            inputStream.close();
            return date;
        }
        catch (IOException iOException) {
            ERR.log(Level.FINE, null, iOException);
        }
        return date;
        {
            catch (IOException iOException) {
                ERR.log(Level.FINE, null, iOException);
                Object var11_13 = null;
                if (inputStream == null) return date;
                try {
                    inputStream.close();
                    return date;
                }
                catch (IOException iOException2) {
                    ERR.log(Level.FINE, null, iOException2);
                }
                return date;
            }
            catch (ParseException parseException) {
                ERR.log(Level.FINE, null, parseException);
                Object var11_14 = null;
                if (inputStream == null) return date;
                try {
                    inputStream.close();
                    return date;
                }
                catch (IOException iOException) {
                    ERR.log(Level.FINE, null, iOException);
                }
                return date;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                ERR.log(Level.FINE, null, iOException);
            }
            throw throwable;
        }
    }

    static List<SimpleItem> createSimpleItems(Document document) {
        NodeList nodeList = document.getElementsByTagName(TAG_MODULE_UPDATES);
        if (nodeList == null || nodeList.getLength() != 1) {
            ERR.log(Level.INFO, "module_updates tag was invalid in " + document.getBaseURI());
            return Collections.emptyList();
        }
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        return AutoupdateCatalogParser.parseUpdateItems(nodeList2, null);
    }

    private static List<SimpleItem> parseUpdateItems(NodeList nodeList, String string) {
        ArrayList<SimpleItem> arrayList = new ArrayList<SimpleItem>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            assert (node instanceof Element) : node + " is instanceof Element";
            String string2 = ((Element)node).getTagName();
            if (TAG_MODULE_GROUP.equals(string2)) {
                string = SimpleItem.getAttribute(node, ATTR_MODULE_GROUP_NAME);
                arrayList.addAll(AutoupdateCatalogParser.parseUpdateItems(node.getChildNodes(), string));
                continue;
            }
            if (TAG_MODULE.equals(string2)) {
                NodeList nodeList2 = ((Element)node).getElementsByTagName(TAG_ELEMENT_L10N);
                NodeList nodeList3 = ((Element)node).getElementsByTagName(TAG_MANIFEST);
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    arrayList.add(new SimpleItem.Localization(node, string));
                    continue;
                }
                if (nodeList3 != null && nodeList3.getLength() > 0) {
                    arrayList.add(new SimpleItem.Module(node, string));
                    continue;
                }
                assert (false) : "Unknown element " + node;
                continue;
            }
            if (TAG_FEATURE.equals(string2)) {
                arrayList.add(new SimpleItem.Feature(node, string));
                continue;
            }
            if (TAG_LICENSE.equals(string2)) {
                arrayList.add(new SimpleItem.License(node));
                continue;
            }
            if (!TAG_NOTIFICATION.equals(string2)) assert (false) : "Unknown element tag " + string2;
        }
        return arrayList;
    }
}

