/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference.screen;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.information.Information;
import tr.model.topic.Topic;
import tr.runtime.Open;
import tr.swing.document.LazyDocumentListener;
import tr.swing.editorpane.HyperEditorPane;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;

public class ReferencePanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("tr.view.references");
    private Information information;
    private boolean updating;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private JComboBox topicCombo;
    private JLabel topicLabel;
    private TopicsComboBoxModel topicsModel;
    private FocusListener descriptionFocusListener;
    private ActionListener topicActionListener;
    private DocumentListener notesDocumentListener;
    private HyperlinkListener notesHyperlinkListener;

    public ReferencePanel() {
        this.initComponents();
        this.initModel(null);
    }

    public void initModel(Information information) {
        this.information = information;
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.information == null) {
            this.descriptionText.setText("");
            this.topicCombo.setSelectedIndex(0);
            this.notesEditorPane.setText("");
            this.setEnabled(false);
        } else {
            this.descriptionText.setText(this.information.getDescription());
            this.topicCombo.setSelectedItem(this.information.getTopic());
            this.notesEditorPane.setText(this.information.getNotes());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.topicLabel.setEnabled(enabled);
        this.topicCombo.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void deactivate() {
        if (Utilities.getOperatingSystem() == 4096 && this.descriptionText.hasFocus()) {
            this.changedDescription();
        }
    }

    private void addListeners() {
        this.descriptionFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ReferencePanel.this.changedDescription();
            }
        };
        this.descriptionText.addFocusListener(this.descriptionFocusListener);
        this.topicActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReferencePanel.this.changedTopic();
            }
        };
        this.topicCombo.addActionListener(this.topicActionListener);
        this.notesDocumentListener = new LazyDocumentListener(){

            public void update() {
                ReferencePanel.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.notesDocumentListener);
        this.notesHyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ReferencePanel.this.hyperlink(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.notesHyperlinkListener);
    }

    private void removeListeners() {
        this.descriptionText.removeFocusListener(this.descriptionFocusListener);
        this.topicCombo.removeActionListener(this.topicActionListener);
        this.notesEditorPane.removeDocumentListener(this.notesDocumentListener);
        this.notesEditorPane.removeHyperlinkListener(this.notesHyperlinkListener);
        this.descriptionFocusListener = null;
        this.topicActionListener = null;
        this.notesDocumentListener = null;
        this.notesHyperlinkListener = null;
    }

    private void hyperlink(HyperlinkEvent evt) {
        if (evt.getURL() == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)evt.getURL());
        }
    }

    public void edit() {
        if (this.information == null) {
            return;
        }
        this.descriptionText.requestFocus();
    }

    private void changedDescription() {
        if (this.information == null) {
            return;
        }
        this.information.setDescription(this.descriptionText.getText());
    }

    private void changedTopic() {
        if (this.information == null) {
            return;
        }
        this.information.setTopic((Topic)this.topicCombo.getSelectedItem());
    }

    private void changedNotes() {
        if (this.information == null) {
            return;
        }
        this.information.setNotes(this.notesEditorPane.getText());
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.notesLabel = new JLabel();
        this.notesEditorPane = new HyperEditorPane();
        this.topicLabel = new JLabel();
        this.topicsModel = new TopicsComboBoxModel(false);
        this.topicCombo = new TopicsComboBox((ComboBoxModel)this.topicsModel);
        this.descriptionLabel.setHorizontalAlignment(11);
        this.descriptionLabel.setText(NbBundle.getMessage(ReferencePanel.class, (String)"Reference.description"));
        this.notesLabel.setHorizontalAlignment(11);
        this.notesLabel.setText(NbBundle.getMessage(ReferencePanel.class, (String)"Reference.notes"));
        this.topicLabel.setHorizontalAlignment(11);
        this.topicLabel.setText(NbBundle.getMessage(ReferencePanel.class, (String)"Reference.topic"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.descriptionLabel, -1, -1, Short.MAX_VALUE).add((Component)this.topicLabel, -1, 73, Short.MAX_VALUE).add((Component)this.notesLabel, -1, 73, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.descriptionText, -1, 250, Short.MAX_VALUE).add((Component)this.topicCombo, -2, 250, -2).add((Component)this.notesEditorPane, -1, 250, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionLabel).add((Component)this.descriptionText, -2, -1, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.topicLabel, -2, 22, -2).add((Component)this.topicCombo, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(32, 32, 32).add((Component)this.notesLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, 0).add((Component)this.notesEditorPane, -1, 49, Short.MAX_VALUE))).addContainerGap()));
    }
}

