/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodYear;
import tr.view.action.MonthsOfYearDialog;

public class PeriodYearlyPanel
extends JPanel {
    private JComboBox dayComboBox;
    private JLabel inLabel;
    private JButton monthsButton;
    private JComboBox nthComboBox;
    private JCheckBox onTheCheckBox;
    private final Dialog parent;
    private final PeriodYear periodYear;

    public PeriodYearlyPanel(Dialog parent, PeriodYear periodYear) {
        this.parent = parent;
        this.periodYear = periodYear;
        this.initComponents();
        this.onTheCheckBox.setSelected(periodYear.isOnTheSelected());
        this.dayComboBox.setModel(this.getDayComboModel());
        this.dayComboBox.setSelectedItem(periodYear.getOnTheDay());
        this.nthComboBox.setModel(this.getNthComboModel());
        this.nthComboBox.setSelectedItem(periodYear.getOnTheNth());
        this.setEnabled(true);
    }

    private ComboBoxModel getDayComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheDay>(PeriodMonth.OnTheDay.values());
    }

    private ComboBoxModel getNthComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheNth>(PeriodMonth.OnTheNth.values());
    }

    private String getSelectedMonthsText() {
        return this.periodYear.getSelectedMonthsText();
    }

    public void notifyStartDate(Date startDate) {
        if (startDate == null) {
            return;
        }
        if (this.periodYear.getSelectedMonths().size() > 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        this.periodYear.select(Integer.valueOf(calendar.get(2)));
    }

    private void initComponents() {
        this.inLabel = new JLabel();
        this.monthsButton = new JButton();
        this.onTheCheckBox = new JCheckBox();
        this.nthComboBox = new JComboBox();
        this.dayComboBox = new JComboBox();
        this.setMaximumSize(new Dimension(528, 26));
        this.setMinimumSize(new Dimension(528, 26));
        this.setPreferredSize(new Dimension(528, 26));
        this.inLabel.setText(NbBundle.getMessage(PeriodYearlyPanel.class, (String)"YearsPanel.in"));
        this.inLabel.setMaximumSize(new Dimension(20, 26));
        this.inLabel.setMinimumSize(new Dimension(20, 26));
        this.inLabel.setPreferredSize(new Dimension(20, 26));
        this.monthsButton.setText(this.getSelectedMonthsText());
        this.monthsButton.setHorizontalAlignment(10);
        this.monthsButton.setHorizontalTextPosition(10);
        this.monthsButton.setMaximumSize(new Dimension(120, 26));
        this.monthsButton.setMinimumSize(new Dimension(120, 26));
        this.monthsButton.setPreferredSize(new Dimension(120, 26));
        this.monthsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.monthsButtonAction(evt);
            }
        });
        this.onTheCheckBox.setText(NbBundle.getMessage(PeriodYearlyPanel.class, (String)"months.on.the"));
        this.onTheCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.onTheCheckBox.setMaximumSize(new Dimension(74, 26));
        this.onTheCheckBox.setMinimumSize(new Dimension(74, 26));
        this.onTheCheckBox.setPreferredSize(new Dimension(74, 26));
        this.onTheCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.onTheCheckBoxAction(evt);
            }
        });
        this.nthComboBox.setMaximumSize(new Dimension(120, 26));
        this.nthComboBox.setMinimumSize(new Dimension(120, 26));
        this.nthComboBox.setPreferredSize(new Dimension(120, 26));
        this.nthComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.NthComboAction(evt);
            }
        });
        this.dayComboBox.setMaximumSize(new Dimension(120, 26));
        this.dayComboBox.setMinimumSize(new Dimension(120, 26));
        this.dayComboBox.setPreferredSize(new Dimension(120, 26));
        this.dayComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.dayComboAction(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.inLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.monthsButton, -2, -1, -2).add(18, 18, 18).add((Component)this.onTheCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.nthComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.dayComboBox, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.onTheCheckBox, -2, -1, -2).add(2, (Component)this.inLabel, -2, -1, -2).add(2, (Component)this.monthsButton, -2, -1, -2).add(2, (Component)this.nthComboBox, -2, -1, -2).add(2, (Component)this.dayComboBox, -2, -1, -2)));
    }

    private void dayComboAction(ActionEvent evt) {
        this.periodYear.setOnTheDay((PeriodMonth.OnTheDay)this.dayComboBox.getSelectedItem());
    }

    private void NthComboAction(ActionEvent evt) {
        this.periodYear.setOnTheNth((PeriodMonth.OnTheNth)this.nthComboBox.getSelectedItem());
    }

    private void onTheCheckBoxAction(ActionEvent evt) {
        this.periodYear.setOnTheSelected(this.onTheCheckBox.isSelected());
        this.setEnabled(true);
    }

    private void monthsButtonAction(ActionEvent evt) {
        MonthsOfYearDialog dialog = new MonthsOfYearDialog(this.parent, this.monthsButton);
        dialog.setPeriodYear(this.periodYear);
        dialog.setVisible(true);
        if (!dialog.cancelled()) {
            this.periodYear.setSelectedMonths(dialog.getSelectedMonths());
            this.monthsButton.setText(this.periodYear.getSelectedMonthsText());
        }
    }

    public void setEnabled(boolean enabled) {
        this.nthComboBox.setEnabled(enabled && this.onTheCheckBox.isSelected());
        this.dayComboBox.setEnabled(enabled && this.onTheCheckBox.isSelected());
        this.monthsButton.setEnabled(enabled);
        this.onTheCheckBox.setEnabled(enabled);
    }
}

