/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SystemDefaultBrowser
extends ExtWebBrowser {
    private static final long serialVersionUID = -7317179197254112564L;
    private static final Logger logger = Logger.getLogger(SystemDefaultBrowser.class.getName());
    private static BrowseInvoker JDK_6_DESKTOP_BROWSE;

    public static Boolean isHidden() {
        return !Utilities.isWindows() && JDK_6_DESKTOP_BROWSE == null;
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        if (JDK_6_DESKTOP_BROWSE != null) {
            return new Jdk6BrowserImpl();
        }
        if (Utilities.isWindows()) {
            return new NbDdeBrowserImpl(this);
        }
        throw new UnsupportedOperationException(NbBundle.getMessage((Class)SystemDefaultBrowser.class, (String)"MSG_CannotUseBrowser"));
    }

    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getMessage((Class)SystemDefaultBrowser.class, (String)"CTL_SystemDefaultBrowserName");
        }
        return this.name;
    }

    public void setName(String string) {
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        NbProcessDescriptor nbProcessDescriptor;
        String string;
        if (!Utilities.isWindows() || JDK_6_DESKTOP_BROWSE != null) {
            return new NbProcessDescriptor("", "");
        }
        String string2 = "";
        try {
            string = NbDdeBrowserImpl.getDefaultOpenCommand();
            nbProcessDescriptor = Utilities.parseParameters((String)string);
            if (nbProcessDescriptor == null || ((String[])nbProcessDescriptor).length == 0) {
                throw new NbBrowserException();
            }
            string = nbProcessDescriptor[0];
            string2 = string2 + " {URL}";
        }
        catch (NbBrowserException nbBrowserException) {
            string = "";
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            string = "iexplore";
        }
        nbProcessDescriptor = new NbProcessDescriptor(string, string2);
        return nbProcessDescriptor;
    }

    static {
        if (Boolean.getBoolean("org.netbeans.modules.extbrowser.UseDesktopBrowse")) {
            try {
                if (Boolean.getBoolean("java.net.useSystemProxies") && Utilities.isUnix()) {
                    logger.log(Level.FINE, "Ignoring java.awt.Desktop.browse support to avoid hang from #89540");
                } else {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Method method = clazz.getMethod("isDesktopSupported", null);
                    Boolean bl = (Boolean)method.invoke(null, null);
                    logger.log(Level.FINE, "java.awt.Desktop found, isDesktopSupported returned " + bl);
                    if (bl.booleanValue()) {
                        final Object object = clazz.getMethod("getDesktop", null).invoke(null, null);
                        Class<?> clazz2 = Class.forName("java.awt.Desktop$Action");
                        Method method2 = clazz.getMethod("isSupported", clazz2);
                        Object object2 = clazz2.getField("BROWSE").get(null);
                        bl = (Boolean)method2.invoke(object, object2);
                        logger.log(Level.FINE, "java.awt.Desktop found, isSupported(Action.BROWSE) returned " + bl);
                        if (bl.booleanValue()) {
                            final Method method3 = clazz.getMethod("browse", URI.class);
                            JDK_6_DESKTOP_BROWSE = new BrowseInvoker(){

                                public void browse(URI uRI) throws IOException {
                                    try {
                                        method3.invoke(object, uRI);
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        throw (IOException)invocationTargetException.getTargetException();
                                    }
                                    catch (Exception exception) {
                                        Logger.getLogger((class$org$netbeans$modules$extbrowser$SystemDefaultBrowser == null ? (class$org$netbeans$modules$extbrowser$SystemDefaultBrowser = SystemDefaultBrowser.class$("org.netbeans.modules.extbrowser.SystemDefaultBrowser")) : class$org$netbeans$modules$extbrowser$SystemDefaultBrowser).getName()).log(Level.WARNING, null, exception);
                                    }
                                }
                            };
                            logger.log(Level.FINE, "java.awt.Desktop.browse support");
                        }
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.FINE, "java.awt.Desktop class not found, disabling JDK 6 browse functionality");
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, null, exception);
            }
        }
    }

    private static interface BrowseInvoker {
        public void browse(URI var1) throws IOException;
    }

    private static final class Jdk6BrowserImpl
    extends ExtBrowserImpl {
        static final /* synthetic */ boolean $assertionsDisabled;

        public Jdk6BrowserImpl() {
            if (!$assertionsDisabled && JDK_6_DESKTOP_BROWSE == null) {
                throw new AssertionError();
            }
        }

        public void setURL(URL uRL) {
            URL uRL2 = URLUtil.createExternalURL(uRL, false);
            try {
                URI uRI = uRL2.toURI();
                logger.fine("Calling java.awt.Desktop.browse(" + uRI + ")");
                JDK_6_DESKTOP_BROWSE.browse(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.severe("The URL:\n" + uRL2 + "\nis not fully RFC 2396 compliant and cannot " + "be used with Desktop.browse().");
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, null, iOException);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$extbrowser$SystemDefaultBrowser == null ? (class$org$netbeans$modules$extbrowser$SystemDefaultBrowser = SystemDefaultBrowser.class$("org.netbeans.modules.extbrowser.SystemDefaultBrowser")) : class$org$netbeans$modules$extbrowser$SystemDefaultBrowser).desiredAssertionStatus();
        }
    }
}

