/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.view.process.panels.Actionable;
import tr.view.topics.TopicsComboBoxModel;

public class PanelActionable
extends JPanel {
    private ActionListener actionListenerYes;
    private ActionListener actionListenerNo;
    private ButtonGroup actionableButtonGroup;
    private JRadioButton noRadioButton;
    private JRadioButton yesRadioButton;
    private static final Logger LOG = Logger.getLogger("tr.view.process");
    private Actionable actionable;
    private TopicsComboBoxModel topicsModel;
    private boolean updating;

    public PanelActionable() {
        this.initComponents();
        this.initModel(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void clickYes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PanelActionable.this.yesRadioButton.doClick();
            }
        });
    }

    private void addListeners() {
        this.actionListenerYes = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelActionable.this.yesActionPerformed(evt);
            }
        };
        this.yesRadioButton.addActionListener(this.actionListenerYes);
        this.actionListenerNo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelActionable.this.noActionPerformed(evt);
            }
        };
        this.noRadioButton.addActionListener(this.actionListenerNo);
    }

    private void removeListeners() {
        this.yesRadioButton.removeActionListener(this.actionListenerYes);
        this.noRadioButton.removeActionListener(this.actionListenerNo);
        this.actionListenerYes = null;
        this.actionListenerNo = null;
    }

    private void yesActionPerformed(ActionEvent evt) {
        if (this.updating || this.actionable == null) {
            return;
        }
        this.actionable.setActionable(true);
    }

    private void noActionPerformed(ActionEvent evt) {
        if (this.updating || this.actionable == null) {
            return;
        }
        this.actionable.setActionable(false);
    }

    public void initModel(Actionable actionable) {
        this.actionable = actionable;
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.actionable == null) {
            this.yesRadioButton.setSelected(true);
        } else {
            this.yesRadioButton.setSelected(this.actionable.isActionable());
        }
        this.updating = false;
        this.setEnabled(this.actionable != null);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.yesRadioButton.setEnabled(enable);
        this.noRadioButton.setEnabled(enable);
    }

    private void initComponents() {
        this.actionableButtonGroup = new ButtonGroup();
        this.yesRadioButton = new JRadioButton();
        this.noRadioButton = new JRadioButton();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PanelActionable.class, (String)"PanelActionable.title")));
        this.actionableButtonGroup.add(this.yesRadioButton);
        this.yesRadioButton.setText(NbBundle.getMessage(PanelActionable.class, (String)"PanelActionable.yes"));
        this.yesRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.yesRadioButton.setMaximumSize(new Dimension(60, 34));
        this.yesRadioButton.setMinimumSize(new Dimension(60, 34));
        this.yesRadioButton.setPreferredSize(new Dimension(60, 34));
        this.actionableButtonGroup.add(this.noRadioButton);
        this.noRadioButton.setText(NbBundle.getMessage(PanelActionable.class, (String)"PanelActionable.no"));
        this.noRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.noRadioButton.setMaximumSize(new Dimension(60, 34));
        this.noRadioButton.setMinimumSize(new Dimension(60, 34));
        this.noRadioButton.setPreferredSize(new Dimension(60, 34));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.yesRadioButton, -2, -1, -2).add(18, 18, 18).add((Component)this.noRadioButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.noRadioButton, -2, -1, -2).add((Component)this.yesRadioButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

