/*
 * Decompiled with CFR 0.152.
 */
package tr.imports.thoughts.prefs;

import java.io.File;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ImportThoughtsPrefs {
    private static final Logger LOG = Logger.getLogger("tr.imports.thoughts");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/import/thoughts");
    private static final String KEY_WARNING_FILE_SIZE = "warning.file.size";
    private static final int DEF_WARNING_FILE_SIZE = 4000;
    private static final String KEY_DEFAULT_FILE_PATH = "default.file.path";
    private static final String DEF_DEFAULT_FILE_PATH = System.getProperty("user.home") + File.separator + "thoughts.txt";
    private static final String KEY_ENCODING = "thoughts.encoding";
    private static final String DEF_ENCODING = "";

    public static final int getWarningFileSize() {
        return prefs.getInt(KEY_WARNING_FILE_SIZE, 4000);
    }

    public static final void setWarningFileSize(int value) {
        prefs.putInt(KEY_WARNING_FILE_SIZE, value);
        ImportThoughtsPrefs.flush();
    }

    public static final String getDefaultFilePath() {
        return prefs.get(KEY_DEFAULT_FILE_PATH, DEF_DEFAULT_FILE_PATH);
    }

    public static final void setDefaultFilePath(String value) {
        prefs.put(KEY_DEFAULT_FILE_PATH, value);
        ImportThoughtsPrefs.flush();
    }

    public static final String getEncoding() {
        return prefs.get(KEY_ENCODING, DEF_ENCODING);
    }

    public static final void setEncoding(String value) {
        prefs.put(KEY_ENCODING, value == null ? DEF_ENCODING : value.trim());
        ImportThoughtsPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Import thoughts preferences error. " + ex.getMessage());
        }
    }
}

