/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.ChangeFirer;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleFactory;
import org.netbeans.ModuleInstaller;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleManager {
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    static boolean PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES = !Boolean.getBoolean("suppress.topological.exception");
    private final Set<Module> modules = new HashSet<Module>(100);
    private final Map<String, Module> modulesByName = new HashMap<String, Module>(100);
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithoutNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private final Map<String, Set<Module>> providersOf = new HashMap<String, Set<Module>>(25);
    private final ModuleInstaller installer;
    private ModuleFactory moduleFactory;
    private SystemClassLoader classLoader;
    private List<File> classLoaderPatches;
    private final Object classLoaderLock = new String("ModuleManager.classLoaderLock");
    private final Events ev;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private boolean readOnly = false;
    private PropertyChangeSupport changeSupport;
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private static final Union2<Dependency, InvalidException> PROBING_IN_PROCESS = Union2.createSecond((Object)new InvalidException("PROBING_IN_PROCESS"));

    public ModuleManager(ModuleInstaller moduleInstaller, Events events) {
        this.installer = moduleInstaller;
        this.ev = events;
        String string = System.getProperty("netbeans.systemclassloader.patches");
        if (string != null) {
            System.err.println("System class loader patches: " + string);
            this.classLoaderPatches = new ArrayList<File>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                this.classLoaderPatches.add(new File(stringTokenizer.nextToken()));
            }
        } else {
            this.classLoaderPatches = Collections.emptyList();
        }
        this.classLoader = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{moduleInstaller.getClass().getClassLoader()}, Collections.<Module>emptySet());
        ModuleManager.updateContextClassLoaders(this.classLoader, true);
        this.moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (this.moduleFactory == null) {
            this.moduleFactory = new ModuleFactory();
        } else {
            this.classLoader.setSystemClassLoader(this.moduleFactory.getClasspathDelegateClassLoader(this, ClassLoader.getSystemClassLoader()));
        }
    }

    public final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    public final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    public void releaseModuleManifests() {
        for (Module module : this.modules) {
            module.releaseManifest();
        }
    }

    void readOnly(boolean bl) {
        this.readOnly = bl;
    }

    void assertWritable() throws IllegalThreadStateException {
        if (this.readOnly) {
            throw new IllegalThreadStateException("You are attempting to make changes to " + this + " in a property change callback. This is illegal. You may only make module system changes while holding a write mutex and not inside a change callback. See #16328.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("ModuleManager.propertyChange: " + string + ": " + object + " -> " + object2);
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    final void fireReloadable(Module module) {
        this.firer.change(new ChangeFirer.Change((Object)module, "reloadable", null, null));
        this.firer.fire();
    }

    public Lookup getModuleLookup() {
        return this.lookup;
    }

    final void fireModulesCreatedDeleted(Set set, Set set2) {
        Util.err.fine("lookup created: " + set + " deleted: " + set2);
        this.lookup.changed();
    }

    public Set<Module> getModules() {
        return new HashSet<Module>(this.modules);
    }

    public final Set<Module> getEnabledModules() {
        HashSet<Module> hashSet = new HashSet<Module>(this.modules);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (module.isEnabled()) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public final Module get(String string) {
        return this.modulesByName.get(string);
    }

    public Set<Module> getModuleInterdependencies(Module module, boolean bl, boolean bl2) {
        return Util.moduleInterdependencies(module, bl, bl2, this.modules, this.modulesByName, this.providersOf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateClassLoader() {
        Object object2;
        HashSet<ClassLoader> hashSet = this.classLoaderLock;
        synchronized (hashSet) {
            this.classLoader.destroy();
        }
        hashSet = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 2);
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(this.modules.size() + 1);
        ClassLoader classLoader = ModuleManager.class.getClassLoader();
        hashSet.add(classLoader);
        arrayList.add(classLoader);
        for (Object object2 : this.modules) {
            if (!object2.isEnabled() || !hashSet.add(object2.getClassLoader())) continue;
            arrayList.add(object2.getClassLoader());
        }
        if (this.moduleFactory.removeBaseClassLoader()) {
            arrayList.remove(classLoader);
        }
        ClassLoader[] classLoaderArray = arrayList.toArray(new ClassLoader[arrayList.size()]);
        try {
            object2 = new SystemClassLoader(this.classLoaderPatches, classLoaderArray, this.modules);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.err.log(Level.WARNING, null, illegalArgumentException);
            object2 = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{ModuleManager.class.getClassLoader()}, Collections.<Module>emptySet());
        }
        Object object3 = this.classLoaderLock;
        synchronized (object3) {
            this.classLoader = object2;
            ModuleManager.updateContextClassLoaders(this.classLoader, false);
        }
        this.firer.change(new ChangeFirer.Change(this, PROP_CLASS_LOADER, null, null));
    }

    private static void updateContextClassLoaders(ClassLoader classLoader, boolean bl) {
        int n;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        while (true) {
            int n2;
            Thread[] threadArray;
            if ((n = threadGroup.enumerate(threadArray = new Thread[n2 = threadGroup.activeCount() + 1], true)) < n2) {
                for (int i = 0; i < n; ++i) {
                    if (bl || threadArray[i].getContextClassLoader() instanceof SystemClassLoader) {
                        threadArray[i].setContextClassLoader(classLoader);
                        continue;
                    }
                    Util.err.fine("Not touching context class loader " + threadArray[i].getContextClassLoader() + " on thread " + threadArray[i].getName());
                }
                break;
            }
            Util.err.fine("Race condition getting all threads, restarting...");
        }
        Util.err.fine("Set context class loader on " + n + " threads");
    }

    @Deprecated
    public Module create(File file, Object object, boolean bl, boolean bl2) throws IOException, DuplicateException {
        return this.create(file, object, bl, bl2, false);
    }

    public Module create(File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException, DuplicateException {
        List<Module> list;
        this.assertWritable();
        this.ev.log("startCreateRegularModule", file);
        Module module = this.moduleFactory.create(file.getAbsoluteFile(), object, bl, bl2, bl3, this, this.ev);
        this.ev.log("finishCreateRegularModule", file);
        this.subCreate(module);
        if (module.isEager() && !(list = this.simulateEnable(Collections.<Module>emptySet())).isEmpty()) {
            if (!list.contains((Object)module)) {
                throw new IllegalStateException("Can immediately enable modules " + list + ", but not including " + (Object)((Object)module) + "; its problems: " + module.getProblems());
            }
            boolean bl4 = true;
            for (Module module2 : list) {
                if (module2.isAutoload() || module2.isEager()) continue;
                bl4 = false;
                break;
            }
            if (bl4) {
                Util.err.fine("Enabling " + (Object)((Object)module) + " immediately");
                this.enable(Collections.<Module>emptySet());
            }
        }
        return module;
    }

    public Module createFixed(Manifest manifest, Object object, ClassLoader classLoader) throws InvalidException, DuplicateException {
        return this.createFixed(manifest, object, classLoader, false, false);
    }

    public Module createFixed(Manifest manifest, Object object, ClassLoader classLoader, boolean bl, boolean bl2) throws InvalidException, DuplicateException {
        this.assertWritable();
        if (manifest == null || classLoader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", object);
        Module module = this.moduleFactory.createFixed(manifest, object, classLoader, bl, bl2, this, this.ev);
        this.ev.log("finishCreateBootModule", object);
        this.subCreate(module);
        return module;
    }

    void refineDependencies(Module module, Set<Dependency> set) {
        this.installer.refineDependencies(module, set);
    }

    String[] refineProvides(Module module) {
        return this.installer.refineProvides(module);
    }

    public void refineClassLoader(Module module, List list) {
        this.installer.refineClassLoader(module, list);
    }

    public boolean shouldDelegateResource(Module module, Module module2, String string) {
        Module.PackageExport[] packageExportArray;
        Module.PackageExport[] packageExportArray2 = packageExportArray = module2 == null ? null : module2.getPublicPackages();
        if (packageExportArray != null) {
            int n;
            boolean bl = false;
            if (module2.isDeclaredAsFriend(module)) {
                for (n = 0; n < packageExportArray.length; ++n) {
                    if (!(packageExportArray[n].recursive ? string.startsWith(packageExportArray[n].pkg) : string.equals(packageExportArray[n].pkg))) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                n = 0;
                Dependency[] dependencyArray = module.getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    if (dependencyArray[i].getType() != 1 || dependencyArray[i].getComparison() != 2 || !dependencyArray[i].getName().equals(module2.getCodeName())) continue;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    if (Util.err.isLoggable(Level.FINE)) {
                        Util.err.fine("Refusing to load non-public package " + string + " for " + (Object)((Object)module) + " from parent module " + (Object)((Object)module2) + " without an impl dependency");
                    }
                    return false;
                }
            }
        }
        if (string.startsWith("META-INF/")) {
            return false;
        }
        return this.installer.shouldDelegateResource(module, module2, string);
    }

    Manifest loadManifest(File file) throws IOException {
        return this.installer.loadManifest(file);
    }

    private void subCreate(Module module) throws DuplicateException {
        Util.err.fine("created: " + (Object)((Object)module));
        Module module2 = this.get(module.getCodeNameBase());
        if (module2 != null) {
            throw new DuplicateException(module2, module);
        }
        this.modules.add(module);
        this.modulesByName.put(module.getCodeNameBase(), module);
        this.possibleProviderAdded(module);
        this.lookup.add(module);
        this.firer.created(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    private void possibleProviderAdded(Module module) {
        String[] stringArray = module.getProvides();
        for (int i = 0; i < stringArray.length; ++i) {
            Set<Module> set = this.providersOf.get(stringArray[i]);
            if (set == null) {
                set = new HashSet<Module>(16);
                this.providersOf.put(stringArray[i], set);
            }
            set.add(module);
        }
    }

    public void delete(Module module) throws IllegalArgumentException {
        this.assertWritable();
        if (module.isFixed()) {
            throw new IllegalArgumentException("fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("enabled module: " + (Object)((Object)module));
        }
        this.ev.log("deleteModule", new Object[]{module});
        this.modules.remove((Object)module);
        this.modulesByName.remove(module.getCodeNameBase());
        this.possibleProviderRemoved(module);
        this.lookup.remove(module);
        this.firer.deleted(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)module, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
        module.destroy();
        this.firer.fire();
    }

    private void possibleProviderRemoved(Module module) {
        for (String string : module.getProvides()) {
            Set<Module> set = this.providersOf.get(string);
            if (set == null) continue;
            set.remove((Object)module);
            if (!set.isEmpty()) continue;
            this.providersOf.remove(string);
        }
    }

    public void reload(Module module) throws IllegalArgumentException, IOException {
        this.assertWritable();
        Util.err.fine("reload: " + (Object)((Object)module));
        if (module.isFixed()) {
            throw new IllegalArgumentException("reload fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("reload enabled module: " + (Object)((Object)module));
        }
        this.possibleProviderRemoved(module);
        try {
            module.reload();
        }
        catch (IOException iOException) {
            this.delete(module);
            throw iOException;
        }
        this.possibleProviderAdded(module);
        this.firer.change(new ChangeFirer.Change((Object)module, "manifest", null, null));
        this.moduleProblemsWithoutNeeds.remove((Object)module);
        this.moduleProblemsWithNeeds.remove((Object)module);
        this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    public final void enable(Module module) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(module));
    }

    public final void disable(Module module) throws IllegalArgumentException {
        this.disable(Collections.singleton(module));
    }

    public void enable(Set<Module> set) throws IllegalArgumentException, InvalidException {
        Module object;
        this.assertWritable();
        Util.err.fine("enable: " + set);
        this.ev.log("perfStart", "ModuleManager.enable");
        List<Module> list = this.simulateEnable(set);
        this.ev.log("perfTick", "checked the required ordering and autoloads");
        Util.err.fine("enable: toEnable=" + list);
        Object object2 = new HashSet<Module>(list);
        if (!object2.containsAll(set)) {
            HashSet<Module> hashSet = new HashSet<Module>(set);
            hashSet.removeAll((Collection<?>)object2);
            throw new IllegalArgumentException("Not all requested modules can be enabled: " + hashSet);
        }
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (set.contains((Object)object) || object.isAutoload() || object.isEager()) continue;
            throw new IllegalArgumentException("Would also need to enable " + (Object)((Object)object));
        }
        Util.err.fine("enable: verified dependencies");
        this.ev.log("perfTick", "verified dependencies");
        this.ev.log("startEnableModules", list);
        object2 = new LinkedList();
        boolean bl = false;
        object = null;
        try {
            this.ev.log("perfStart", "module preparation");
            for (Module object3 : list) {
                ((LinkedList)object2).addFirst((Module)object3);
                Util.err.fine("enable: bringing up: " + (Object)((Object)object3));
                this.ev.log("perfStart", "bringing up classloader on " + object3.getCodeName());
                try {
                    Dependency[] dependencyArray = object3.getDependenciesArray();
                    HashSet<Module> hashSet = new HashSet<Module>(dependencyArray.length * 4 / 3 + 1);
                    for (int i = 0; i < dependencyArray.length; ++i) {
                        Dependency dependency = dependencyArray[i];
                        if (dependency.getType() != 1) continue;
                        String string = (String)Util.parseCodeName(dependency.getName())[0];
                        Module module = this.get(string);
                        if (module == null) {
                            throw new IOException("Parent " + string + " not found!");
                        }
                        hashSet.add(module);
                    }
                    object3.classLoaderUp(hashSet);
                }
                catch (IOException iOException) {
                    bl = true;
                    InvalidException invalidException = new InvalidException(object3, iOException.toString());
                    invalidException.initCause(iOException);
                    throw invalidException;
                }
                object3.setEnabled(true);
                this.ev.log("perfEnd", "bringing up classloader on " + object3.getCodeName());
                Util.err.fine("enable: checking package dependencies for " + (Object)((Object)object3));
                Dependency[] dependencyArray = object3.getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    Dependency dependency = dependencyArray[i];
                    if (dependency.getType() != 2) continue;
                    if (!Util.checkPackageDependency(dependency, object3.getClassLoader())) {
                        object = dependency;
                        throw new InvalidException(object3, "Dependency failed on " + dependency);
                    }
                    Util.err.fine("Successful check for: " + dependency);
                }
                this.ev.log("perfStart", "ModuleInstaller.prepare " + object3.getCodeName());
                this.installer.prepare(object3);
                this.ev.log("perfEnd", "ModuleInstaller.prepare " + object3.getCodeName());
            }
            this.ev.log("perfEnd", "module preparation");
        }
        catch (InvalidException invalidException) {
            Module module = invalidException.getModule();
            if (module == null) {
                throw new IllegalStateException("Problem with no associated module: " + invalidException);
            }
            Set<Union2<Dependency, InvalidException>> set2 = this.moduleProblemsWithNeeds.get((Object)module);
            if (set2 == null) {
                throw new IllegalStateException("Were trying to install a module that had never been checked: " + (Object)((Object)module));
            }
            if (!set2.isEmpty()) {
                throw new IllegalStateException("Were trying to install a module that was known to be bad: " + (Object)((Object)module));
            }
            if (object != null) {
                set2.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)((Object)object)));
            } else {
                set2.add((Union2<Dependency, InvalidException>)Union2.createSecond((Object)invalidException));
            }
            this.clearProblemCache();
            this.firer.change(new ChangeFirer.Change((Object)module, "problems", Collections.EMPTY_SET, Collections.singleton("something")));
            Util.err.fine("enable: will roll back from: " + invalidException);
            Iterator iterator2 = ((AbstractSequentialList)object2).iterator();
            while (iterator2.hasNext()) {
                Module module2 = (Module)((Object)iterator2.next());
                if (module2.isFixed()) continue;
                module2.setEnabled(false);
                if (bl) {
                    bl = false;
                    continue;
                }
                module2.classLoaderDown();
                System.gc();
                System.runFinalization();
                module2.cleanup();
            }
            this.firer.fire();
            throw invalidException;
        }
        if (this.classLoader != null) {
            Util.err.fine("enable: adding to system classloader");
            LinkedList linkedList = new LinkedList();
            if (this.moduleFactory.removeBaseClassLoader()) {
                ClassLoader classLoader = ModuleManager.class.getClassLoader();
                linkedList.add(this.moduleFactory.getClasspathDelegateClassLoader(this, classLoader));
                for (Module module : list) {
                    ClassLoader classLoader2 = module.getClassLoader();
                    if (classLoader2 == classLoader) continue;
                    linkedList.add(classLoader2);
                }
            } else {
                for (Module module : list) {
                    if (module.getClassLoader() == ClassLoader.getSystemClassLoader()) {
                        linkedList.addFirst(module.getClassLoader());
                        continue;
                    }
                    linkedList.add(module.getClassLoader());
                }
            }
            this.classLoader.append(linkedList.toArray(new ClassLoader[linkedList.size()]), list);
        } else {
            Util.err.fine("enable: no class loader yet, not appending");
        }
        Util.err.fine("enable: continuing to installation");
        this.installer.load(list);
        Util.err.fine("enable: firing changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        for (Module module : list) {
            this.firer.change(new ChangeFirer.Change((Object)module, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (module.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)module, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishEnableModules", list);
        this.firer.fire();
    }

    public void disable(Set<Module> set) throws IllegalArgumentException {
        this.assertWritable();
        Util.err.fine("disable: " + set);
        if (set.isEmpty()) {
            return;
        }
        List<Module> list = this.simulateDisable(set);
        Util.err.fine("disable: toDisable=" + list);
        for (Module module : list) {
            if (set.contains((Object)module) || module.isAutoload() || module.isEager()) continue;
            throw new IllegalArgumentException("Would also need to disable: " + (Object)((Object)module));
        }
        Util.err.fine("disable: verified dependencies");
        this.ev.log("startDisableModules", list);
        this.installer.unload(list);
        for (Module module : list) {
            this.installer.dispose(module);
            module.setEnabled(false);
            module.classLoaderDown();
        }
        System.gc();
        System.runFinalization();
        for (Module module : list) {
            module.cleanup();
        }
        Util.err.fine("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        for (Module module : list) {
            this.firer.change(new ChangeFirer.Change((Object)module, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)module, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", list);
        this.firer.fire();
    }

    public List<Module> simulateEnable(Set<Module> set) throws IllegalArgumentException {
        Object object;
        Object object22;
        HashSet<Module> hashSet = new HashSet<Module>(set.size() * 2 + 1);
        for (Object object22 : set) {
            if (object22.isAutoload()) {
                throw new IllegalArgumentException("Cannot simulate enabling an autoload: " + (Object)object22);
            }
            if (object22.isEager()) {
                throw new IllegalArgumentException("Cannot simulate enabling an eager module: " + (Object)object22);
            }
            if (object22.isEnabled()) {
                throw new IllegalArgumentException("Already enabled: " + (Object)object22);
            }
            if (!object22.isValid()) {
                throw new IllegalArgumentException("Not managed by me: " + (Object)object22 + " in " + (Object)object22);
            }
            this.maybeAddToEnableList((Set<Module>)hashSet, set, (Module)((Object)object22), true);
        }
        HashSet<Module> hashSet2 = new HashSet<Module>(this.modules);
        object22 = hashSet2.iterator();
        while (object22.hasNext()) {
            object = (Module)((Object)object22.next());
            if (!object.isEnabled() && !hashSet.contains(object)) continue;
            object22.remove();
        }
        while (this.searchForPossibleEager(hashSet, (Set<Module>)hashSet2, set)) {
        }
        object = Util.moduleDependencies(hashSet, this.modulesByName, this.providersOf);
        try {
            List list = Utilities.topologicalSort(hashSet, (Map)object);
            Collections.reverse(list);
            return list;
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, topologicalSortException);
            }
            Util.err.warning("Cyclic module dependencies, will refuse to enable: " + (Object)object);
            return Collections.emptyList();
        }
    }

    private void maybeAddToEnableList(Set<Module> set, Set<Module> set2, Module module, boolean bl) {
        if (!this.missingDependencies(module).isEmpty()) {
            assert (bl) : "Module " + (Object)((Object)module) + " had unexpected problems: " + this.missingDependencies(module) + " (willEnable: " + set + " mightEnable: " + set2 + ")";
            return;
        }
        if (!set.add(module)) {
            return;
        }
        for (Dependency dependency : module.getDependenciesArray()) {
            Set<Module> set3;
            if (dependency.getType() == 1) {
                set3 = (String)Util.parseCodeName(dependency.getName())[0];
                Module module2 = this.get((String)((Object)set3));
                if (module2 == null) {
                    throw new IllegalStateException("Should have found module: " + (String)((Object)set3));
                }
                if (module2.isEnabled()) continue;
                this.maybeAddToEnableList(set, set2, module2, false);
                continue;
            }
            if (dependency.getType() != 5 && dependency.getType() != 6 && dependency.getType() != 7) continue;
            set3 = this.providersOf.get(dependency.getName());
            if (set3 == null) {
                assert (dependency.getType() == 7) : "Should have found a provider of " + dependency;
                continue;
            }
            boolean bl2 = false;
            for (Module module3 : set3) {
                if (!module3.isEnabled() && (!module3.getProblems().isEmpty() || !set2.contains((Object)module3))) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            for (Module module3 : set3) {
                this.maybeAddToEnableList(set, set2, module3, true);
                if (bl2 || !set.contains((Object)module3)) continue;
                bl2 = true;
            }
            assert (bl2 || dependency.getType() == 7) : "Should have found a nonproblematic provider of " + dependency + " among " + set3 + " with willEnable=" + set + " mightEnable=" + set2;
        }
    }

    private boolean searchForPossibleEager(Set<Module> set, Set<Module> set2, Set<Module> set3) {
        boolean bl = false;
        Iterator<Module> iterator = set2.iterator();
        while (iterator.hasNext()) {
            Module module = iterator.next();
            if (set.contains((Object)module)) {
                iterator.remove();
                continue;
            }
            if (!module.isEager() || !this.couldBeEnabledWithEagers(module, set, new HashSet<Module>())) continue;
            bl = true;
            iterator.remove();
            this.maybeAddToEnableList(set, set3, module, false);
        }
        return bl;
    }

    private boolean couldBeEnabledWithEagers(Module module, Set<Module> set, Set<Module> set2) {
        if (module.isEnabled() || set.contains((Object)module)) {
            return true;
        }
        if (!module.isAutoload() && !module.isEager()) {
            return false;
        }
        if (!module.getProblems().isEmpty()) {
            return false;
        }
        if (!set2.add(module)) {
            return true;
        }
        Dependency[] dependencyArray = module.getDependenciesArray();
        for (int i = 0; i < dependencyArray.length; ++i) {
            Set<Module> set3;
            Dependency dependency = dependencyArray[i];
            if (dependency.getType() == 1) {
                set3 = (String)Util.parseCodeName(dependency.getName())[0];
                Module module2 = this.get((String)((Object)set3));
                if (module2 == null) {
                    throw new IllegalStateException("Should have found module: " + (String)((Object)set3));
                }
                if (this.couldBeEnabledWithEagers(module2, set, set2)) continue;
                return false;
            }
            if (dependency.getType() != 5) continue;
            set3 = this.providersOf.get(dependency.getName());
            if (set3 == null) {
                throw new IllegalStateException("Should have found a provider of: " + dependency.getName());
            }
            boolean bl = false;
            for (Module module3 : set3) {
                if (!this.couldBeEnabledWithEagers(module3, set, set2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public List<Module> simulateDisable(Set<Module> set) throws IllegalArgumentException {
        Object object2;
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Module> hashSet = new HashSet<Module>(20);
        for (Object object2 : set) {
            if (object2.isAutoload()) {
                throw new IllegalArgumentException("Cannot disable autoload: " + (Object)object2);
            }
            if (object2.isEager()) {
                throw new IllegalArgumentException("Cannot disable eager module: " + (Object)object2);
            }
            if (object2.isFixed()) {
                throw new IllegalArgumentException("Cannot disable fixed module: " + (Object)object2);
            }
            if (!object2.isEnabled()) {
                throw new IllegalArgumentException("Already disabled: " + (Object)object2);
            }
            this.addToDisableList((Set<Module>)hashSet, (Module)((Object)object2));
        }
        HashSet<Module> hashSet2 = new HashSet<Module>(this.getEnabledModules());
        hashSet2.removeAll(hashSet);
        while (this.searchForUnusedAutoloads(hashSet, (Set<Module>)hashSet2)) {
        }
        object2 = Util.moduleDependencies(hashSet, this.modulesByName, this.providersOf);
        try {
            return Utilities.topologicalSort(hashSet, (Map)object2);
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, topologicalSortException);
            }
            Util.err.warning("Cyclic module dependencies, will turn them off in a random order: " + (Object)object2);
            return new ArrayList<Module>(hashSet);
        }
    }

    private void addToDisableList(Set<Module> set, Module module) {
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        block0: for (Module module2 : this.modules) {
            if (module2.isFixed() || !module2.isEnabled() || set.contains((Object)module2)) continue;
            Dependency[] dependencyArray = module2.getDependenciesArray();
            for (int i = 0; i < dependencyArray.length; ++i) {
                Dependency dependency = dependencyArray[i];
                if (dependency.getType() == 1) {
                    if (!dependency.getName().equals(module.getCodeName())) continue;
                    this.addToDisableList(set, module2);
                    continue block0;
                }
                if (dependency.getType() != 5 && dependency.getType() != 6 || !module.provides(dependency.getName())) continue;
                boolean bl = false;
                for (Module module3 : this.getEnabledModules()) {
                    if (!module3.isEnabled() || set.contains((Object)module3) || !module3.provides(dependency.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.addToDisableList(set, module2);
                continue block0;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set<Module> set, Set<Module> set2) {
        boolean bl = false;
        Iterator<Module> iterator = set2.iterator();
        block0: while (iterator.hasNext()) {
            Module module = iterator.next();
            if (!module.isAutoload()) continue;
            for (Module module2 : set2) {
                Dependency[] dependencyArray = module2.getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    Dependency dependency = dependencyArray[i];
                    if (dependency.getType() == 1 ? Util.parseCodeName(dependency.getName())[0].equals(module.getCodeNameBase()) : (dependency.getType() == 5 || dependency.getType() == 6 || dependency.getType() == 7) && module.provides(dependency.getName())) continue block0;
                }
            }
            bl = true;
            iterator.remove();
            set.add(module);
        }
        return bl;
    }

    Set<Union2<Dependency, InvalidException>> missingDependencies(Module module) {
        return this.missingDependencies(module, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Union2<Dependency, InvalidException>> missingDependencies(Module module, boolean bl) {
        Map<Module, Set<Union2<Dependency, InvalidException>>> map = this.moduleProblemsWithNeeds;
        synchronized (map) {
            Map<Module, Set<Union2<Dependency, InvalidException>>> map2 = bl ? this.moduleProblemsWithNeeds : this.moduleProblemsWithoutNeeds;
            Set<Union2<Dependency, InvalidException>> set = map2.get((Object)module);
            if (set == null) {
                set = new HashSet<Union2<Dependency, InvalidException>>(8);
                if (bl) {
                    set.addAll(this.missingDependencies(module, false));
                }
                set.add(PROBING_IN_PROCESS);
                map2.put(module, set);
                for (Dependency dependency : module.getDependenciesArray()) {
                    int n;
                    Set<Module> set2;
                    Object object;
                    if (dependency.getType() == 2) continue;
                    if (dependency.getType() == 1) {
                        object = Util.parseCodeName(dependency.getName());
                        set2 = (String)object[0];
                        n = object[1] != null ? (Integer)object[1] : -1;
                        int n2 = object[2] != null ? (Integer)object[2] : n;
                        Module module2 = this.get((String)((Object)set2));
                        if (module2 == null) {
                            set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                            continue;
                        }
                        if (n == n2) {
                            if (n != module2.getCodeNameRelease()) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                            if (dependency.getComparison() == 2 && !Utilities.compareObjects((Object)dependency.getVersion(), (Object)module2.getImplementationVersion())) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                            if (dependency.getComparison() == 1 && new SpecificationVersion(dependency.getVersion()).compareTo((Object)module2.getSpecificationVersion()) > 0) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                        } else if (n < n2) {
                            int n3 = module2.getCodeNameRelease();
                            if (n3 < n || n3 > n2) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                            if (dependency.getComparison() == 2) {
                                throw new IllegalStateException("No such thing as ranged impl dep");
                            }
                            if (dependency.getComparison() == 1 && n3 == n && new SpecificationVersion(dependency.getVersion()).compareTo((Object)module2.getSpecificationVersion()) > 0) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                        } else {
                            throw new IllegalStateException("Upside-down rel vers range");
                        }
                        if (module2.isEnabled() || (bl || this.missingDependencies(module2, false).isEmpty()) && (!bl || ModuleManager.isAlmostEmpty(this.missingDependencies(module2, true)))) continue;
                        set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                        continue;
                    }
                    if (dependency.getType() == 5 || bl && dependency.getType() == 6) {
                        object = dependency.getName();
                        set2 = this.providersOf.get(object);
                        if (set2 == null) {
                            set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                            continue;
                        }
                        n = 0;
                        for (Module module2 : set2) {
                            if (n != 0) break;
                            if (module2.isEnabled()) {
                                n = 1;
                                continue;
                            }
                            if ((bl || !this.missingDependencies(module2, false).isEmpty()) && (!bl || !ModuleManager.isAlmostEmpty(this.missingDependencies(module2, true)))) continue;
                            n = 1;
                        }
                        if (n != 0) continue;
                        set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                        continue;
                    }
                    if (dependency.getType() != 3 || Util.checkJavaDependency(dependency)) continue;
                    set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                }
                set.remove(PROBING_IN_PROCESS);
            }
            return set;
        }
    }

    private static boolean isAlmostEmpty(Set<Union2<Dependency, InvalidException>> set) {
        return set.isEmpty() || ((Object)set).equals(Collections.singleton(PROBING_IN_PROCESS));
    }

    private void clearProblemCache() {
        this.clearProblemCache(this.moduleProblemsWithoutNeeds);
        this.clearProblemCache(this.moduleProblemsWithNeeds);
    }

    private void clearProblemCache(Map<Module, Set<Union2<Dependency, InvalidException>>> map) {
        Iterator<Map.Entry<Module, Set<Union2<Dependency, InvalidException>>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<Union2<Dependency, InvalidException>> set;
            Map.Entry<Module, Set<Union2<Dependency, InvalidException>>> entry = iterator.next();
            Module module = entry.getKey();
            if (module.isEnabled() || (set = entry.getValue()) == null) continue;
            boolean bl = false;
            for (Union2<Dependency, InvalidException> union2 : set) {
                Dependency dependency;
                if (union2.hasSecond() || (dependency = (Dependency)union2.first()).getType() != 1 && dependency.getType() != 5 && dependency.getType() != 6 && dependency.getType() != 7) continue;
                bl = true;
                break;
            }
            if (!bl && !set.isEmpty()) continue;
            iterator.remove();
            this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        }
    }

    public boolean shutDown() {
        return this.shutDown(null);
    }

    public boolean shutDown(Runnable runnable) {
        List list;
        this.assertWritable();
        Set<Module> set = this.getEnabledModules();
        Map<Module, List<Module>> map = Util.moduleDependencies(set, this.modulesByName, this.providersOf);
        try {
            list = Utilities.topologicalSort(set, map);
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, topologicalSortException);
            }
            Util.err.warning("Cyclic module dependencies, will not shut down cleanly: " + map);
            return true;
        }
        if (!this.installer.closing(list)) {
            return false;
        }
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.WARNING, null, runtimeException);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.WARNING, null, linkageError);
            }
        }
        this.installer.close(list);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SystemClassLoader
    extends JarClassLoader {
        private final PermissionCollection allPermissions = new Permissions();
        private final StringBuffer debugme;
        private boolean empty = true;

        public SystemClassLoader(List<File> list, ClassLoader[] classLoaderArray, Set<Module> set) throws IllegalArgumentException {
            super(list, classLoaderArray, false);
            this.allPermissions.add(new AllPermission());
            this.allPermissions.setReadOnly();
            this.debugme = new StringBuffer(100 + 50 * set.size());
            this.debugme.append("SystemClassLoader[");
            for (File file : list) {
                if (this.empty) {
                    this.empty = false;
                } else {
                    this.debugme.append(',');
                }
                this.debugme.append(file.getAbsolutePath());
            }
            this.record(set);
            this.debugme.append(']');
        }

        private void record(Collection<Module> collection) {
            for (Module module : collection) {
                if (this.empty) {
                    this.empty = false;
                } else {
                    this.debugme.append(',');
                }
                this.debugme.append(module.getCodeNameBase());
            }
        }

        public void append(ClassLoader[] classLoaderArray, List<Module> list) throws IllegalArgumentException {
            super.append(classLoaderArray);
            this.debugme.deleteCharAt(this.debugme.length() - 1);
            this.record(list);
            this.debugme.append(']');
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.fine("Collected system class loader");
        }

        public String toString() {
            if (this.debugme == null) {
                return "SystemClassLoader";
            }
            return this.debugme.toString();
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return this.allPermissions;
        }
    }
}

