/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class CheckForUpdatesDialog
extends JDialog {
    private static final String CHECK_UPDATES_URL = "http://www.muntjak.de/hans/java/tinylaf/checkforupdate.html";

    private CheckForUpdatesDialog(Frame parent) {
        super(parent);
        this.setupUI(parent);
    }

    static void showDialog(Frame parent) {
        new CheckForUpdatesDialog(parent);
    }

    private void setupUI(Frame frame) {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel p = new JPanel(new BorderLayout(0, 12));
        JLabel l = new JLabel("<html>When checking for updates, TinyLaF will connect to <b>muntjak.de</b><br>via HTTP. No personal data will be transmitted.");
        l.setBorder(new EmptyBorder(8, 8, 0, 8));
        p.add((Component)l, "North");
        JButton b = new JButton("Check for updates now");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String msg = CheckForUpdatesDialog.this.checkForUpdates();
                JOptionPane.showMessageDialog(CheckForUpdatesDialog.this, msg, "Update information", -1);
            }
        });
        JPanel flow = new JPanel(new FlowLayout(1, 0, 8));
        flow.add(b);
        p.add((Component)flow, "Center");
        p.add((Component)new JSeparator(), "South");
        this.getContentPane().add((Component)p, "Center");
        b = new JButton("Close");
        this.getRootPane().setDefaultButton(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckForUpdatesDialog.this.dispose();
            }
        });
        flow = new JPanel(new FlowLayout(1, 0, 8));
        flow.add(b);
        this.getContentPane().add((Component)flow, "South");
        this.pack();
        this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private String checkForUpdates() {
        String answer = this.checkForUpdate();
        if (answer.indexOf("Exception") != -1) {
            return answer;
        }
        if (!answer.startsWith("TinyLaF ") || !answer.endsWith(")") || answer.indexOf("(") == -1 || answer.indexOf("/") == -1) {
            return "An exception occured while checking for updates.\n\nException was: Invalid response.";
        }
        String version = answer.substring(8, answer.indexOf("(") - 1);
        if (!"1.3.05".equals(version)) {
            return "An updated version of TinyLaF is available:\n" + answer + "." + "\nIt can be downloaded at www.muntjak.de/hans/java/tinylaf/.";
        }
        return "No updated version of TinyLaF available.";
    }

    private String checkForUpdate() {
        InputStream is = null;
        try {
            URL url = new URL(CHECK_UPDATES_URL);
            try {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "TinyLaF");
                Object content = conn.getContent();
                if (!(content instanceof InputStream)) {
                    return "An exception occured while checking for updates.\n\nException was: Content is no InputStream";
                }
                is = (InputStream)content;
            }
            catch (ConnectException ex) {
                return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
            }
            catch (UnknownHostException ex) {
                return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
            }
            catch (IOException ex) {
                return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
            }
        }
        catch (MalformedURLException ex) {
            return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuffer buff = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buff.append(line);
            }
            in.close();
            return buff.toString();
        }
        catch (IOException ex) {
            return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
        }
    }
}

