/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.borders.TinyToolButtonBorder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalToolBarUI;

public class TinyToolBarUI
extends MetalToolBarUI {
    public static final int floatableGripSize = 8;
    private static Border toolButtonBorder = new TinyToolButtonBorder();

    public static ComponentUI createUI(JComponent c) {
        return new TinyToolBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new JDialog((Dialog)window, toolbar.getName(), false) : new JDialog(null, toolbar.getName(), false));
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    public void paint(Graphics g, JComponent c) {
        if (c.getBackground() instanceof ColorUIResource) {
            g.setColor(Theme.toolBarColor[Theme.style].getColor());
        } else {
            g.setColor(c.getBackground());
        }
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    protected void setBorderToRollover(Component c) {
        this.setBorderToNormal(c);
    }

    protected void setBorderToNormal(Component c) {
        if (!(c instanceof AbstractButton)) {
            return;
        }
        if (c instanceof JCheckBox) {
            return;
        }
        if (c instanceof JRadioButton) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        b.setRolloverEnabled(true);
        b.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        if (!(b.getBorder() instanceof UIResource) && !(b.getBorder() instanceof TinyToolButtonBorder)) {
            return;
        }
        b.setBorder(toolButtonBorder);
    }
}

