/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import tr.appl.InitialAction;
import tr.appl.InitialActionLookup;
import tr.prefs.gui.GUIOptionsPanelController;
import tr.prefs.gui.GUIPrefs;

final class GUIOptionsPanel
extends JPanel {
    private static final Class clazz = GUIOptionsPanel.class;
    private static final String INITIAL_NONE = NbBundle.getMessage((Class)clazz, (String)"LBL_InitialWindowNone");
    private static final String TOP = NbBundle.getMessage((Class)clazz, (String)"LBL_Top");
    private static final String BOTTOM = NbBundle.getMessage((Class)clazz, (String)"LBL_Bottom");
    private static final String LEFT = NbBundle.getMessage((Class)clazz, (String)"LBL_Left");
    private static final String RIGHT = NbBundle.getMessage((Class)clazz, (String)"LBL_Right");
    private final GUIOptionsPanelController controller;
    private JComboBox buttonsPositionCombo;
    private JLabel buttonsPositionLabel;
    private JComboBox initialActionCombo;
    private JLabel initialActionLabel;
    private static Vector<ComboItem> actions;
    private static Vector<ComboItem> positions;

    GUIOptionsPanel(GUIOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.initialActionLabel = new JLabel();
        this.initialActionCombo = new JComboBox();
        this.buttonsPositionLabel = new JLabel();
        this.buttonsPositionCombo = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setMinimumSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((JLabel)this.initialActionLabel, (String)NbBundle.getMessage(GUIOptionsPanel.class, (String)"LBL_InitialWindow"));
        this.initialActionLabel.setMaximumSize(new Dimension(150, 23));
        this.initialActionLabel.setMinimumSize(new Dimension(150, 23));
        this.initialActionLabel.setPreferredSize(new Dimension(150, 23));
        this.initialActionCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.initialActionCombo.setMinimumSize(new Dimension(41, 23));
        this.initialActionCombo.setPreferredSize(new Dimension(41, 23));
        this.initialActionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIOptionsPanel.this.windowSelected(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.buttonsPositionLabel, (String)NbBundle.getMessage(GUIOptionsPanel.class, (String)"LBL_ButtonsPosition"));
        this.buttonsPositionLabel.setMaximumSize(new Dimension(150, 23));
        this.buttonsPositionLabel.setMinimumSize(new Dimension(150, 23));
        this.buttonsPositionLabel.setPreferredSize(new Dimension(150, 23));
        this.buttonsPositionCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.buttonsPositionCombo.setMinimumSize(new Dimension(41, 23));
        this.buttonsPositionCombo.setPreferredSize(new Dimension(41, 23));
        this.buttonsPositionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIOptionsPanel.this.positionSelected(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.buttonsPositionLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.buttonsPositionCombo, 0, 209, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.initialActionLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.initialActionCombo, 0, 209, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.initialActionLabel, -2, -1, -2).add((Component)this.initialActionCombo, -2, -1, -2)).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.buttonsPositionLabel, -2, -1, -2).add((Component)this.buttonsPositionCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void positionSelected(ActionEvent evt) {
        this.controller.changed();
    }

    private void windowSelected(ActionEvent evt) {
        this.controller.changed();
    }

    void load() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doLoad();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUIOptionsPanel.this.doLoad();
                }
            });
        }
    }

    private void doLoad() {
        this.initActionsItems();
        this.initialActionCombo.setModel(new DefaultComboBoxModel<ComboItem>(actions));
        this.initialActionCombo.setMaximumRowCount(actions.size());
        this.initialActionCombo.setSelectedItem(this.getActionItem(GUIPrefs.getInitialActionID()));
        this.initPositionItems();
        this.buttonsPositionCombo.setModel(new DefaultComboBoxModel<ComboItem>(positions));
        this.buttonsPositionCombo.setMaximumRowCount(positions.size());
        this.buttonsPositionCombo.setSelectedItem(this.getPositionItem(GUIPrefs.getButtonsPosition()));
    }

    private void initActionsItems() {
        actions = new Vector();
        actions.add(new ComboItem(INITIAL_NONE, "none"));
        Lookup.Result r = InitialActionLookup.instance().lookup(new Lookup.Template(InitialAction.class));
        Collection c = r.allInstances();
        for (InitialAction action : c) {
            actions.add(new ComboItem(action.getName(), action.getID()));
        }
        Collections.sort(actions);
    }

    private void initPositionItems() {
        positions = new Vector();
        positions.add(new ComboItem(TOP, "top"));
        positions.add(new ComboItem(BOTTOM, "bottom"));
        positions.add(new ComboItem(LEFT, "left"));
        positions.add(new ComboItem(RIGHT, "right"));
    }

    void store() {
        ComboItem positionItem;
        ComboItem actionItem = (ComboItem)this.initialActionCombo.getSelectedItem();
        if (actionItem != null) {
            GUIPrefs.setInitialWindowID(actionItem.value);
        }
        if ((positionItem = (ComboItem)this.buttonsPositionCombo.getSelectedItem()) != null) {
            GUIPrefs.setButtonsPosition(positionItem.value);
        }
    }

    boolean valid() {
        return true;
    }

    private ComboItem getActionItem(String value) {
        for (ComboItem item : actions) {
            if (!item.value.equals(value)) continue;
            return item;
        }
        return actions.get(0);
    }

    private ComboItem getPositionItem(String value) {
        for (ComboItem item : positions) {
            if (!item.value.equals(value)) continue;
            return item;
        }
        return positions.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComboItem
    implements Comparable<ComboItem> {
        public String label;
        public String value;

        public ComboItem(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(ComboItem item) {
            if (this.value.equals("none")) {
                return -1;
            }
            return this.toString().compareToIgnoreCase(item.toString());
        }
    }
}

