/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topics.screen;

import java.awt.Toolkit;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.topic.Topic;
import tr.model.topic.TopicUtils;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.view.topics.DeleteTopicCookie;
import tr.view.topics.EditTopicCookie;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;
import tr.view.topics.dialog.TopicDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicNode
extends AbstractNode
implements EditTopicCookie,
DeleteTopicCookie {
    public final Manager<Topic> manager;
    public final Topic topic;

    public TopicNode(Manager<Topic> manager, Topic topic) {
        super(Children.LEAF, Lookups.singleton((Object)topic));
        this.manager = manager;
        this.topic = topic;
    }

    public String getName() {
        return this.topic == null ? "" : this.topic.getName();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == EditTopicCookie.class) {
            return this;
        }
        if (clazz == DeleteTopicCookie.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    @Override
    public void editTopic() {
        if (this.topic == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        if (this.topic.equals((Object)Topic.getDefault())) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        new TopicDialog(data).showModifyDialog(this.topic);
    }

    @Override
    public void deleteTopic() {
        if (this.topic == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        if (this.topic.equals((Object)Topic.getDefault())) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (TopicUtils.instance().isUsed(data, this.topic)) {
            TopicsComboBox ccb = new TopicsComboBox((ComboBoxModel)new TopicsComboBoxModel(false));
            ccb.setSelectedIndex(0);
            JPanel panel = new JPanel();
            panel.add(new JLabel(NbBundle.getMessage(this.getClass(), (String)"MSG_ReplaceTopic")));
            panel.add(ccb);
            String title = "Delete Topic: " + this.topic.getName();
            int r = JOptionPane.showConfirmDialog(null, panel, title, 2);
            if (r == 2) {
                return;
            }
            Topic replacement = (Topic)ccb.getSelectedItem();
            if (!TopicUtils.instance().replace(data, this.topic, replacement)) {
                String msg = "Can not replace topic: " + this.topic.getName() + "\n" + " with topic: " + replacement.getName() + "\n\n";
                JOptionPane.showMessageDialog(null, msg);
                return;
            }
        }
        data.getTopicManager().remove((Observable)this.topic);
    }
}

