'''OpenGL extension SGIX.async_pixel

Overview (from the spec)
	
	This extension introduces a new asynchronous mode for texture
	download, pixel download and pixel readback commands.  It allows
	programs to transfer textures or images between the host and the
	graphics accelerator in parallel with the execution of other
	graphics commands (possibly taking advantage of a secondary path
	to the graphics accelerator).  It also allows programs to issue
	non-blocking pixel readback commands that return immediately after
	they are issued so that the program can issue other commands while
	the readback takes place.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIX/async_pixel.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIX_async_pixel'
GL_ASYNC_TEX_IMAGE_SGIX = constant.Constant( 'GL_ASYNC_TEX_IMAGE_SGIX', 0x835C )
glget.addGLGetConstant( GL_ASYNC_TEX_IMAGE_SGIX, (1,) )
GL_ASYNC_DRAW_PIXELS_SGIX = constant.Constant( 'GL_ASYNC_DRAW_PIXELS_SGIX', 0x835D )
glget.addGLGetConstant( GL_ASYNC_DRAW_PIXELS_SGIX, (1,) )
GL_ASYNC_READ_PIXELS_SGIX = constant.Constant( 'GL_ASYNC_READ_PIXELS_SGIX', 0x835E )
glget.addGLGetConstant( GL_ASYNC_READ_PIXELS_SGIX, (1,) )
GL_MAX_ASYNC_TEX_IMAGE_SGIX = constant.Constant( 'GL_MAX_ASYNC_TEX_IMAGE_SGIX', 0x835F )
glget.addGLGetConstant( GL_MAX_ASYNC_TEX_IMAGE_SGIX, (1,) )
GL_MAX_ASYNC_DRAW_PIXELS_SGIX = constant.Constant( 'GL_MAX_ASYNC_DRAW_PIXELS_SGIX', 0x8360 )
glget.addGLGetConstant( GL_MAX_ASYNC_DRAW_PIXELS_SGIX, (1,) )
GL_MAX_ASYNC_READ_PIXELS_SGIX = constant.Constant( 'GL_MAX_ASYNC_READ_PIXELS_SGIX', 0x8361 )
glget.addGLGetConstant( GL_MAX_ASYNC_READ_PIXELS_SGIX, (1,) )


def glInitAsyncPixelSGIX():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
