"""
unit tests for module textutils
squeleton generated by /home/syt/cvs_work/logilab/pyreverse/py2tests.py on Sep 08 at 09:1:31

"""
import re
from os import linesep

from logilab.common import textutils as tu # .textutils import *
from logilab.common.testlib import TestCase, DocTest, unittest_main


if linesep != '\n':
    import re
    LINE_RGX = re.compile(linesep)
    def ulines(string):
        return LINE_RGX.sub('\n', string)
else:
    def ulines(string):
        return string

class NormalizeTextTC(TestCase):

    def test_known_values(self):
        self.assertEquals(ulines(tu.normalize_text('''some really malformated
        text.
With some times some veeeeeeeeeeeeeeerrrrryyyyyyyyyyyyyyyyyyy loooooooooooooooooooooong linnnnnnnnnnnes

and empty lines!
        ''')),
                         '''some really malformated text. With some times some
veeeeeeeeeeeeeeerrrrryyyyyyyyyyyyyyyyyyy loooooooooooooooooooooong
linnnnnnnnnnnes

and empty lines!''')
        self.assertTextEquals(ulines(tu.normalize_text('''\
some ReST formated text
=======================
With some times some veeeeeeeeeeeeeeerrrrryyyyyyyyyyyyyyyyyyy loooooooooooooooooooooong linnnnnnnnnnnes
and normal lines!

another paragraph
        ''', rest=True)),
                         '''\
some ReST formated text
=======================
With some times some veeeeeeeeeeeeeeerrrrryyyyyyyyyyyyyyyyyyy
loooooooooooooooooooooong linnnnnnnnnnnes
and normal lines!

another paragraph''')

    def test_nonregr_unsplitable_word(self):
        self.assertEquals(ulines(tu.normalize_text('''petit complement :

http://www.plonefr.net/blog/archive/2005/10/30/tester-la-future-infrastructure-i18n
''', 80)),
                         '''petit complement :

http://www.plonefr.net/blog/archive/2005/10/30/tester-la-future-infrastructure-i18n''')


    def test_nonregr_rest_normalize(self):
        self.assertEquals(ulines(tu.normalize_text("""... Il est donc evident que tout le monde doit lire le compte-rendu de RSH et aller discuter avec les autres si c'est utile ou necessaire.


**adim**: un poil de ginco, une pincee d'agueol, du pypy et 10 jours de dijon d'ici la fin du mois dont 4 sur place.

**alf**: une intro a  pypy, un peu de ginco peut-etre et preparer cours IN2P01.

**arthur**: y'a du eStock a  faire

**auc**: atuk02 et ginco

**david**: terminer EDFC21 qui etait du pour le 21 decembre et pour lequel il reste encore 1 semaine

**jphc**: deposer les comptes, finir des papiers administratifs, envoyer des voeux et garder un oeil sur les reponses a  faire et nouveaux appels.


**katia**: AGRI06 vient de demarrer et y'a besoin d'arthur

**ludal**: terminer EDFC16 devrait prendre jusqu'a  mardi prochain.

**nico**: qq reponses (dont EADA03 pour laquelle il me faudra de l'aide de gens qui aiment l'admin sys) et mise en place d'un tableau de bord propre a  partir de ce qu'on a deja  (situation des comptes, affaires en cours avec nb de jours prevu et depenses, etc.).

**ocy**: voeux, recrutement, tableau de bord, reponses

**syt**: il sera avec alf a  compter de jeudi pour preparation sprint pypy et ptet un peu de ginco sur les bords
        """, rest=True)), """... Il est donc evident que tout le monde doit lire le compte-rendu de RSH et
aller discuter avec les autres si c'est utile ou necessaire.

**adim**: un poil de ginco, une pincee d'agueol, du pypy et 10 jours de dijon
d'ici la fin du mois dont 4 sur place.

**alf**: une intro a pypy, un peu de ginco peut-etre et preparer cours IN2P01.

**arthur**: y'a du eStock a faire

**auc**: atuk02 et ginco

**david**: terminer EDFC21 qui etait du pour le 21 decembre et pour lequel il
reste encore 1 semaine

**jphc**: deposer les comptes, finir des papiers administratifs, envoyer des
voeux et garder un oeil sur les reponses a faire et nouveaux appels.

**katia**: AGRI06 vient de demarrer et y'a besoin d'arthur

**ludal**: terminer EDFC16 devrait prendre jusqu'a mardi prochain.

**nico**: qq reponses (dont EADA03 pour laquelle il me faudra de l'aide de gens
qui aiment l'admin sys) et mise en place d'un tableau de bord propre a partir de
ce qu'on a deja (situation des comptes, affaires en cours avec nb de jours prevu
et depenses, etc.).

**ocy**: voeux, recrutement, tableau de bord, reponses

**syt**: il sera avec alf a compter de jeudi pour preparation sprint pypy et
ptet un peu de ginco sur les bords""")

    def test_normalize_rest_paragraph(self):
        self.assertEquals(ulines(tu.normalize_rest_paragraph("""**nico**: qq reponses (dont EADA03 pour laquelle il me faudra de l'aide de gens
qui aiment l'admin sys) et mise en place d'un tableau de bord propre a partir de ce qu'on a deja (situation des comptes, affaires en cours avec nb de jours prevu et depenses, etc.).""")),
                          """**nico**: qq reponses (dont EADA03 pour laquelle il me faudra de l'aide de gens
qui aiment l'admin sys) et mise en place d'un tableau de bord propre a partir de
ce qu'on a deja (situation des comptes, affaires en cours avec nb de jours prevu
et depenses, etc.).""")

    def test_normalize_rest_paragraph(self):
        self.assertEquals(ulines(tu.normalize_rest_paragraph("""**syt**: il sera avec alf a compter de jeudi pour preparation sprint pypy et ptet un peu de ginco sur les bords""")),
                              """**syt**: il sera avec alf a compter de jeudi pour preparation sprint pypy et\nptet un peu de ginco sur les bords""")

        
class NormalizeParagraphTC(TestCase):

    def test_known_values(self):
        self.assertEquals(ulines(tu.normalize_text("""This package contains test files shared by the logilab-common package. It isn't
necessary to install this package unless you want to execute or look at
the tests.""", indent=' ', line_len=70)),
                         """\
 This package contains test files shared by the logilab-common
 package. It isn't necessary to install this package unless you want
 to execute or look at the tests.""")

        
class GetCsvTC(TestCase):

    def test_known(self):
        self.assertEquals(tu.get_csv('a, b,c '), ['a', 'b', 'c'])

    
RGX = re.compile('abcd')
class PrettyMatchTC(TestCase):

    def test_known(self):
        string = 'hiuherabcdef'
        self.assertEquals(ulines(tu.pretty_match(RGX.search(string), string)),
                         'hiuherabcdef\n      ^^^^')
    def test_known_values_1(self):
        rgx = re.compile('(to*)')
        string = 'toto'
        match = rgx.search(string)
        self.assertEquals(ulines(tu.pretty_match(match, string)), '''toto
^^''')
        
    def test_known_values_2(self):
        rgx = re.compile('(to*)')
        string = ''' ... ... to to
 ... ... '''
        match = rgx.search(string)
        self.assertEquals(ulines(tu.pretty_match(match, string)), ''' ... ... to to
         ^^
 ... ...''')
        
        

class UnquoteTC(TestCase):
    def test(self):
        self.assertEquals(tu.unquote('"toto"'), 'toto')
        self.assertEquals(tu.unquote("'l'inenarrable toto'"), "l'inenarrable toto")
        self.assertEquals(tu.unquote("no quote"), "no quote")

        
class ColorizeAnsiTC(TestCase):
    def test_known(self):
        self.assertEquals(tu.colorize_ansi('hello', 'blue', 'strike'), '\x1b[9;34mhello\x1b[0m')
        self.assertEquals(tu.colorize_ansi('hello', style='strike, inverse'), '\x1b[9;7mhello\x1b[0m')
        self.assertEquals(tu.colorize_ansi('hello', None, None), 'hello')
        self.assertEquals(tu.colorize_ansi('hello', '', ''), 'hello')
    def test_raise(self):
        self.assertRaises(KeyError, tu.colorize_ansi, 'hello', 'bleu', None)
        self.assertRaises(KeyError, tu.colorize_ansi, 'hello', None, 'italique')


class ModuleDocTest(DocTest):
    """test doc test in this module"""
    module = tu
    # from logilab.common import textutils as module
del DocTest # necessary if we don't want it to be executed (we don't...)
        
if __name__ == '__main__':
    unittest_main()
