/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.syntaxchecker;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.PyParser;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

public class PySyntaxChecker
extends PyDevBuilderVisitor {
    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        SourceModule mod;
        PythonNature nature = this.getPythonNature(resource);
        if (nature == null) {
            return;
        }
        if (PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor()) {
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)this, (String)"PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor()");
            }
            return;
        }
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)this, (String)"Checking!");
        }
        try {
            mod = this.getSourceModule(resource, document, nature);
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
            return;
        }
        Throwable parseError = mod.parseError;
        try {
            PyParser.deleteErrorMarkers((IResource)resource);
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
        if (parseError != null) {
            try {
                PyParser.createParserErrorMarkers((Throwable)parseError, (IAdaptable)resource, (IDocument)document);
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
    }

    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
    }
}

