/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.ExtendedNodeInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.type.TypeHierarchy;

final class AttributeImpl
extends NodeImpl
implements ExtendedNodeInfo {
    private int nameCode;
    private int typeCode;
    private String value;

    public AttributeImpl(ElementImpl element, int index) {
        this.parent = element;
        this.index = index;
        AttributeCollection atts = element.getAttributeList();
        this.nameCode = atts.getNameCode(index);
        this.value = atts.getValue(index);
        this.typeCode = atts.getTypeAnnotation(index);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getTypeAnnotation() {
        return this.typeCode;
    }

    public boolean isId() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return th.isIdCode(this.typeCode);
    }

    public boolean isIdref() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return th.isIdrefsCode(this.typeCode);
    }

    public boolean isNilled() {
        return false;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof AttributeImpl)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        AttributeImpl otherAtt = (AttributeImpl)other;
        return this.parent.isSameNodeInfo(otherAtt.parent) && (this.nameCode & 0xFFFFF) == (otherAtt.nameCode & 0xFFFFF);
    }

    public int hashCode() {
        return this.parent.hashCode() ^ this.getFingerprint();
    }

    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + 32768L + (long)this.index;
    }

    public final int getNodeKind() {
        return 2;
    }

    public String getStringValue() {
        return this.value;
    }

    public NodeInfo getNextSibling() {
        return null;
    }

    public NodeInfo getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public NodeImpl getNextInDocument(NodeImpl anchor) {
        if (anchor == this) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(anchor);
    }

    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append('a');
        buffer.append(Integer.toString(this.index));
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        int nameCode = this.getNameCode();
        int typeCode = copyAnnotations ? this.getTypeAnnotation() : -1;
        out.attribute(nameCode, typeCode, this.getStringValue(), locationId, 0);
    }
}

