/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.trans.XPathException;

public class UnionEnumeration
implements SequenceIterator,
LookaheadIterator {
    private SequenceIterator e1;
    private SequenceIterator e2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private NodeOrderComparer comparer;
    private NodeInfo current = null;
    private int position = 0;

    public UnionEnumeration(SequenceIterator p1, SequenceIterator p2, NodeOrderComparer comparer) throws XPathException {
        this.e1 = p1;
        this.e2 = p2;
        this.comparer = comparer;
        this.nextNode1 = this.next(this.e1);
        this.nextNode2 = this.next(this.e2);
    }

    private NodeInfo next(SequenceIterator iter) throws XPathException {
        return (NodeInfo)iter.next();
    }

    public boolean hasNext() {
        return this.nextNode1 != null || this.nextNode2 != null;
    }

    public Item next() throws XPathException {
        ++this.position;
        if (this.nextNode1 != null && this.nextNode2 != null) {
            int c = this.comparer.compare(this.nextNode1, this.nextNode2);
            if (c < 0) {
                this.current = this.nextNode1;
                this.nextNode1 = this.next(this.e1);
                return this.current;
            }
            if (c > 0) {
                this.current = this.nextNode2;
                this.nextNode2 = this.next(this.e2);
                return this.current;
            }
            this.current = this.nextNode2;
            this.nextNode2 = this.next(this.e2);
            this.nextNode1 = this.next(this.e1);
            return this.current;
        }
        if (this.nextNode1 != null) {
            this.current = this.nextNode1;
            this.nextNode1 = this.next(this.e1);
            return this.current;
        }
        if (this.nextNode2 != null) {
            this.current = this.nextNode2;
            this.nextNode2 = this.next(this.e2);
            return this.current;
        }
        this.current = null;
        this.position = -1;
        return null;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new UnionEnumeration(this.e1.getAnother(), this.e2.getAnother(), this.comparer);
    }

    public int getProperties() {
        return 4;
    }
}

