/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class ScriptRuntime {
    public static final Class BooleanClass = Kit.classOrNull("java.lang.Boolean");
    public static final Class ByteClass = Kit.classOrNull("java.lang.Byte");
    public static final Class CharacterClass = Kit.classOrNull("java.lang.Character");
    public static final Class ClassClass = Kit.classOrNull("java.lang.Class");
    public static final Class DoubleClass = Kit.classOrNull("java.lang.Double");
    public static final Class FloatClass = Kit.classOrNull("java.lang.Float");
    public static final Class IntegerClass = Kit.classOrNull("java.lang.Integer");
    public static final Class LongClass = Kit.classOrNull("java.lang.Long");
    public static final Class NumberClass = Kit.classOrNull("java.lang.Number");
    public static final Class ObjectClass = Kit.classOrNull("java.lang.Object");
    public static final Class ShortClass = Kit.classOrNull("java.lang.Short");
    public static final Class StringClass = Kit.classOrNull("java.lang.String");
    public static final Class SerializableClass = Kit.classOrNull("java.io.Serializable");
    public static final Class DateClass = Kit.classOrNull("java.util.Date");
    public static final Class ContextClass = Kit.classOrNull("org.mozilla.javascript.Context");
    public static final Class FunctionClass = Kit.classOrNull("org.mozilla.javascript.Function");
    public static final Class ScriptableClass = Kit.classOrNull("org.mozilla.javascript.Scriptable");
    public static final Class ScriptableObjectClass = Kit.classOrNull("org.mozilla.javascript.ScriptableObject");
    public static final Class UndefinedClass = Kit.classOrNull("org.mozilla.javascript.Undefined");
    public static final double NaN = Double.longBitsToDouble(9221120237041090560L);
    public static final double negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);
    public static final Double NaNobj = new Double(NaN);
    private static final boolean MSJVM_BUG_WORKAROUNDS = true;
    public static final Object[] emptyArgs = new Object[0];
    public static final String[] emptyStrings = new String[0];

    protected ScriptRuntime() {
    }

    public static boolean toBoolean(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Scriptable) {
            if (Context.getContext().isVersionECMA1()) {
                return val != Undefined.instance;
            }
            if ((val = ((Scriptable)val).getDefaultValue(BooleanClass)) instanceof Scriptable) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val);
            }
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
        }
        if (val instanceof String) {
            return ((String)val).length() != 0;
        }
        if (val instanceof Number) {
            double d = ((Number)val).doubleValue();
            return d == d && d != 0.0;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", val);
    }

    public static boolean toBoolean(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toBoolean(args[index]) : false;
    }

    public static double toNumber(Object val) {
        if (val == null) {
            return 0.0;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof Scriptable) {
            if ((val = ((Scriptable)val).getDefaultValue(NumberClass)) != null && val instanceof Scriptable) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val);
            }
            if (val instanceof Number) {
                return ((Number)val).doubleValue();
            }
        }
        if (val instanceof String) {
            return ScriptRuntime.toNumber((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", val);
    }

    public static double toNumber(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toNumber(args[index]) : NaN;
    }

    static double stringToNumber(String s, int start, int radix) {
        int end;
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        int len = s.length();
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        for (end = start; end < len; ++end) {
            int newDigit;
            char c = s.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else {
                if ('A' > c || c >= upperCaseBound) break;
                newDigit = c - 65 + 10;
            }
            sum = sum * (double)radix + (double)newDigit;
        }
        if (start == end) {
            return NaN;
        }
        if (sum >= 9.007199254740992E15) {
            if (radix == 10) {
                try {
                    return Double.valueOf(s.substring(start, end));
                }
                catch (NumberFormatException nfe) {
                    return NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bitShiftInChar = 1;
                int digit = 0;
                boolean SKIP_LEADING_ZEROS = false;
                boolean FIRST_EXACT_53_BITS = true;
                int AFTER_BIT_53 = 2;
                int ZEROS_AFTER_54 = 3;
                int MIXED_AFTER_54 = 4;
                int state = 0;
                int exactBitsLimit = 53;
                double factor = 0.0;
                boolean bit53 = false;
                boolean bit54 = false;
                while (true) {
                    if (bitShiftInChar == 1) {
                        if (start == end) break;
                        digit = 48 <= (digit = (int)s.charAt(start++)) && digit <= 57 ? (digit -= 48) : (97 <= digit && digit <= 122 ? (digit -= 87) : (digit -= 55));
                        bitShiftInChar = radix;
                    }
                    boolean bit = (digit & (bitShiftInChar >>= 1)) != 0;
                    switch (state) {
                        case 0: {
                            if (!bit) break;
                            --exactBitsLimit;
                            sum = 1.0;
                            state = 1;
                            break;
                        }
                        case 1: {
                            sum *= 2.0;
                            if (bit) {
                                sum += 1.0;
                            }
                            if (--exactBitsLimit != 0) break;
                            bit53 = bit;
                            state = 2;
                            break;
                        }
                        case 2: {
                            bit54 = bit;
                            factor = 2.0;
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (bit) {
                                state = 4;
                            }
                        }
                        case 4: {
                            factor *= 2.0;
                        }
                    }
                }
                switch (state) {
                    case 0: {
                        sum = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bit54 & bit53) {
                            sum += 1.0;
                        }
                        sum *= factor;
                        break;
                    }
                    case 4: {
                        if (bit54) {
                            sum += 1.0;
                        }
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }

    public static double toNumber(String s) {
        char endChar;
        char c2;
        char startChar;
        int len = s.length();
        int start = 0;
        while (true) {
            if (start == len) {
                return 0.0;
            }
            startChar = s.charAt(start);
            if (!Character.isWhitespace(startChar)) break;
            ++start;
        }
        if (startChar == '0') {
            char c1;
            if (start + 2 < len && ((c1 = s.charAt(start + 1)) == 'x' || c1 == 'X')) {
                return ScriptRuntime.stringToNumber(s, start + 2, 16);
            }
        } else if (!(startChar != '+' && startChar != '-' || start + 3 >= len || s.charAt(start + 1) != '0' || (c2 = s.charAt(start + 2)) != 'x' && c2 != 'X')) {
            double val = ScriptRuntime.stringToNumber(s, start + 3, 16);
            return startChar == '-' ? -val : val;
        }
        int end = len - 1;
        while (Character.isWhitespace(endChar = s.charAt(end))) {
            --end;
        }
        if (endChar == 'y') {
            if (startChar == '+' || startChar == '-') {
                ++start;
            }
            if (start + 7 == end && s.regionMatches(start, "Infinity", 0, 8)) {
                return startChar == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return NaN;
        }
        String sub = s.substring(start, end + 1);
        for (int i = sub.length() - 1; i >= 0; --i) {
            char c = sub.charAt(i);
            if ('0' <= c && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '+' || c == '-') continue;
            return NaN;
        }
        try {
            return Double.valueOf(sub);
        }
        catch (NumberFormatException ex) {
            return NaN;
        }
    }

    public static Object[] padArguments(Object[] args, int count) {
        int i;
        if (count < args.length) {
            return args;
        }
        Object[] result = new Object[count];
        for (i = 0; i < args.length; ++i) {
            result[i] = args[i];
        }
        while (i < count) {
            result[i] = Undefined.instance;
            ++i;
        }
        return result;
    }

    public static String escapeString(String s) {
        return ScriptRuntime.escapeString(s, '\"');
    }

    public static String escapeString(String s, char escapeQuote) {
        if (escapeQuote != '\"' && escapeQuote != '\'') {
            Kit.codeBug();
        }
        StringBuffer sb = null;
        int L = s.length();
        for (int i = 0; i != L; ++i) {
            int hexSize;
            char c = s.charAt(i);
            if (' ' <= c && c <= '~' && c != escapeQuote && c != '\\') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer(L + 3);
                sb.append(s);
                sb.setLength(i);
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\u000b': {
                    escape = 118;
                    break;
                }
                case ' ': {
                    escape = 32;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                sb.append('\\');
                sb.append((char)escape);
                continue;
            }
            if (c == escapeQuote) {
                sb.append('\\');
                sb.append(escapeQuote);
                continue;
            }
            if (c < '\u0100') {
                sb.append("\\x");
                hexSize = 2;
            } else {
                sb.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                int hc = digit < 10 ? 48 + digit : 87 + digit;
                sb.append((char)hc);
            }
        }
        return sb == null ? s : sb.toString();
    }

    static boolean isValidIdentifierName(String s) {
        int L = s.length();
        if (L == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i != L; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object val) {
        block3: {
            do {
                if (val == null) {
                    return "null";
                }
                if (!(val instanceof Scriptable)) break block3;
            } while ((val = ((Scriptable)val).getDefaultValue(StringClass)) == Undefined.instance || !(val instanceof Scriptable));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val);
        }
        if (val instanceof Number) {
            return ScriptRuntime.numberToString(((Number)val).doubleValue(), 10);
        }
        return val.toString();
    }

    public static String toString(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toString(args[index]) : "undefined";
    }

    public static String toString(double val) {
        return ScriptRuntime.numberToString(val, 10);
    }

    public static String numberToString(double d, int base) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (base < 2 || base > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(base));
        }
        if (base != 10) {
            return DToA.JS_dtobasestr(base, d);
        }
        StringBuffer result = new StringBuffer();
        DToA.JS_dtostr(result, 0, 0, d);
        return result.toString();
    }

    static String uneval(Context cx, Scriptable scope, Object value) throws JavaScriptException {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            String escaped = ScriptRuntime.escapeString((String)value);
            StringBuffer sb = new StringBuffer(escaped.length() + 2);
            sb.append('\"');
            sb.append(escaped);
            sb.append('\"');
            return sb.toString();
        }
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d == 0.0 && 1.0 / d < 0.0) {
                return "-0";
            }
            return ScriptRuntime.toString(d);
        }
        if (value instanceof Boolean) {
            return ScriptRuntime.toString(value);
        }
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (value instanceof Scriptable) {
            Scriptable obj = (Scriptable)value;
            Object v = ScriptableObject.getProperty(obj, "toSource");
            if (v instanceof Function) {
                Function f = (Function)v;
                return ScriptRuntime.toString(f.call(cx, scope, obj, emptyArgs));
            }
            return ScriptRuntime.toString(value);
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", value);
    }

    public static Scriptable toObject(Scriptable scope, Object val) {
        if (val instanceof Scriptable && val != Undefined.instance) {
            return (Scriptable)val;
        }
        return ScriptRuntime.toObject(Context.getContext(), scope, val);
    }

    public static Scriptable toObject(Scriptable scope, Object val, Class staticClass) {
        return ScriptRuntime.toObject(scope, val);
    }

    public static Scriptable toObject(Context cx, Scriptable scope, Object val) {
        String className;
        if (val instanceof Scriptable) {
            if (val == Undefined.instance) {
                throw ScriptRuntime.typeError0("msg.undef.to.object");
            }
            return (Scriptable)val;
        }
        String string = val instanceof String ? "String" : (val instanceof Number ? "Number" : (className = val instanceof Boolean ? "Boolean" : null));
        if (className != null) {
            Object[] args = new Object[]{val};
            scope = ScriptableObject.getTopLevelScope(scope);
            return ScriptRuntime.newObject(cx, scope, className, args);
        }
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, val, null);
        if (wrapped instanceof Scriptable) {
            return (Scriptable)wrapped;
        }
        if (wrapped == null) {
            throw ScriptRuntime.typeError0("msg.null.to.object");
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", val);
    }

    public static Scriptable toObject(Context cx, Scriptable scope, Object val, Class staticClass) {
        return ScriptRuntime.toObject(cx, scope, val);
    }

    public static Scriptable newObject(Context cx, Scriptable scope, String constructorName, Object[] args) {
        scope = ScriptableObject.getTopLevelScope(scope);
        Function ctor = ScriptRuntime.getExistingCtor(cx, scope, constructorName);
        try {
            if (args == null) {
                args = emptyArgs;
            }
            return ctor.construct(cx, scope, args);
        }
        catch (JavaScriptException e) {
            throw Context.reportRuntimeError(e.getMessage());
        }
    }

    public static double toInteger(Object val) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(val));
    }

    public static double toInteger(double d) {
        if (d != d) {
            return 0.0;
        }
        if (d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toInteger(args[index]) : 0.0;
    }

    public static int toInt32(Object val) {
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return ScriptRuntime.toInt32(ScriptRuntime.toNumber(val));
    }

    public static int toInt32(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toInt32(args[index]) : 0;
    }

    public static int toInt32(double d) {
        int id = (int)d;
        if ((double)id == d) {
            return id;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double two32 = 4.294967296E9;
        d = Math.IEEEremainder(d, two32);
        long l = (long)d;
        return (int)l;
    }

    public static long toUint32(double d) {
        long l = (long)d;
        if ((double)l == d) {
            return l & 0xFFFFFFFFL;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0L;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double two32 = 4.294967296E9;
        l = (long)Math.IEEEremainder(d, two32);
        return l & 0xFFFFFFFFL;
    }

    public static long toUint32(Object val) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(val));
    }

    public static char toUint16(Object val) {
        double d = ScriptRuntime.toNumber(val);
        int i = (int)d;
        if ((double)i == d) {
            return (char)i;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return '\u0000';
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        int int16 = 65536;
        i = (int)Math.IEEEremainder(d, int16);
        return (char)i;
    }

    public static Object getCatchObject(Context cx, Scriptable scope, Throwable t) throws JavaScriptException {
        String errorName;
        String message;
        EvaluatorException evaluator = null;
        if (t instanceof EvaluatorException) {
            evaluator = (EvaluatorException)t;
            while (t instanceof WrappedException) {
                t = ((WrappedException)t).getWrappedException();
            }
        }
        if (t instanceof JavaScriptException) {
            return ((JavaScriptException)t).getValue();
        }
        if (t instanceof EcmaError) {
            EcmaError ee = (EcmaError)t;
            String errorName2 = ee.getName();
            return ScriptRuntime.makeErrorObject(cx, scope, errorName2, ee.getMessage(), ee.getSourceName(), ee.getLineNumber());
        }
        if (evaluator == null) {
            Kit.codeBug();
        }
        if (t != evaluator && t instanceof EvaluatorException) {
            evaluator = (EvaluatorException)t;
        }
        if (t == evaluator) {
            if (evaluator instanceof WrappedException) {
                Kit.codeBug();
            }
            message = evaluator.getMessage();
            errorName = "InternalError";
        } else {
            errorName = "JavaException";
            message = t.getClass().getName() + ": " + t.getMessage();
        }
        Scriptable errorObject = ScriptRuntime.makeErrorObject(cx, scope, errorName, message, evaluator.getSourceName(), evaluator.getLineNumber());
        if (t != evaluator) {
            Object twrap = cx.getWrapFactory().wrap(cx, scope, t, null);
            ScriptableObject.putProperty(errorObject, "javaException", twrap);
        }
        return errorObject;
    }

    private static Scriptable makeErrorObject(Context cx, Scriptable scope, String errorName, String message, String fileName, int lineNumber) throws JavaScriptException {
        int argLength = lineNumber > 0 ? 3 : 2;
        Object[] args = new Object[argLength];
        args[0] = message;
        Object object = args[1] = fileName != null ? fileName : "";
        if (lineNumber > 0) {
            args[2] = new Integer(lineNumber);
        }
        Scriptable errorObject = cx.newObject(scope, errorName, args);
        ScriptableObject.putProperty(errorObject, "name", (Object)errorName);
        return errorObject;
    }

    public static Object getProp(Object obj, String id, Scriptable scope) {
        if (obj == null || obj == Undefined.instance) {
            throw ScriptRuntime.undefReadError(obj, id);
        }
        Scriptable start = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        Object result = ScriptableObject.getProperty(start, id);
        if (result != Scriptable.NOT_FOUND) {
            return result;
        }
        return Undefined.instance;
    }

    public static Object getTopLevelProp(Scriptable scope, String id) {
        scope = ScriptableObject.getTopLevelScope(scope);
        return ScriptableObject.getProperty(scope, id);
    }

    static Function getExistingCtor(Context cx, Scriptable scope, String constructorName) {
        Object ctorVal = ScriptableObject.getProperty(scope, constructorName);
        if (ctorVal instanceof Function) {
            return (Function)ctorVal;
        }
        if (ctorVal == Scriptable.NOT_FOUND) {
            throw Context.reportRuntimeError1("msg.ctor.not.found", constructorName);
        }
        throw Context.reportRuntimeError1("msg.not.ctor", constructorName);
    }

    public static Scriptable getProto(Object obj, Scriptable scope) {
        Scriptable s = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        if (s == null) {
            throw ScriptRuntime.typeError0("msg.null.to.object");
        }
        return s.getPrototype();
    }

    public static Scriptable getParent(Object obj) {
        if (!(obj instanceof Scriptable)) {
            return null;
        }
        Scriptable s = (Scriptable)obj;
        return ScriptRuntime.getThis(s.getParentScope());
    }

    public static Scriptable getParent(Object obj, Scriptable scope) {
        Scriptable s = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        if (s == null) {
            throw ScriptRuntime.typeError0("msg.null.to.object");
        }
        return s.getParentScope();
    }

    public static Object setProto(Object obj, Object value, Scriptable scope) {
        Scriptable result;
        Scriptable start = ScriptRuntime.toObject(scope, obj);
        for (Scriptable s = result = value == null ? null : ScriptRuntime.toObject(scope, value); s != null; s = s.getPrototype()) {
            if (s != start) continue;
            throw Context.reportRuntimeError1("msg.cyclic.value", "__proto__");
        }
        start.setPrototype(result);
        return result;
    }

    public static Object setParent(Object obj, Object value, Scriptable scope) {
        Scriptable result;
        Scriptable start = ScriptRuntime.toObject(scope, obj);
        for (Scriptable s = result = value == null ? null : ScriptRuntime.toObject(scope, value); s != null; s = s.getParentScope()) {
            if (s != start) continue;
            throw Context.reportRuntimeError1("msg.cyclic.value", "__parent__");
        }
        start.setParentScope(result);
        return result;
    }

    public static Object setProp(Object obj, String id, Object value, Scriptable scope) {
        if (obj == null || obj == Undefined.instance) {
            throw ScriptRuntime.undefWriteError(obj, id, value);
        }
        Scriptable start = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        ScriptableObject.putProperty(start, id, value);
        return value;
    }

    private static long indexFromString(String str) {
        int MAX_VALUE_LENGTH = 10;
        int len = str.length();
        if (len > 0) {
            int i = 0;
            boolean negate = false;
            int c = str.charAt(0);
            if (c == 45 && len > 1) {
                c = str.charAt(1);
                i = 1;
                negate = true;
            }
            if (0 <= (c -= 48) && c <= 9 && len <= (negate ? 11 : 10)) {
                int index = -c;
                int oldIndex = 0;
                ++i;
                if (index != 0) {
                    while (i != len && 0 <= (c = str.charAt(i) - 48) && c <= 9) {
                        oldIndex = index;
                        index = 10 * index - c;
                        ++i;
                    }
                }
                if (i == len && (oldIndex > -214748364 || oldIndex == -214748364 && c <= (negate ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(negate ? index : -index);
                }
            }
        }
        return -1L;
    }

    static String getStringId(Object id) {
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            int index = (int)d;
            if ((double)index == d) {
                return null;
            }
            return ScriptRuntime.toString(id);
        }
        String s = ScriptRuntime.toString(id);
        long indexTest = ScriptRuntime.indexFromString(s);
        if (indexTest >= 0L) {
            return null;
        }
        return s;
    }

    static int getIntId(Object id) {
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            int index = (int)d;
            if ((double)index == d) {
                return index;
            }
            return 0;
        }
        String s = ScriptRuntime.toString(id);
        long indexTest = ScriptRuntime.indexFromString(s);
        if (indexTest >= 0L) {
            return (int)indexTest;
        }
        return 0;
    }

    public static Object getElem(Object obj, Object id, Scriptable scope) {
        String s;
        int index;
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            index = (int)d;
            s = (double)index == d ? null : ScriptRuntime.toString(id);
        } else {
            s = id instanceof String ? (String)id : ScriptRuntime.toString(id);
            long indexTest = ScriptRuntime.indexFromString(s);
            if (indexTest >= 0L) {
                index = (int)indexTest;
                s = null;
            } else {
                index = 0;
            }
        }
        if (obj == null || obj == Undefined.instance) {
            String property = s != null ? s : Integer.toString(index);
            throw ScriptRuntime.undefReadError(obj, property);
        }
        Scriptable start = ScriptRuntime.toObject(scope, obj);
        if (s != null) {
            return ScriptRuntime.getStrIdElem(start, s);
        }
        return ScriptRuntime.getElem(start, index);
    }

    public static Object getElem(Scriptable obj, int index) {
        Object result = ScriptableObject.getProperty(obj, index);
        if (result != Scriptable.NOT_FOUND) {
            return result;
        }
        return Undefined.instance;
    }

    static Object getStrIdElem(Scriptable obj, String id) {
        Object result;
        int l = id.length();
        if (l == 9) {
            if (id.equals("__proto__")) {
                return obj.getPrototype();
            }
        } else if (l == 10 && id.equals("__parent__")) {
            return obj.getParentScope();
        }
        if ((result = ScriptableObject.getProperty(obj, id)) != Scriptable.NOT_FOUND) {
            return result;
        }
        return Undefined.instance;
    }

    public static Object setElem(Object obj, Object id, Object value, Scriptable scope) {
        String s;
        int index;
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            index = (int)d;
            s = (double)index == d ? null : ScriptRuntime.toString(id);
        } else {
            s = id instanceof String ? (String)id : ScriptRuntime.toString(id);
            long indexTest = ScriptRuntime.indexFromString(s);
            if (indexTest >= 0L) {
                index = (int)indexTest;
                s = null;
            } else {
                index = 0;
            }
        }
        if (obj == null || obj == Undefined.instance) {
            String property = s != null ? s : Integer.toString(index);
            throw ScriptRuntime.undefWriteError(obj, property, value);
        }
        Scriptable start = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        if (s != null) {
            return ScriptRuntime.setStrIdElem(start, s, value, scope);
        }
        return ScriptRuntime.setElem(start, index, value);
    }

    public static Object setElem(Scriptable obj, int index, Object value) {
        ScriptableObject.putProperty(obj, index, value);
        return value;
    }

    static Object setStrIdElem(Scriptable obj, String id, Object value, Scriptable scope) {
        int l = id.length();
        if (l == 9) {
            if (id.equals("__proto__")) {
                return ScriptRuntime.setProto(obj, value, scope);
            }
        } else if (l == 10 && id.equals("__parent__")) {
            return ScriptRuntime.setParent(obj, value, scope);
        }
        ScriptableObject.putProperty(obj, id, value);
        return value;
    }

    public static Object delete(Context cx, Scriptable scope, Object obj, Object id) {
        Scriptable sobj = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(cx, scope, obj);
        String s = ScriptRuntime.getStringId(id);
        boolean result = s != null ? ScriptableObject.deleteProperty(sobj, s) : ScriptableObject.deleteProperty(sobj, ScriptRuntime.getIntId(id));
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object name(Scriptable scopeChain, String id) {
        for (Scriptable obj = scopeChain; obj != null; obj = obj.getParentScope()) {
            Object result = ScriptableObject.getProperty(obj, id);
            if (result == Scriptable.NOT_FOUND) continue;
            return result;
        }
        String msg = ScriptRuntime.getMessage1("msg.is.not.defined", id.toString());
        throw ScriptRuntime.constructError("ReferenceError", msg);
    }

    public static Scriptable bind(Scriptable scope, String id) {
        while (!ScriptableObject.hasProperty(scope, id) && (scope = scope.getParentScope()) != null) {
        }
        return scope;
    }

    public static Scriptable getBase(Scriptable scope, String id) {
        Scriptable base = ScriptRuntime.bind(scope, id);
        if (base != null) {
            return base;
        }
        String msg = ScriptRuntime.getMessage1("msg.is.not.defined", id);
        throw ScriptRuntime.constructError("ReferenceError", msg);
    }

    public static Scriptable getThis(Scriptable base) {
        while (base instanceof NativeWith) {
            base = base.getPrototype();
        }
        if (base instanceof NativeCall) {
            base = ScriptableObject.getTopLevelScope(base);
        }
        return base;
    }

    public static Object setName(Scriptable bound, Object value, Scriptable scope, String id) {
        if (bound != null) {
            ScriptableObject.putProperty(bound, id, value);
        } else {
            bound = ScriptableObject.getTopLevelScope(scope);
            bound.put(id, bound, value);
        }
        return value;
    }

    public static Object enumInit(Object value, Scriptable scope) {
        IdEnumeration x = new IdEnumeration();
        if (value != null && value != Undefined.instance) {
            x.obj = ScriptRuntime.toObject(scope, value);
            ScriptRuntime.enumChangeObject(x);
        }
        return x;
    }

    public static Boolean enumNext(Object enumObj) {
        block4: {
            int intId;
            IdEnumeration x = (IdEnumeration)enumObj;
            while (true) {
                if (x.obj == null) {
                    return Boolean.FALSE;
                }
                if (x.index == x.ids.length) {
                    x.obj = x.obj.getPrototype();
                    ScriptRuntime.enumChangeObject(x);
                    continue;
                }
                Object id = x.ids[x.index++];
                if (x.used != null && x.used.has(id)) continue;
                if (id instanceof String) {
                    String strId = (String)id;
                    if (!x.obj.has(strId, x.obj)) continue;
                    x.currentId = strId;
                    break block4;
                }
                intId = ((Number)id).intValue();
                if (x.obj.has(intId, x.obj)) break;
            }
            x.currentId = String.valueOf(intId);
        }
        return Boolean.TRUE;
    }

    public static String enumId(Object enumObj) {
        return ((IdEnumeration)enumObj).currentId;
    }

    private static void enumChangeObject(IdEnumeration x) {
        Object[] ids = null;
        while (x.obj != null && (ids = x.obj.getIds()).length == 0) {
            x.obj = x.obj.getPrototype();
        }
        if (x.obj != null && x.ids != null) {
            Object[] previous = x.ids;
            int L = previous.length;
            if (x.used == null) {
                x.used = new ObjToIntMap(L);
            }
            for (int i = 0; i != L; ++i) {
                x.used.intern(previous[i]);
            }
        }
        x.ids = ids;
        x.index = 0;
    }

    public static Object call(Context cx, Object fun, Object thisArg, Object[] args) throws JavaScriptException {
        Scriptable scope = null;
        if (fun instanceof Scriptable) {
            scope = ((Scriptable)fun).getParentScope();
        }
        return ScriptRuntime.call(cx, fun, thisArg, args, scope);
    }

    public static Object call(Context cx, Object fun, Object thisArg, Object[] args, Scriptable scope) throws JavaScriptException {
        if (!(fun instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(fun));
        }
        Function function = (Function)fun;
        Scriptable thisObj = thisArg instanceof Scriptable || thisArg == null ? (Scriptable)thisArg : ScriptRuntime.toObject(cx, scope, thisArg);
        return function.call(cx, scope, thisObj, args);
    }

    public static Scriptable newObject(Context cx, Object fun, Object[] args, Scriptable scope) throws JavaScriptException {
        if (!(fun instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(fun));
        }
        Function function = (Function)fun;
        return function.construct(cx, scope, args);
    }

    public static Object callSpecial(Context cx, Object fun, boolean isNew, Object thisObj, Object[] args, Scriptable scope, Scriptable callerThis, int callType, String filename, int lineNumber) throws JavaScriptException {
        if (callType == 1) {
            if (NativeGlobal.isEvalFunction(fun)) {
                if (isNew) {
                    throw ScriptRuntime.typeError1("msg.not.ctor", "eval");
                }
                return ScriptRuntime.evalSpecial(cx, scope, callerThis, args, filename, lineNumber);
            }
        } else if (callType == 2) {
            if (NativeWith.isWithFunction(fun)) {
                if (!isNew) {
                    throw Context.reportRuntimeError1("msg.only.from.new", "With");
                }
                return NativeWith.newWithSpecial(cx, scope, args);
            }
        } else {
            Kit.codeBug();
        }
        if (isNew) {
            return ScriptRuntime.newObject(cx, fun, args, scope);
        }
        return ScriptRuntime.call(cx, fun, thisObj, args, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evalSpecial(Context cx, Scriptable scope, Object thisArg, Object[] args, String filename, int lineNumber) throws JavaScriptException {
        Script script;
        if (args.length < 1) {
            return Undefined.instance;
        }
        Object x = args[0];
        if (!(x instanceof String)) {
            String message = Context.getMessage0("msg.eval.nonstring");
            Context.reportWarning(message);
            return x;
        }
        if (filename == null) {
            int[] linep = new int[1];
            filename = Context.getSourcePositionFromStack(linep);
            if (filename != null) {
                lineNumber = linep[0];
            } else {
                filename = "";
            }
        }
        String sourceName = ScriptRuntime.makeUrlForGeneratedScript(true, filename, lineNumber);
        int savedLevel = cx.optimizationLevel;
        cx.optimizationLevel = -1;
        try {
            script = cx.compileString((String)x, true, sourceName, 1, null);
        }
        finally {
            cx.optimizationLevel = savedLevel;
        }
        if (script == null) {
            String message = Context.getMessage0("msg.syntax");
            throw new EvaluatorException(message, filename, lineNumber, null, 0);
        }
        Callable c = (Callable)((Object)script);
        return c.call(cx, scope, (Scriptable)thisArg, emptyArgs);
    }

    public static String typeof(Object value) {
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (value == null) {
            return "object";
        }
        if (value instanceof Scriptable) {
            return value instanceof Function ? "function" : "object";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", value);
    }

    public static String typeofName(Scriptable scope, String id) {
        Scriptable val = ScriptRuntime.bind(scope, id);
        if (val == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getProp(val, id, scope));
    }

    public static Object add(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            return new Double(((Number)val1).doubleValue() + ((Number)val2).doubleValue());
        }
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(null);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(null);
        }
        if (!(val1 instanceof String) && !(val2 instanceof String)) {
            if (val1 instanceof Number && val2 instanceof Number) {
                return new Double(((Number)val1).doubleValue() + ((Number)val2).doubleValue());
            }
            return new Double(ScriptRuntime.toNumber(val1) + ScriptRuntime.toNumber(val2));
        }
        return ScriptRuntime.toString(val1).concat(ScriptRuntime.toString(val2));
    }

    public static Object postIncrement(Object value) {
        value = value instanceof Number ? new Double(((Number)value).doubleValue() + 1.0) : new Double(ScriptRuntime.toNumber(value) + 1.0);
        return value;
    }

    public static Object postIncrement(Scriptable scopeChain, String id) {
        for (Scriptable obj = scopeChain; obj != null; obj = obj.getParentScope()) {
            Scriptable m = obj;
            do {
                Object result;
                if ((result = m.get(id, obj)) == Scriptable.NOT_FOUND) continue;
                Object newValue = result;
                if (newValue instanceof Number) {
                    newValue = new Double(((Number)newValue).doubleValue() + 1.0);
                    m.put(id, obj, newValue);
                    return result;
                }
                newValue = new Double(ScriptRuntime.toNumber(newValue) + 1.0);
                m.put(id, obj, newValue);
                return new Double(ScriptRuntime.toNumber(result));
            } while ((m = m.getPrototype()) != null);
        }
        String msg = ScriptRuntime.getMessage1("msg.is.not.defined", id);
        throw ScriptRuntime.constructError("ReferenceError", msg);
    }

    public static Object postIncrement(Object obj, String id, Scriptable scope) {
        Scriptable start;
        Scriptable m = start = ScriptRuntime.toObject(scope, obj);
        do {
            Object result;
            if ((result = m.get(id, start)) == Scriptable.NOT_FOUND) continue;
            Object newValue = result;
            if (newValue instanceof Number) {
                newValue = new Double(((Number)newValue).doubleValue() + 1.0);
                m.put(id, start, newValue);
                return result;
            }
            newValue = new Double(ScriptRuntime.toNumber(newValue) + 1.0);
            m.put(id, start, newValue);
            return new Double(ScriptRuntime.toNumber(result));
        } while ((m = m.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postIncrementElem(Object obj, Object index, Scriptable scope) {
        Object oldValue = ScriptRuntime.getElem(obj, index, scope);
        if (oldValue == Undefined.instance) {
            return Undefined.instance;
        }
        double resultValue = ScriptRuntime.toNumber(oldValue);
        Double newValue = new Double(resultValue + 1.0);
        ScriptRuntime.setElem(obj, index, newValue, scope);
        return new Double(resultValue);
    }

    public static Object postDecrementElem(Object obj, Object index, Scriptable scope) {
        Object oldValue = ScriptRuntime.getElem(obj, index, scope);
        if (oldValue == Undefined.instance) {
            return Undefined.instance;
        }
        double resultValue = ScriptRuntime.toNumber(oldValue);
        Double newValue = new Double(resultValue - 1.0);
        ScriptRuntime.setElem(obj, index, newValue, scope);
        return new Double(resultValue);
    }

    public static Object postDecrement(Object value) {
        value = value instanceof Number ? new Double(((Number)value).doubleValue() - 1.0) : new Double(ScriptRuntime.toNumber(value) - 1.0);
        return value;
    }

    public static Object postDecrement(Scriptable scopeChain, String id) {
        for (Scriptable obj = scopeChain; obj != null; obj = obj.getParentScope()) {
            Scriptable m = obj;
            do {
                Object result;
                if ((result = m.get(id, obj)) == Scriptable.NOT_FOUND) continue;
                Object newValue = result;
                if (newValue instanceof Number) {
                    newValue = new Double(((Number)newValue).doubleValue() - 1.0);
                    m.put(id, obj, newValue);
                    return result;
                }
                newValue = new Double(ScriptRuntime.toNumber(newValue) - 1.0);
                m.put(id, obj, newValue);
                return new Double(ScriptRuntime.toNumber(result));
            } while ((m = m.getPrototype()) != null);
        }
        String msg = ScriptRuntime.getMessage1("msg.is.not.defined", id);
        throw ScriptRuntime.constructError("ReferenceError", msg);
    }

    public static Object postDecrement(Object obj, String id, Scriptable scope) {
        Scriptable start;
        Scriptable m = start = ScriptRuntime.toObject(scope, obj);
        do {
            Object result;
            if ((result = m.get(id, start)) == Scriptable.NOT_FOUND) continue;
            Object newValue = result;
            if (newValue instanceof Number) {
                newValue = new Double(((Number)newValue).doubleValue() - 1.0);
                m.put(id, start, newValue);
                return result;
            }
            newValue = new Double(ScriptRuntime.toNumber(newValue) - 1.0);
            m.put(id, start, newValue);
            return new Double(ScriptRuntime.toNumber(result));
        } while ((m = m.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object toPrimitive(Object val) {
        if (val == null || !(val instanceof Scriptable)) {
            return val;
        }
        Scriptable s = (Scriptable)val;
        Object result = s.getDefaultValue(null);
        if (result != null && result instanceof Scriptable) {
            throw ScriptRuntime.typeError0("msg.bad.default.value");
        }
        return result;
    }

    private static Class getTypeOfValue(Object obj) {
        if (obj == null) {
            return ScriptableClass;
        }
        if (obj == Undefined.instance) {
            return UndefinedClass;
        }
        if (obj instanceof Number) {
            return NumberClass;
        }
        if (obj instanceof Scriptable) {
            return ScriptableClass;
        }
        return obj.getClass();
    }

    public static boolean eq(Object x, Object y) {
        Object xCopy = x;
        Object yCopy = y;
        while (true) {
            Class typeY;
            Class typeX;
            if ((typeX = ScriptRuntime.getTypeOfValue(x)) == (typeY = ScriptRuntime.getTypeOfValue(y))) {
                if (typeX == UndefinedClass) {
                    return true;
                }
                if (typeX == NumberClass) {
                    return ((Number)x).doubleValue() == ((Number)y).doubleValue();
                }
                if (typeX == StringClass || typeX == BooleanClass) {
                    return xCopy.equals(yCopy);
                }
                if (typeX == ScriptableClass) {
                    if (x == y) {
                        return true;
                    }
                    if (x instanceof Wrapper && y instanceof Wrapper) {
                        return ((Wrapper)x).unwrap() == ((Wrapper)y).unwrap();
                    }
                    return false;
                }
                throw new RuntimeException();
            }
            if (x == null && y == Undefined.instance) {
                return true;
            }
            if (x == Undefined.instance && y == null) {
                return true;
            }
            if (typeX == NumberClass && typeY == StringClass) {
                return ((Number)x).doubleValue() == ScriptRuntime.toNumber(y);
            }
            if (typeX == StringClass && typeY == NumberClass) {
                return ScriptRuntime.toNumber(x) == ((Number)y).doubleValue();
            }
            if (typeX == BooleanClass) {
                xCopy = x = new Double(ScriptRuntime.toNumber(x));
                continue;
            }
            if (typeY == BooleanClass) {
                yCopy = y = new Double(ScriptRuntime.toNumber(y));
                continue;
            }
            if ((typeX == StringClass || typeX == NumberClass) && typeY == ScriptableClass && y != null) {
                yCopy = y = ScriptRuntime.toPrimitive(y);
                continue;
            }
            if (typeX != ScriptableClass || x == null || typeY != StringClass && typeY != NumberClass) break;
            xCopy = x = ScriptRuntime.toPrimitive(x);
        }
        return false;
    }

    public static Boolean eqB(Object x, Object y) {
        if (ScriptRuntime.eq(x, y)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean neB(Object x, Object y) {
        if (ScriptRuntime.eq(x, y)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean shallowEq(Object x, Object y) {
        Class type = ScriptRuntime.getTypeOfValue(x);
        if (type != ScriptRuntime.getTypeOfValue(y)) {
            return false;
        }
        if (type == StringClass || type == BooleanClass) {
            return x.equals(y);
        }
        if (type == NumberClass) {
            return ((Number)x).doubleValue() == ((Number)y).doubleValue();
        }
        if (type == ScriptableClass) {
            if (x == y) {
                return true;
            }
            if (x instanceof Wrapper && y instanceof Wrapper) {
                return ((Wrapper)x).unwrap() == ((Wrapper)y).unwrap();
            }
            return false;
        }
        return type == UndefinedClass;
    }

    public static Boolean seqB(Object x, Object y) {
        if (ScriptRuntime.shallowEq(x, y)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean sneB(Object x, Object y) {
        if (ScriptRuntime.shallowEq(x, y)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean instanceOf(Object a, Object b, Scriptable scope) {
        if (!(b instanceof Scriptable)) {
            throw ScriptRuntime.typeError0("msg.instanceof.not.object");
        }
        if (!(a instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)b).hasInstance((Scriptable)a);
    }

    protected static boolean jsDelegatesTo(Scriptable lhs, Scriptable rhs) {
        for (Scriptable proto = lhs.getPrototype(); proto != null; proto = proto.getPrototype()) {
            if (!proto.equals(rhs)) continue;
            return true;
        }
        return false;
    }

    public static boolean in(Object a, Object b, Scriptable scope) {
        if (!(b instanceof Scriptable)) {
            throw ScriptRuntime.typeError0("msg.instanceof.not.object");
        }
        String s = ScriptRuntime.getStringId(a);
        return s != null ? ScriptableObject.hasProperty((Scriptable)b, s) : ScriptableObject.hasProperty((Scriptable)b, ScriptRuntime.getIntId(a));
    }

    public static Boolean cmp_LTB(Object val1, Object val2) {
        if (ScriptRuntime.cmp_LT(val1, val2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            double d1 = ((Number)val1).doubleValue();
            double d2 = ((Number)val2).doubleValue();
            if (d1 != d1) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d1 < d2 ? 1 : 0;
        }
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(NumberClass);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(NumberClass);
        }
        if (!(val1 instanceof String) || !(val2 instanceof String)) {
            double d1 = ScriptRuntime.toNumber(val1);
            if (d1 != d1) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(val2);
            if (d2 != d2) {
                return 0;
            }
            return d1 < d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(val1).compareTo(ScriptRuntime.toString(val2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object val1, Object val2) {
        if (ScriptRuntime.cmp_LE(val1, val2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            double d1 = ((Number)val1).doubleValue();
            double d2 = ((Number)val2).doubleValue();
            if (d1 != d1) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d1 <= d2 ? 1 : 0;
        }
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(NumberClass);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(NumberClass);
        }
        if (!(val1 instanceof String) || !(val2 instanceof String)) {
            double d1 = ScriptRuntime.toNumber(val1);
            if (d1 != d1) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(val2);
            if (d2 != d2) {
                return 0;
            }
            return d1 <= d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(val1).compareTo(ScriptRuntime.toString(val2)) <= 0 ? 1 : 0;
    }

    private static ScriptableObject getGlobal(Context cx) {
        String GLOBAL_CLASS = "org.mozilla.javascript.tools.shell.Global";
        Class globalClass = Kit.classOrNull("org.mozilla.javascript.tools.shell.Global");
        if (globalClass != null) {
            try {
                Class[] parm = new Class[]{ContextClass};
                Constructor globalClassCtor = globalClass.getConstructor(parm);
                Object[] arg = new Object[]{cx};
                return (ScriptableObject)globalClassCtor.newInstance(arg);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return new ImporterTopLevel(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(Script script, String[] args) throws JavaScriptException {
        Context cx = Context.enter();
        try {
            ScriptableObject global = ScriptRuntime.getGlobal(cx);
            Object[] argsCopy = new Object[args.length];
            System.arraycopy(args, 0, argsCopy, 0, args.length);
            Scriptable argsObj = cx.newArray((Scriptable)global, argsCopy);
            global.defineProperty("arguments", argsObj, 2);
            script.exec(cx, global);
        }
        finally {
            Context.exit();
        }
    }

    public static void initScript(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, boolean fromEvalCode) {
        String[] argNames = funObj.argNames;
        if (argNames != null) {
            Scriptable varScope = scope;
            if (fromEvalCode) {
                varScope = scope;
                while (varScope instanceof NativeWith) {
                    varScope = varScope.getParentScope();
                }
            }
            int i = argNames.length;
            while (i-- != 0) {
                String name = argNames[i];
                if (ScriptRuntime.hasProp(scope, name)) continue;
                if (!fromEvalCode) {
                    ScriptableObject.defineProperty(scope, name, Undefined.instance, 4);
                    continue;
                }
                varScope.put(name, varScope, (Object)Undefined.instance);
            }
        }
    }

    public static Scriptable runScript(Script script) {
        Context cx = Context.enter();
        ScriptableObject global = ScriptRuntime.getGlobal(cx);
        try {
            script.exec(cx, global);
        }
        catch (JavaScriptException e) {
            throw new Error(e.toString());
        }
        finally {
            Context.exit();
        }
        return global;
    }

    public static Scriptable initVarObj(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, Object[] args) {
        return new NativeCall(cx, scope, funObj, thisObj, args);
    }

    public static void popActivation(Context cx) {
        NativeCall current = cx.currentActivation;
        if (current != null) {
            cx.currentActivation = current.caller;
            current.caller = null;
        }
    }

    public static Scriptable newCatchScope(String exceptionName, Object exceptionObject) {
        NativeObject scope = new NativeObject();
        ScriptableObject.putProperty((Scriptable)scope, exceptionName, exceptionObject);
        return scope;
    }

    public static Scriptable enterWith(Object value, Scriptable scope) {
        return new NativeWith(scope, ScriptRuntime.toObject(scope, value));
    }

    public static Scriptable leaveWith(Scriptable scope) {
        return scope.getParentScope();
    }

    public static void setFunctionProtoAndParent(Scriptable scope, Function fn) {
        fn.setPrototype(ScriptableObject.getFunctionPrototype(scope));
        fn.setParentScope(scope);
    }

    public static void initFunction(Context cx, Scriptable scope, NativeFunction function, int type, boolean fromEvalCode) {
        String name;
        ScriptRuntime.setFunctionProtoAndParent(scope, function);
        if (type == 1) {
            String name2 = function.functionName;
            if (name2 != null && name2.length() != 0) {
                if (!fromEvalCode) {
                    ScriptableObject.defineProperty(scope, name2, function, 4);
                } else {
                    scope.put(name2, scope, (Object)function);
                }
            }
        } else if (type == 3 && (name = function.functionName) != null && name.length() != 0) {
            while (scope instanceof NativeWith) {
                scope = scope.getParentScope();
            }
            scope.put(name, scope, (Object)function);
        }
    }

    static void checkDeprecated(Context cx, String name) {
        int version = cx.getLanguageVersion();
        if (version >= 140 || version == 0) {
            String msg = ScriptRuntime.getMessage1("msg.deprec.ctor", name);
            if (version == 0) {
                Context.reportWarning(msg);
            } else {
                throw Context.reportRuntimeError(msg);
            }
        }
    }

    public static String getMessage0(String messageId) {
        return Context.getMessage0(messageId);
    }

    public static String getMessage1(String messageId, Object arg1) {
        return Context.getMessage1(messageId, arg1);
    }

    public static String getMessage2(String messageId, Object arg1, Object arg2) {
        return Context.getMessage2(messageId, arg1, arg2);
    }

    public static String getMessage(String messageId, Object[] arguments) {
        return Context.getMessage(messageId, arguments);
    }

    public static EcmaError constructError(String error, String message) {
        int line = 0;
        String filename = null;
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            int[] linep = new int[1];
            filename = Context.getSourcePositionFromStack(linep);
            line = linep[0];
        }
        return ScriptRuntime.constructError(error, message, filename, line, null, 0);
    }

    public static EcmaError constructError(String error, String message, String sourceName, int lineNumber, String lineSource, int columnNumber) {
        return new EcmaError(error, message, sourceName, lineNumber, lineSource, columnNumber);
    }

    public static EcmaError typeError0(String messageId) {
        String msg = ScriptRuntime.getMessage0(messageId);
        return ScriptRuntime.constructError("TypeError", msg);
    }

    static EcmaError typeError1(String messageId, String arg1) {
        String msg = ScriptRuntime.getMessage1(messageId, arg1);
        return ScriptRuntime.constructError("TypeError", msg);
    }

    static EcmaError typeError2(String messageId, String arg1, String arg2) {
        String msg = ScriptRuntime.getMessage2(messageId, arg1, arg2);
        return ScriptRuntime.constructError("TypeError", msg);
    }

    static RuntimeException undefReadError(Object object, String property) {
        String messageId = object == null ? "msg.null.prop.read" : "msg.undef.prop.read";
        return ScriptRuntime.typeError1(messageId, property);
    }

    static RuntimeException undefWriteError(Object object, String property, Object value) {
        String messageId = object == null ? "msg.null.prop.write" : "msg.undef.prop.write";
        String valueStr = value instanceof Scriptable ? value.toString() : ScriptRuntime.toString(value);
        String msg = ScriptRuntime.getMessage2(messageId, property, valueStr);
        return ScriptRuntime.typeError2(messageId, valueStr, msg);
    }

    public static RegExpProxy getRegExpProxy(Context cx) {
        return cx.getRegExpProxy();
    }

    public static RegExpProxy checkRegExpProxy(Context cx) {
        RegExpProxy result = ScriptRuntime.getRegExpProxy(cx);
        if (result == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        return result;
    }

    public static NativeCall getCurrentActivation(Context cx) {
        return cx.currentActivation;
    }

    public static void setCurrentActivation(Context cx, NativeCall activation) {
        cx.currentActivation = activation;
    }

    static boolean hasProp(Scriptable start, String name) {
        Scriptable m = start;
        do {
            if (!m.has(name, start)) continue;
            return true;
        } while ((m = m.getPrototype()) != null);
        return false;
    }

    static String makeUrlForGeneratedScript(boolean isEval, String masterScriptUrl, int masterScriptLine) {
        if (isEval) {
            return masterScriptUrl + '#' + masterScriptLine + "(eval)";
        }
        return masterScriptUrl + '#' + masterScriptLine + "(Function)";
    }

    static boolean isGeneratedScript(String sourceUrl) {
        return sourceUrl.indexOf("(eval)") >= 0 || sourceUrl.indexOf("(Function)") >= 0;
    }

    private static RuntimeException errorWithClassName(String msg, Object val) {
        return Context.reportRuntimeError1(msg, val.getClass().getName());
    }

    private static class IdEnumeration {
        Scriptable obj;
        Object[] ids;
        int index;
        ObjToIntMap used;
        String currentId;

        private IdEnumeration() {
        }
    }
}

