/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIPSocket(runtime, klass);
        }
    };

    static void createIPSocket(Ruby runtime) {
        RubyClass rb_cIPSocket = runtime.defineClass("IPSocket", runtime.fastGetClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        rb_cIPSocket.defineAnnotatedMethods(RubyIPSocket.class);
        runtime.getObject().fastSetConstant("IPsocket", rb_cIPSocket);
    }

    public RubyIPSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    protected static RuntimeException sockerr(IRubyObject recv, String msg) {
        return new RaiseException(recv.getRuntime(), recv.getRuntime().fastGetClass("SocketError"), msg, true);
    }

    private IRubyObject addrFor(InetSocketAddress addr) {
        IRubyObject[] ret = new IRubyObject[4];
        Ruby r = this.getRuntime();
        ret[0] = r.newString("AF_INET");
        ret[1] = r.newFixnum(addr.getPort());
        ret[2] = r.isDoNotReverseLookupEnabled() ? r.newString(addr.getAddress().getHostAddress()) : r.newString(addr.getHostName());
        ret[3] = r.newString(addr.getAddress().getHostAddress());
        return r.newArrayNoCopy(ret);
    }

    @JRubyMethod
    public IRubyObject addr() {
        InetSocketAddress address = this.getLocalSocket();
        if (address == null) {
            throw this.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(address);
    }

    @JRubyMethod
    public IRubyObject peeraddr() {
        InetSocketAddress address = this.getRemoteSocket();
        if (address == null) {
            throw this.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(address);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(IRubyObject recv, IRubyObject hostname) {
        try {
            return recv.getRuntime().newString(InetAddress.getByName(hostname.convertToString().toString()).getHostAddress());
        }
        catch (UnknownHostException e) {
            throw RubyIPSocket.sockerr(recv, "getaddress: name or service not known");
        }
    }
}

