/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sun.security.provider.certpath.CertId;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPResponse {
    public static final int CERT_STATUS_GOOD = 0;
    public static final int CERT_STATUS_REVOKED = 1;
    public static final int CERT_STATUS_UNKNOWN = 2;
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID;
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID;
    private static final int OCSP_RESPONSE_OK = 0;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private SingleResponse singleResponse;
    private static final long MAX_CLOCK_SKEW = 600000L;
    private static CRLReason[] values;

    OCSPResponse(byte[] byArray, PKIXParameters pKIXParameters, X509Certificate object) throws IOException, CertPathValidatorException {
        block44: {
            try {
                Extension extension;
                Object object2;
                Object[] objectArray;
                Object[] objectArray2;
                short s;
                CertificateIssuerName certificateIssuerName = null;
                DerValue derValue = new DerValue(byArray);
                if (derValue.tag != 48) {
                    throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
                }
                DerInputStream derInputStream = derValue.getData();
                int n = derInputStream.getEnumerated();
                if (DEBUG != null) {
                    DEBUG.println("OCSP response: " + OCSPResponse.responseToText(n));
                }
                if (n != 0) {
                    throw new CertPathValidatorException("OCSP Response Failure: " + OCSPResponse.responseToText(n));
                }
                derValue = derInputStream.getDerValue();
                if (!derValue.isContextSpecific((byte)0)) {
                    throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
                }
                DerValue derValue2 = derValue.data.getDerValue();
                if (derValue2.tag != 48) {
                    throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
                }
                derInputStream = derValue2.data;
                ObjectIdentifier objectIdentifier = derInputStream.getOID();
                if (objectIdentifier.equals(OCSP_BASIC_RESPONSE_OID)) {
                    if (DEBUG != null) {
                        DEBUG.println("OCSP response type: basic");
                    }
                } else {
                    if (DEBUG != null) {
                        DEBUG.println("OCSP response type: " + objectIdentifier);
                    }
                    throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
                }
                DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
                DerValue[] derValueArray = derInputStream2.getSequence(2);
                DerValue derValue3 = derValueArray[0];
                byte[] byArray2 = derValueArray[0].toByteArray();
                if (derValue3.tag != 48) {
                    throw new IOException("Bad encoding in tbsResponseData  element of OCSP response: expected ASN.1 SEQUENCE tag.");
                }
                DerInputStream derInputStream3 = derValue3.data;
                DerValue derValue4 = derInputStream3.getDerValue();
                if (derValue4.isContextSpecific((byte)0) && derValue4.isConstructed() && derValue4.isContextSpecific()) {
                    derValue4 = derValue4.data.getDerValue();
                    int n2 = derValue4.getInteger();
                    if (derValue4.data.available() != 0) {
                        throw new IOException("Bad encoding in version  element of OCSP response: bad format");
                    }
                    derValue4 = derInputStream3.getDerValue();
                }
                if ((s = (short)((byte)(derValue4.tag & 0x1F))) == 1) {
                    certificateIssuerName = new CertificateIssuerName(derValue4.getData());
                    if (DEBUG != null) {
                        DEBUG.println("OCSP Responder name: " + certificateIssuerName);
                    }
                } else if (s != 2) {
                    throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
                }
                derValue4 = derInputStream3.getDerValue();
                Date date = derValue4.getGeneralizedTime();
                DerValue[] derValueArray2 = derInputStream3.getSequence(1);
                this.singleResponse = new SingleResponse(derValueArray2[0]);
                if (derInputStream3.available() > 0 && (derValue4 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
                    objectArray2 = derValue4.data.getSequence(3);
                    objectArray = new Extension[objectArray2.length];
                    for (int i = 0; i < objectArray2.length; ++i) {
                        objectArray[i] = new Extension((DerValue)objectArray2[i]);
                        if (DEBUG != null) {
                            DEBUG.println("OCSP extension: " + objectArray[i]);
                        }
                        if (((Extension)objectArray[i]).getExtensionId().equals(OCSP_NONCE_EXTENSION_OID)) {
                            byte[] byArray3 = ((Extension)objectArray[i]).getExtensionValue();
                            continue;
                        }
                        if (!((Extension)objectArray[i]).isCritical()) continue;
                        throw new IOException("Unsupported OCSP critical extension: " + ((Extension)objectArray[i]).getExtensionId());
                    }
                }
                AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[1]);
                objectArray2 = derValueArray[2].getBitString();
                objectArray = null;
                if (derValueArray.length > 3) {
                    DerValue derValue5 = derValueArray[3];
                    if (!derValue5.isContextSpecific((byte)0)) {
                        throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
                    }
                    object2 = derValue5.getData().getSequence(3);
                    objectArray = new X509CertImpl[((DerValue[])object2).length];
                    for (int i = 0; i < ((DerValue[])object2).length; ++i) {
                        objectArray[i] = new X509CertImpl(((DerValue)object2[i]).toByteArray());
                    }
                }
                if (objectArray != null && objectArray[0] != null && !((Certificate)((Object)(extension = objectArray[0]))).equals(object)) {
                    if (((X509CertImpl)((Object)extension)).getIssuerX500Principal().equals(((X509Certificate)object).getSubjectX500Principal())) {
                        Object object3;
                        object2 = ((X509CertImpl)((Object)extension)).getExtendedKeyUsage();
                        if (object2 == null || !object2.contains(KP_OCSP_SIGNING_OID)) {
                            if (DEBUG != null) {
                                DEBUG.println("Responder's certificate is not valid for signing OCSP responses.");
                            }
                            throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                        }
                        try {
                            object3 = pKIXParameters.getDate();
                            if (object3 == null) {
                                ((X509CertImpl)((Object)extension)).checkValidity();
                            } else {
                                ((X509CertImpl)((Object)extension)).checkValidity((Date)object3);
                            }
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            if (DEBUG != null) {
                                DEBUG.println("Responder's certificate is not within the validity period.");
                            }
                            throw new CertPathValidatorException("Responder's certificate not within the validity period");
                        }
                        object3 = ((X509CertImpl)((Object)extension)).getExtension(PKIXExtensions.OCSPNoCheck_Id);
                        if (object3 != null && DEBUG != null) {
                            DEBUG.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                        }
                        try {
                            ((X509CertImpl)((Object)extension)).verify(((Certificate)object).getPublicKey());
                            object = extension;
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            object = null;
                        }
                    } else {
                        if (DEBUG != null) {
                            DEBUG.println("Responder's certificate is not authorized to sign OCSP responses.");
                        }
                        throw new CertPathValidatorException("Responder's certificate not authorized to sign OCSP responses");
                    }
                }
                if (object != null) {
                    if (!this.verifyResponse(byArray2, (X509Certificate)object, algorithmId, (byte[])objectArray2, pKIXParameters)) {
                        if (DEBUG != null) {
                            DEBUG.println("Error verifying OCSP Responder's signature");
                        }
                        throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
                    }
                    break block44;
                }
                if (DEBUG != null) {
                    DEBUG.println("Unable to verify OCSP Responder's signature");
                }
                throw new CertPathValidatorException("Unable to verify OCSP Responder's signature");
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw certPathValidatorException;
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception);
            }
        }
    }

    private boolean verifyResponse(byte[] byArray, X509Certificate x509Certificate, AlgorithmId algorithmId, byte[] byArray2, PKIXParameters pKIXParameters) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(x509Certificate);
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                if (DEBUG != null) {
                    DEBUG.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (DEBUG != null) {
                DEBUG.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
    }

    int getCertStatus(SerialNumber serialNumber) {
        return this.singleResponse.getStatus();
    }

    CertId getCertId() {
        return this.singleResponse.getCertId();
    }

    Date getRevocationTime() {
        return this.singleResponse.getRevocationTime();
    }

    CRLReason getRevocationReason() {
        return this.singleResponse.getRevocationReason();
    }

    Map<String, java.security.cert.Extension> getSingleExtensions() {
        return this.singleResponse.getSingleExtensions();
    }

    private static String responseToText(int n) {
        switch (n) {
            case 0: {
                return "Successful";
            }
            case 1: {
                return "Malformed request";
            }
            case 2: {
                return "Internal error";
            }
            case 3: {
                return "Try again later";
            }
            case 4: {
                return "Unused status code";
            }
            case 5: {
                return "Request must be signed";
            }
            case 6: {
                return "Request is unauthorized";
            }
        }
        return "Unknown status code: " + n;
    }

    static String certStatusToText(int n) {
        switch (n) {
            case 0: {
                return "Good";
            }
            case 1: {
                return "Revoked";
            }
            case 2: {
                return "Unknown";
            }
        }
        return "Unknown certificate status code: " + n;
    }

    static {
        ObjectIdentifier objectIdentifier = null;
        ObjectIdentifier objectIdentifier2 = null;
        try {
            objectIdentifier = new ObjectIdentifier("1.3.6.1.5.5.7.48.1.1");
            objectIdentifier2 = new ObjectIdentifier("1.3.6.1.5.5.7.48.1.2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OCSP_BASIC_RESPONSE_OID = objectIdentifier;
        OCSP_NONCE_EXTENSION_OID = objectIdentifier2;
        values = CRLReason.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleResponse {
        private CertId certId;
        private int certStatus;
        private Date thisUpdate;
        private Date nextUpdate;
        private Date revocationTime;
        private CRLReason revocationReason = CRLReason.UNSPECIFIED;
        private HashMap<String, java.security.cert.Extension> singleExtensions;

        private SingleResponse(DerValue derValue) throws IOException {
            Object object;
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 0) {
                this.certStatus = 0;
            } else if (s == 1) {
                int n;
                this.certStatus = 1;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0 && (n = derValue2.getEnumerated()) >= 0 && n < values.length) {
                    this.revocationReason = values[n];
                }
                if (DEBUG != null) {
                    DEBUG.println("Revocation time: " + this.revocationTime);
                    DEBUG.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else if (s == 2) {
                this.certStatus = 2;
            } else {
                throw new IOException("Invalid certificate status");
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (derInputStream.available() != 0) {
                derValue2 = derInputStream.getDerValue();
                s = (byte)(derValue2.tag & 0x1F);
                if (s == 0) {
                    this.nextUpdate = derValue2.data.getGeneralizedTime();
                    if (derInputStream.available() != 0) {
                        derValue2 = derInputStream.getDerValue();
                        s = (byte)(derValue2.tag & 0x1F);
                    }
                }
            }
            if (derInputStream.available() > 0 && (derValue2 = derInputStream.getDerValue()).isContextSpecific((byte)1)) {
                DerValue[] derValueArray = derValue2.data.getSequence(3);
                this.singleExtensions = new HashMap(derValueArray.length);
                for (int i = 0; i < derValueArray.length; ++i) {
                    object = new Extension(derValueArray[i]);
                    this.singleExtensions.put(((Extension)object).getId(), (java.security.cert.Extension)object);
                    if (DEBUG == null) continue;
                    DEBUG.println("OCSP single extension: " + object);
                }
            }
            long l = System.currentTimeMillis();
            object = new Date(l + 600000L);
            Date date = new Date(l - 600000L);
            if (DEBUG != null) {
                String string = "";
                if (this.nextUpdate != null) {
                    string = " until " + this.nextUpdate;
                }
                DEBUG.println("Response's validity interval is from " + this.thisUpdate + string);
            }
            if (this.thisUpdate != null && ((Date)object).before(this.thisUpdate) || this.nextUpdate != null && date.after(this.nextUpdate)) {
                if (DEBUG != null) {
                    DEBUG.println("Response is unreliable: its validity interval is out-of-date");
                }
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        private int getStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        private Date getRevocationTime() {
            return this.revocationTime;
        }

        private CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        private Map<String, java.security.cert.Extension> getSingleExtensions() {
            return this.singleExtensions;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:  \n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: " + OCSPResponse.certStatusToText(OCSPResponse.this.getCertStatus(null)) + "\n");
            if (this.certStatus == 1) {
                stringBuilder.append("revocationTime is " + this.revocationTime + "\n");
                stringBuilder.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            stringBuilder.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return stringBuilder.toString();
        }
    }
}

