/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class ETypeInfo2 {
    private int etype;
    private String saltStr = null;
    private byte[] s2kparams = null;
    private static final byte TAG_TYPE = 0;
    private static final byte TAG_VALUE1 = 1;
    private static final byte TAG_VALUE2 = 2;

    private ETypeInfo2() {
    }

    public ETypeInfo2(int n, byte[] byArray, byte[] byArray2) {
        this.etype = n;
        if (byArray != null) {
            this.saltStr = new String(byArray);
        }
        if (byArray2 != null) {
            this.s2kparams = (byte[])byArray2.clone();
        }
    }

    public Object clone() {
        ETypeInfo2 eTypeInfo2 = new ETypeInfo2();
        eTypeInfo2.etype = this.etype;
        eTypeInfo2.saltStr = this.saltStr;
        if (this.s2kparams != null) {
            eTypeInfo2.s2kparams = new byte[this.s2kparams.length];
            System.arraycopy(this.s2kparams, 0, eTypeInfo2.s2kparams, 0, this.s2kparams.length);
        }
        return eTypeInfo2;
    }

    public ETypeInfo2(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.etype = derValue2.getData().getBigInteger().intValue();
        if (derValue.getData().available() > 0 && (derValue.getData().peekByte() & 0x1F) == 1) {
            derValue2 = derValue.getData().getDerValue();
            this.saltStr = derValue2.getData().getGeneralString();
        }
        if (derValue.getData().available() > 0 && (derValue.getData().peekByte() & 0x1F) == 2) {
            derValue2 = derValue.getData().getDerValue();
            this.s2kparams = derValue2.getData().getOctetString();
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.etype);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        if (this.saltStr != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putGeneralString(this.saltStr);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
        if (this.s2kparams != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOctetString(this.s2kparams);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        }
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public int getEType() {
        return this.etype;
    }

    public byte[] getSalt() {
        return this.saltStr == null ? null : this.saltStr.getBytes();
    }

    public byte[] getParams() {
        return this.s2kparams == null ? null : (byte[])this.s2kparams.clone();
    }
}

