/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileStore;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;
import sun.nio.fs.AbstractFileStoreSpaceAttributeView;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStoreAttributes;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class UnixFileStore
extends FileStore {
    private final UnixPath file;
    private final long dev;
    private final UnixMountEntry entry;
    private static final Object loadLock = new Object();
    private static volatile Properties props;

    private static long devFor(UnixPath unixPath) throws IOException {
        try {
            return UnixFileAttributes.get(unixPath, true).dev();
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return 0L;
        }
    }

    UnixFileStore(UnixPath unixPath) throws IOException {
        this.file = unixPath;
        this.dev = UnixFileStore.devFor(unixPath);
        this.entry = this.findMountEntry();
    }

    UnixFileStore(UnixFileSystem unixFileSystem, UnixMountEntry unixMountEntry) throws IOException {
        this.file = new UnixPath(unixFileSystem, unixMountEntry.dir());
        this.dev = unixMountEntry.dev() == 0L ? UnixFileStore.devFor(this.file) : unixMountEntry.dev();
        this.entry = unixMountEntry;
    }

    abstract UnixMountEntry findMountEntry() throws IOException;

    abstract boolean isLoopback();

    UnixPath file() {
        return this.file;
    }

    long dev() {
        return this.dev;
    }

    UnixMountEntry entry() {
        return this.entry;
    }

    @Override
    public String name() {
        return this.entry.name();
    }

    @Override
    public String type() {
        return this.entry.fstype();
    }

    @Override
    public boolean isReadOnly() {
        return this.entry.isReadOnly();
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> clazz) {
        if (clazz == FileStoreSpaceAttributeView.class) {
            return (V)new UnixFileStoreSpaceAttributeView(this);
        }
        return (V)((FileStoreAttributeView)null);
    }

    @Override
    public FileStoreAttributeView getFileStoreAttributeView(String string) {
        if (string.equals("space")) {
            return new UnixFileStoreSpaceAttributeView(this);
        }
        return null;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        if (clazz == BasicFileAttributeView.class) {
            return true;
        }
        if (clazz == PosixFileAttributeView.class || clazz == FileOwnerAttributeView.class) {
            FeatureStatus featureStatus = this.checkIfFeaturePresent("posix");
            return featureStatus != FeatureStatus.NOT_PRESENT;
        }
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        if (string.equals("basic") || string.equals("unix")) {
            return true;
        }
        if (string.equals("posix")) {
            return this.supportsFileAttributeView(PosixFileAttributeView.class);
        }
        if (string.equals("owner")) {
            return this.supportsFileAttributeView(FileOwnerAttributeView.class);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UnixFileStore)) {
            return false;
        }
        UnixFileStore unixFileStore = (UnixFileStore)object;
        if (this.dev != unixFileStore.dev) {
            return false;
        }
        boolean bl = this.isLoopback();
        if (bl != unixFileStore.isLoopback()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        return Arrays.equals(this.entry.dir(), unixFileStore.entry.dir());
    }

    public int hashCode() {
        return (int)(this.dev ^ this.dev >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(new String(this.entry.dir()));
        stringBuilder.append(" (");
        stringBuilder.append(this.entry.name());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FeatureStatus checkIfFeaturePresent(String string) {
        Object object;
        if (props == null) {
            object = loadLock;
            synchronized (object) {
                if (props == null) {
                    props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                        @Override
                        public Properties run() {
                            return UnixFileStore.loadProperties();
                        }
                    });
                }
            }
        }
        if ((object = props.getProperty(this.type())) != null) {
            String[] stringArray;
            for (String string2 : stringArray = ((String)object).split("\\s")) {
                if ((string2 = string2.trim().toLowerCase()).equals(string)) {
                    return FeatureStatus.PRESENT;
                }
                if (!string2.startsWith("no") || !(string2 = string2.substring(2)).equals(string)) continue;
                return FeatureStatus.NOT_PRESENT;
            }
        }
        return FeatureStatus.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        Properties properties = new Properties();
        String string = System.getProperty("java.home") + "/lib/fstypes.properties";
        Path path = Paths.get(string);
        try {
            SeekableByteChannel seekableByteChannel = path.newByteChannel(new OpenOption[0]);
            try {
                properties.load(Channels.newReader(seekableByteChannel, "UTF-8"));
            }
            finally {
                seekableByteChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FeatureStatus {
        PRESENT,
        NOT_PRESENT,
        UNKNOWN;

    }

    private static class UnixFileStoreSpaceAttributeView
    extends AbstractFileStoreSpaceAttributeView {
        private final UnixFileStore fs;

        UnixFileStoreSpaceAttributeView(UnixFileStore unixFileStore) {
            this.fs = unixFileStore;
        }

        public FileStoreSpaceAttributes readAttributes() throws IOException {
            UnixFileStoreAttributes unixFileStoreAttributes;
            UnixPath unixPath = this.fs.file();
            try {
                unixFileStoreAttributes = UnixFileStoreAttributes.get(unixPath);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(unixPath);
                return null;
            }
            return new FileStoreSpaceAttributes(){

                public long totalSpace() {
                    return unixFileStoreAttributes.blockSize() * unixFileStoreAttributes.totalBlocks();
                }

                public long usableSpace() {
                    return unixFileStoreAttributes.blockSize() * unixFileStoreAttributes.availableBlocks();
                }

                public long unallocatedSpace() {
                    return unixFileStoreAttributes.blockSize() * unixFileStoreAttributes.freeBlocks();
                }
            };
        }
    }
}

