/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBasicFileAttributeView
implements BasicFileAttributeView {
    private static final String SIZE_NAME = "size";
    private static final String CREATION_TIME_NAME = "creationTime";
    private static final String LAST_ACCESS_TIME_NAME = "lastAccessTime";
    private static final String LAST_MODIFIED_TIME_NAME = "lastModifiedTime";
    private static final String RESOLUTION_NAME = "resolution";
    private static final String FILE_KEY_NAME = "fileKey";
    private static final String LINK_COUNT_NAME = "linkCount";
    private static final String IS_DIRECTORY_NAME = "isDirectory";
    private static final String IS_REGULAR_FILE_NAME = "isRegularFile";
    private static final String IS_SYMBOLIC_LINK_NAME = "isSymbolicLink";
    private static final String IS_OTHER_NAME = "isOther";

    protected AbstractBasicFileAttributeView() {
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public Object getAttribute(String string) throws IOException {
        BasicFileAttributes basicFileAttributes = this.readAttributes();
        if (string.equals(SIZE_NAME)) {
            return basicFileAttributes.size();
        }
        if (string.equals(CREATION_TIME_NAME)) {
            return basicFileAttributes.creationTime();
        }
        if (string.equals(LAST_ACCESS_TIME_NAME)) {
            return basicFileAttributes.lastAccessTime();
        }
        if (string.equals(LAST_MODIFIED_TIME_NAME)) {
            return basicFileAttributes.lastModifiedTime();
        }
        if (string.equals(RESOLUTION_NAME)) {
            return basicFileAttributes.resolution();
        }
        if (string.equals(FILE_KEY_NAME)) {
            return basicFileAttributes.fileKey();
        }
        if (string.equals(LINK_COUNT_NAME)) {
            return basicFileAttributes.linkCount();
        }
        if (string.equals(IS_DIRECTORY_NAME)) {
            return basicFileAttributes.isDirectory();
        }
        if (string.equals(IS_REGULAR_FILE_NAME)) {
            return basicFileAttributes.isRegularFile();
        }
        if (string.equals(IS_SYMBOLIC_LINK_NAME)) {
            return basicFileAttributes.isSymbolicLink();
        }
        if (string.equals(IS_OTHER_NAME)) {
            return basicFileAttributes.isOther();
        }
        return null;
    }

    private Long toTimeValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Long l = (Long)object;
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("time value cannot be negative");
        }
        return l;
    }

    @Override
    public void setAttribute(String string, Object object) throws IOException {
        if (string.equals(LAST_MODIFIED_TIME_NAME)) {
            this.setTimes(this.toTimeValue(object), null, null, TimeUnit.MILLISECONDS);
            return;
        }
        if (string.equals(LAST_ACCESS_TIME_NAME)) {
            this.setTimes(null, this.toTimeValue(object), null, TimeUnit.MILLISECONDS);
            return;
        }
        if (string.equals(CREATION_TIME_NAME)) {
            this.setTimes(null, null, this.toTimeValue(object), TimeUnit.MILLISECONDS);
            return;
        }
        throw new UnsupportedOperationException("'" + string + "' is unknown or read-only attribute");
    }

    final void addBasicAttributesToBuilder(BasicFileAttributes basicFileAttributes, AttributesBuilder attributesBuilder) {
        if (attributesBuilder.match(SIZE_NAME)) {
            attributesBuilder.add(SIZE_NAME, basicFileAttributes.size());
        }
        if (attributesBuilder.match(CREATION_TIME_NAME)) {
            attributesBuilder.add(CREATION_TIME_NAME, basicFileAttributes.creationTime());
        }
        if (attributesBuilder.match(LAST_ACCESS_TIME_NAME)) {
            attributesBuilder.add(LAST_ACCESS_TIME_NAME, basicFileAttributes.lastAccessTime());
        }
        if (attributesBuilder.match(LAST_MODIFIED_TIME_NAME)) {
            attributesBuilder.add(LAST_MODIFIED_TIME_NAME, basicFileAttributes.lastModifiedTime());
        }
        if (attributesBuilder.match(RESOLUTION_NAME)) {
            attributesBuilder.add(RESOLUTION_NAME, (Object)basicFileAttributes.resolution());
        }
        if (attributesBuilder.match(FILE_KEY_NAME)) {
            attributesBuilder.add(FILE_KEY_NAME, basicFileAttributes.fileKey());
        }
        if (attributesBuilder.match(LINK_COUNT_NAME)) {
            attributesBuilder.add(LINK_COUNT_NAME, basicFileAttributes.linkCount());
        }
        if (attributesBuilder.match(IS_DIRECTORY_NAME)) {
            attributesBuilder.add(IS_DIRECTORY_NAME, basicFileAttributes.isDirectory());
        }
        if (attributesBuilder.match(IS_REGULAR_FILE_NAME)) {
            attributesBuilder.add(IS_REGULAR_FILE_NAME, basicFileAttributes.isRegularFile());
        }
        if (attributesBuilder.match(IS_SYMBOLIC_LINK_NAME)) {
            attributesBuilder.add(IS_SYMBOLIC_LINK_NAME, basicFileAttributes.isSymbolicLink());
        }
        if (attributesBuilder.match(IS_OTHER_NAME)) {
            attributesBuilder.add(IS_OTHER_NAME, basicFileAttributes.isOther());
        }
    }

    @Override
    public Map<String, ?> readAttributes(String string, String[] stringArray) throws IOException {
        AttributesBuilder attributesBuilder = AttributesBuilder.create(string, stringArray);
        this.addBasicAttributesToBuilder(this.readAttributes(), attributesBuilder);
        return attributesBuilder.unmodifiableMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributesBuilder {
        private Set<String> set = new HashSet<String>();
        private Map<String, Object> map = new HashMap<String, Object>();
        private boolean copyAll;

        private AttributesBuilder(String string, String[] stringArray) {
            if (string.equals("*")) {
                this.copyAll = true;
            } else {
                this.set.add(string);
                for (String string2 : stringArray) {
                    if (string2.equals("*")) {
                        this.copyAll = true;
                        break;
                    }
                    this.set.add(string2);
                }
            }
        }

        static AttributesBuilder create(String string, String[] stringArray) {
            return new AttributesBuilder(string, stringArray);
        }

        boolean match(String string) {
            if (this.copyAll) {
                return true;
            }
            return this.set.contains(string);
        }

        void add(String string, Object object) {
            this.map.put(string, object);
        }

        Map<String, Object> unmodifiableMap() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

