/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.FileLockTable;

abstract class AsynchronousFileChannelImpl
extends AsynchronousFileChannel {
    protected final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    protected volatile boolean closed;
    protected final FileDescriptor fdObj;
    protected final boolean reading;
    protected final boolean writing;
    protected final ExecutorService executor;
    private volatile FileLockTable fileLockTable;

    protected AsynchronousFileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ExecutorService executorService) {
        this.fdObj = fileDescriptor;
        this.reading = bl;
        this.writing = bl2;
        this.executor = executorService;
    }

    final ExecutorService executor() {
        return this.executor;
    }

    public final boolean isOpen() {
        return !this.closed;
    }

    protected final void begin() throws IOException {
        this.closeLock.readLock().lock();
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    protected final void end() {
        this.closeLock.readLock().unlock();
    }

    protected final void end(boolean bl) throws IOException {
        this.end();
        if (!bl && !this.isOpen()) {
            throw new AsynchronousCloseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureFileLockTableInitialized() throws IOException {
        if (this.fileLockTable == null) {
            AsynchronousFileChannelImpl asynchronousFileChannelImpl = this;
            synchronized (asynchronousFileChannelImpl) {
                if (this.fileLockTable == null) {
                    this.fileLockTable = FileLockTable.newSharedFileLockTable(this, this.fdObj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void invalidateAllLocks() throws IOException {
        if (this.fileLockTable != null) {
            Iterator<FileLock> iterator = this.fileLockTable.removeAll().iterator();
            while (iterator.hasNext()) {
                FileLock fileLock;
                FileLock fileLock2 = fileLock = iterator.next();
                synchronized (fileLock2) {
                    if (fileLock.isValid()) {
                        FileLockImpl fileLockImpl = (FileLockImpl)fileLock;
                        this.implRelease(fileLockImpl);
                        fileLockImpl.invalidate();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileLockImpl addToFileLockTable(long l, long l2, boolean bl) {
        block5: {
            try {
                this.closeLock.readLock().lock();
                if (!this.closed) break block5;
                FileLockImpl fileLockImpl = null;
                Object var9_6 = null;
                this.end();
                return fileLockImpl;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.end();
                throw throwable;
            }
        }
        try {
            this.ensureFileLockTableInitialized();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l, l2, bl);
        this.fileLockTable.add(fileLockImpl);
        Object var9_7 = null;
        this.end();
        return fileLockImpl;
    }

    protected final void removeFromFileLockTable(FileLockImpl fileLockImpl) {
        this.fileLockTable.remove(fileLockImpl);
    }

    protected abstract void implRelease(FileLockImpl var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void release(FileLockImpl fileLockImpl) throws IOException {
        try {
            this.begin();
            this.implRelease(fileLockImpl);
            this.removeFromFileLockTable(fileLockImpl);
            Object var3_2 = null;
            this.end();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.end();
            throw throwable;
        }
    }
}

