/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.Painter;
import javax.swing.plaf.nimbus.NimbusStyle;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

class SynthPainterImpl
extends SynthPainter {
    private NimbusStyle style;

    SynthPainterImpl(NimbusStyle nimbusStyle) {
        this.style = nimbusStyle;
    }

    private void paint(Painter painter, SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, AffineTransform affineTransform) {
        if (painter != null) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (affineTransform != null) {
                    graphics2D.transform(affineTransform);
                }
                graphics2D.translate(n, n2);
                painter.paint(graphics2D, synthContext.getComponent(), n3, n4);
                graphics2D.translate(-n, -n2);
                if (affineTransform != null) {
                    try {
                        graphics2D.transform(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        noninvertibleTransformException.printStackTrace();
                    }
                }
            } else {
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                if (affineTransform != null) {
                    graphics2D.transform(affineTransform);
                }
                painter.paint(graphics2D, synthContext.getComponent(), n3, n4);
                graphics2D.dispose();
                graphics.drawImage(bufferedImage, n, n2, null);
                bufferedImage = null;
            }
        }
    }

    private void paintBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, AffineTransform affineTransform) {
        Painter painter;
        Color color;
        JComponent jComponent = synthContext.getComponent();
        Color color2 = color = jComponent != null ? jComponent.getBackground() : null;
        if ((color == null || color.getAlpha() > 0) && (painter = this.style.getBackgroundPainter(synthContext)) != null) {
            this.paint(painter, synthContext, graphics, n, n2, n3, n4, affineTransform);
        }
    }

    private void paintForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, AffineTransform affineTransform) {
        Painter painter = this.style.getForegroundPainter(synthContext);
        if (painter != null) {
            this.paint(painter, synthContext, graphics, n, n2, n3, n4, affineTransform);
        }
    }

    private void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, AffineTransform affineTransform) {
        Painter painter = this.style.getBorderPainter(synthContext);
        if (painter != null) {
            this.paint(painter, synthContext, graphics, n, n2, n3, n4, affineTransform);
        }
    }

    private void paintBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        if (synthContext.getComponent() instanceof JSlider) {
            bl = true;
        }
        if (n5 == 1 && bl) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(-1.0, 1.0);
            affineTransform.rotate(Math.toRadians(90.0));
            this.paintBackground(synthContext, graphics, n2, n, n4, n3, affineTransform);
        } else if (n5 == 1) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(90.0));
            affineTransform.translate(0.0, -(n + n3));
            this.paintBackground(synthContext, graphics, n2, n, n4, n3, affineTransform);
        } else if (n5 == 0 && bl) {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            this.paintBackground(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        }
    }

    private void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        if (n5 == 1 && bl) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(-1.0, 1.0);
            affineTransform.rotate(Math.toRadians(90.0));
            this.paintBorder(synthContext, graphics, n2, n, n4, n3, affineTransform);
        } else if (n5 == 1) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(90.0));
            affineTransform.translate(0.0, -(n + n3));
            this.paintBorder(synthContext, graphics, n2, 0, n4, n3, affineTransform);
        } else if (n5 == 0 && bl) {
            this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
        }
    }

    private void paintForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        if (n5 == 1 && bl) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(-1.0, 1.0);
            affineTransform.rotate(Math.toRadians(90.0));
            this.paintForeground(synthContext, graphics, n2, n, n4, n3, affineTransform);
        } else if (n5 == 1) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(90.0));
            affineTransform.translate(0.0, -(n + n3));
            this.paintForeground(synthContext, graphics, n2, 0, n4, n3, affineTransform);
        } else if (n5 == 0 && bl) {
            this.paintForeground(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            this.paintForeground(synthContext, graphics, n, n2, n3, n4, null);
        }
    }

    public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            this.paintBackground(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        }
    }

    public void paintArrowButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        String string = synthContext.getComponent().getName();
        boolean bl = synthContext.getComponent().getComponentOrientation().isLeftToRight();
        if ("Spinner.nextButton".equals(string) || "Spinner.previousButton".equals(string)) {
            if (bl) {
                this.paintForeground(synthContext, graphics, n, n2, n3, n4, null);
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(n3, 0.0);
                affineTransform.scale(-1.0, 1.0);
                this.paintForeground(synthContext, graphics, n, n2, n3, n4, affineTransform);
            }
        } else if (n5 == 7) {
            this.paintForeground(synthContext, graphics, n, n2, n3, n4, null);
        } else if (n5 == 1) {
            if (bl) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(-1.0, 1.0);
                affineTransform.rotate(Math.toRadians(90.0));
                this.paintForeground(synthContext, graphics, n2, 0, n4, n3, affineTransform);
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.rotate(Math.toRadians(90.0));
                affineTransform.translate(0.0, -(n + n3));
                this.paintForeground(synthContext, graphics, n2, 0, n4, n3, affineTransform);
            }
        } else if (n5 == 3) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n3, 0.0);
            affineTransform.scale(-1.0, 1.0);
            this.paintForeground(synthContext, graphics, n, n2, n3, n4, affineTransform);
        } else if (n5 == 5) {
            if (bl) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.rotate(Math.toRadians(-90.0));
                affineTransform.translate(-n4, 0.0);
                this.paintForeground(synthContext, graphics, n2, n, n4, n3, affineTransform);
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(-1.0, 1.0);
                affineTransform.rotate(Math.toRadians(-90.0));
                affineTransform.translate(-(n4 + n2), -(n3 + n));
                this.paintForeground(synthContext, graphics, n2, n, n4, n3, affineTransform);
            }
        }
    }

    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintCheckBoxMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintCheckBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintColorChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintColorChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintComboBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            this.paintBackground(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        }
    }

    public void paintComboBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintDesktopIconBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintDesktopIconBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintDesktopPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintEditorPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintEditorPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintFileChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintFileChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintFormattedTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            this.paintBackground(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        }
    }

    public void paintFormattedTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            this.paintBorder(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        }
    }

    public void paintInternalFrameTitlePaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintInternalFrameTitlePaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintInternalFrameBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintLabelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintLabelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintListBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintListBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintMenuBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintOptionPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintOptionPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintPanelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintPanelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintPasswordFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintPasswordFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintPopupMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintPopupMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintForeground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintRadioButtonMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintRadioButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintRootPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintRootPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintScrollBarThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintScrollPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSeparatorForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintForeground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (synthContext.getComponent().getClientProperty("Slider.paintThumbArrowShape") == Boolean.TRUE) {
            n5 = n5 == 0 ? 1 : 0;
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
        } else {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }
    }

    public void paintSliderThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintSpinnerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSpinnerBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 == 1) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(-1.0, 1.0);
            affineTransform.rotate(Math.toRadians(90.0));
            this.paintBackground(synthContext, graphics, n2, n, n4, n3, affineTransform);
        } else {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        }
    }

    public void paintSplitPaneDividerForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintForeground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSplitPaneDragDivider(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSplitPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintSplitPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 == 2) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(-1.0, 1.0);
            affineTransform.rotate(Math.toRadians(90.0));
            this.paintBackground(synthContext, graphics, n2, n, n4, n3, affineTransform);
        } else if (n5 == 4) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(90.0));
            affineTransform.translate(0.0, -(n + n3));
            this.paintBackground(synthContext, graphics, n2, 0, n4, n3, affineTransform);
        } else if (n5 == 3) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -n4);
            this.paintBackground(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        } else {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        }
    }

    public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 == 2) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(-1.0, 1.0);
            affineTransform.rotate(Math.toRadians(90.0));
            this.paintBackground(synthContext, graphics, n2, n, n4, n3, affineTransform);
        } else if (n6 == 4) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(90.0));
            affineTransform.translate(0.0, -(n + n3));
            this.paintBackground(synthContext, graphics, n2, 0, n4, n3, affineTransform);
        } else if (n6 == 3) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -n4);
            this.paintBackground(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        } else {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        }
    }

    public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTabbedPaneContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTableHeaderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTableHeaderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTableBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTableBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTextAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTextPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTextPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            this.paintBackground(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        }
    }

    public void paintTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            this.paintBorder(synthContext, graphics, 0, 0, n3, n4, affineTransform);
        }
    }

    public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToggleButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintToolBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintToolBarContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolBarContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintToolBarDragWindowBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolBarDragWindowBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, n5);
    }

    public void paintToolTipBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintToolTipBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTreeBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTreeBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTreeCellBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTreeCellBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintTreeCellFocus(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintViewportBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBackground(synthContext, graphics, n, n2, n3, n4, null);
    }

    public void paintViewportBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(synthContext, graphics, n, n2, n3, n4, null);
    }
}

