/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.io.IOException;
import java.nio.file.FileRef;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Attributes {
    private Attributes() {
    }

    private static String[] split(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(58);
        if (n == -1) {
            stringArray[0] = "basic";
            stringArray[1] = string;
        } else {
            stringArray[0] = string.substring(0, n++);
            stringArray[1] = n == string.length() ? "" : string.substring(n);
        }
        return stringArray;
    }

    public static void setAttribute(FileRef fileRef, String string, Object object) throws IOException {
        String[] stringArray = Attributes.split(string);
        FileAttributeView fileAttributeView = fileRef.getFileAttributeView(stringArray[0], new LinkOption[0]);
        if (fileAttributeView == null) {
            throw new UnsupportedOperationException("View '" + stringArray[0] + "' not available");
        }
        fileAttributeView.setAttribute(stringArray[1], object);
    }

    public static Object getAttribute(FileRef fileRef, String string, LinkOption ... linkOptionArray) throws IOException {
        String[] stringArray = Attributes.split(string);
        FileAttributeView fileAttributeView = fileRef.getFileAttributeView(stringArray[0], linkOptionArray);
        if (fileAttributeView != null) {
            return fileAttributeView.getAttribute(stringArray[1]);
        }
        return null;
    }

    public static Map<String, ?> readAttributes(FileRef fileRef, String string, LinkOption ... linkOptionArray) throws IOException {
        String[] stringArray = Attributes.split(string);
        FileAttributeView fileAttributeView = fileRef.getFileAttributeView(stringArray[0], linkOptionArray);
        if (fileAttributeView != null) {
            String[] stringArray2 = stringArray[1].split(",");
            int n = stringArray2.length - 1;
            String string2 = stringArray2[0];
            String[] stringArray3 = new String[n];
            if (n > 0) {
                System.arraycopy(stringArray2, 1, stringArray3, 0, n);
            }
            return fileAttributeView.readAttributes(string2, stringArray3);
        }
        return Collections.emptyMap();
    }

    public static BasicFileAttributes readBasicFileAttributes(FileRef fileRef, LinkOption ... linkOptionArray) throws IOException {
        return fileRef.getFileAttributeView(BasicFileAttributeView.class, linkOptionArray).readAttributes();
    }

    public static PosixFileAttributes readPosixFileAttributes(FileRef fileRef, LinkOption ... linkOptionArray) throws IOException {
        PosixFileAttributeView posixFileAttributeView = fileRef.getFileAttributeView(PosixFileAttributeView.class, linkOptionArray);
        if (posixFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return posixFileAttributeView.readAttributes();
    }

    public static DosFileAttributes readDosFileAttributes(FileRef fileRef, LinkOption ... linkOptionArray) throws IOException {
        DosFileAttributeView dosFileAttributeView = fileRef.getFileAttributeView(DosFileAttributeView.class, linkOptionArray);
        if (dosFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return dosFileAttributeView.readAttributes();
    }

    public static UserPrincipal getOwner(FileRef fileRef) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = fileRef.getFileAttributeView(FileOwnerAttributeView.class, new LinkOption[0]);
        if (fileOwnerAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return fileOwnerAttributeView.getOwner();
    }

    public static void setOwner(FileRef fileRef, UserPrincipal userPrincipal) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = fileRef.getFileAttributeView(FileOwnerAttributeView.class, new LinkOption[0]);
        if (fileOwnerAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        fileOwnerAttributeView.setOwner(userPrincipal);
    }

    public static List<AclEntry> getAcl(FileRef fileRef) throws IOException {
        AclFileAttributeView aclFileAttributeView = fileRef.getFileAttributeView(AclFileAttributeView.class, new LinkOption[0]);
        if (aclFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return aclFileAttributeView.getAcl();
    }

    public static void setAcl(FileRef fileRef, List<AclEntry> list) throws IOException {
        AclFileAttributeView aclFileAttributeView = fileRef.getFileAttributeView(AclFileAttributeView.class, new LinkOption[0]);
        if (aclFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        aclFileAttributeView.setAcl(list);
    }

    public static void setLastModifiedTime(FileRef fileRef, long l, TimeUnit timeUnit) throws IOException {
        fileRef.getFileAttributeView(BasicFileAttributeView.class, new LinkOption[0]).setTimes(l, null, null, timeUnit);
    }

    public static void setLastAccessTime(FileRef fileRef, long l, TimeUnit timeUnit) throws IOException {
        fileRef.getFileAttributeView(BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, l, null, timeUnit);
    }

    public static void setPosixFilePermissions(FileRef fileRef, Set<PosixFilePermission> set) throws IOException {
        PosixFileAttributeView posixFileAttributeView = fileRef.getFileAttributeView(PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        posixFileAttributeView.setPermissions(set);
    }

    public static FileStoreSpaceAttributes readFileStoreSpaceAttributes(FileStore fileStore) throws IOException {
        FileStoreSpaceAttributeView fileStoreSpaceAttributeView = fileStore.getFileStoreAttributeView(FileStoreSpaceAttributeView.class);
        if (fileStoreSpaceAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return fileStoreSpaceAttributeView.readAttributes();
    }
}

