/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;

public class Paths {
    private Paths() {
    }

    public static Path get(String string) {
        return FileSystems.getDefault().getPath(string);
    }

    public static Path get(URI uRI) {
        String string = uRI.getScheme();
        if (string == null) {
            throw new IllegalArgumentException("Missing scheme");
        }
        if (string.equalsIgnoreCase("file")) {
            return FileSystems.getDefault().provider().getPath(uRI);
        }
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!fileSystemProvider.getScheme().equalsIgnoreCase(string)) continue;
            return fileSystemProvider.getPath(uRI);
        }
        throw new FileSystemNotFoundException("Provider \"" + string + "\" not installed");
    }
}

