/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Character
implements Serializable,
Comparable<Character> {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class<Character> TYPE = Class.getPrimitiveClass("char");
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    static final int ERROR = -1;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;
    public static final int SIZE = 16;

    public Character(char c) {
        this.value = c;
    }

    public static Character valueOf(char c) {
        if (c <= '\u007f') {
            return CharacterCache.cache[c];
        }
        return new Character(c);
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Character) {
            return this.value == ((Character)object).charValue();
        }
        return false;
    }

    public String toString() {
        char[] cArray = new char[]{this.value};
        return String.valueOf(cArray);
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    public static boolean isValidCodePoint(int n) {
        return n >= 0 && n <= 0x10FFFF;
    }

    public static boolean isSupplementaryCodePoint(int n) {
        return n >= 65536 && n <= 0x10FFFF;
    }

    public static boolean isHighSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isLowSurrogate(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    public static boolean isSurrogatePair(char c, char c2) {
        return Character.isHighSurrogate(c) && Character.isLowSurrogate(c2);
    }

    public static int charCount(int n) {
        return n >= 65536 ? 2 : 1;
    }

    public static int toCodePoint(char c, char c2) {
        return (c - 55296 << 10) + (c2 - 56320) + 65536;
    }

    public static int codePointAt(CharSequence charSequence, int n) {
        char c;
        char c2;
        if (Character.isHighSurrogate(c2 = charSequence.charAt(n++)) && n < charSequence.length() && Character.isLowSurrogate(c = charSequence.charAt(n))) {
            return Character.toCodePoint(c2, c);
        }
        return c2;
    }

    public static int codePointAt(char[] cArray, int n) {
        return Character.codePointAtImpl(cArray, n, cArray.length);
    }

    public static int codePointAt(char[] cArray, int n, int n2) {
        if (n >= n2 || n2 < 0 || n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointAtImpl(cArray, n, n2);
    }

    static int codePointAtImpl(char[] cArray, int n, int n2) {
        char c;
        char c2;
        if (Character.isHighSurrogate(c2 = cArray[n++]) && n < n2 && Character.isLowSurrogate(c = cArray[n])) {
            return Character.toCodePoint(c2, c);
        }
        return c2;
    }

    public static int codePointBefore(CharSequence charSequence, int n) {
        char c;
        char c2;
        if (Character.isLowSurrogate(c2 = charSequence.charAt(--n)) && n > 0 && Character.isHighSurrogate(c = charSequence.charAt(--n))) {
            return Character.toCodePoint(c, c2);
        }
        return c2;
    }

    public static int codePointBefore(char[] cArray, int n) {
        return Character.codePointBeforeImpl(cArray, n, 0);
    }

    public static int codePointBefore(char[] cArray, int n, int n2) {
        if (n <= n2 || n2 < 0 || n2 >= cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBeforeImpl(cArray, n, n2);
    }

    static int codePointBeforeImpl(char[] cArray, int n, int n2) {
        char c;
        char c2;
        if (Character.isLowSurrogate(c2 = cArray[--n]) && n > n2 && Character.isHighSurrogate(c = cArray[--n])) {
            return Character.toCodePoint(c, c2);
        }
        return c2;
    }

    public static int toChars(int n, char[] cArray, int n2) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException();
        }
        if (n < 65536) {
            cArray[n2] = (char)n;
            return 1;
        }
        Character.toSurrogates(n, cArray, n2);
        return 2;
    }

    public static char[] toChars(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException();
        }
        if (n < 65536) {
            return new char[]{(char)n};
        }
        char[] cArray = new char[2];
        Character.toSurrogates(n, cArray, 0);
        return cArray;
    }

    static void toSurrogates(int n, char[] cArray, int n2) {
        int n3 = n - 65536;
        cArray[n2 + 1] = (char)((n3 & 0x3FF) + 56320);
        cArray[n2] = (char)((n3 >>> 10) + 55296);
    }

    public static int codePointCount(CharSequence charSequence, int n, int n2) {
        int n3 = charSequence.length();
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            ++n4;
            if (!Character.isHighSurrogate(charSequence.charAt(n5++)) || n5 >= n2 || !Character.isLowSurrogate(charSequence.charAt(n5))) continue;
            ++n5;
        }
        return n4;
    }

    public static int codePointCount(char[] cArray, int n, int n2) {
        if (n2 > cArray.length - n || n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(cArray, n, n2);
    }

    static int codePointCountImpl(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            ++n4;
            if (!Character.isHighSurrogate(cArray[n5++]) || n5 >= n3 || !Character.isLowSurrogate(cArray[n5])) continue;
            ++n5;
        }
        return n4;
    }

    public static int offsetByCodePoints(CharSequence charSequence, int n, int n2) {
        int n3 = charSequence.length();
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n;
        if (n2 >= 0) {
            int n5;
            for (n5 = 0; n4 < n3 && n5 < n2; ++n5) {
                if (!Character.isHighSurrogate(charSequence.charAt(n4++)) || n4 >= n3 || !Character.isLowSurrogate(charSequence.charAt(n4))) continue;
                ++n4;
            }
            if (n5 < n2) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int n6;
            for (n6 = n2; n4 > 0 && n6 < 0; ++n6) {
                if (!Character.isLowSurrogate(charSequence.charAt(--n4)) || n4 <= 0 || !Character.isHighSurrogate(charSequence.charAt(n4 - 1))) continue;
                --n4;
            }
            if (n6 < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return n4;
    }

    public static int offsetByCodePoints(char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 > cArray.length - n || n < 0 || n2 < 0 || n3 < n || n3 > n + n2) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(cArray, n, n2, n3, n4);
    }

    static int offsetByCodePointsImpl(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = n3;
        if (n4 >= 0) {
            int n6;
            int n7 = n + n2;
            for (n6 = 0; n5 < n7 && n6 < n4; ++n6) {
                if (!Character.isHighSurrogate(cArray[n5++]) || n5 >= n7 || !Character.isLowSurrogate(cArray[n5])) continue;
                ++n5;
            }
            if (n6 < n4) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int n8;
            for (n8 = n4; n5 > n && n8 < 0; ++n8) {
                if (!Character.isLowSurrogate(cArray[--n5]) || n5 <= n || !Character.isHighSurrogate(cArray[n5 - 1])) continue;
                --n5;
            }
            if (n8 < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return n5;
    }

    public static boolean isLowerCase(char c) {
        return Character.isLowerCase((int)c);
    }

    public static boolean isLowerCase(int n) {
        return Character.getType(n) == 2;
    }

    public static boolean isUpperCase(char c) {
        return Character.isUpperCase((int)c);
    }

    public static boolean isUpperCase(int n) {
        return Character.getType(n) == 1;
    }

    public static boolean isTitleCase(char c) {
        return Character.isTitleCase((int)c);
    }

    public static boolean isTitleCase(int n) {
        return Character.getType(n) == 3;
    }

    public static boolean isDigit(char c) {
        return Character.isDigit((int)c);
    }

    public static boolean isDigit(int n) {
        return Character.getType(n) == 9;
    }

    public static boolean isDefined(char c) {
        return Character.isDefined((int)c);
    }

    public static boolean isDefined(int n) {
        return Character.getType(n) != 0;
    }

    public static boolean isLetter(char c) {
        return Character.isLetter((int)c);
    }

    public static boolean isLetter(int n) {
        return (62 >> Character.getType(n) & 1) != 0;
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit((int)c);
    }

    public static boolean isLetterOrDigit(int n) {
        return (574 >> Character.getType(n) & 1) != 0;
    }

    @Deprecated
    public static boolean isJavaLetter(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    @Deprecated
    public static boolean isJavaLetterOrDigit(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart((int)c);
    }

    public static boolean isJavaIdentifierStart(int n) {
        return CharacterData.of(n).isJavaIdentifierStart(n);
    }

    public static boolean isJavaIdentifierPart(char c) {
        return Character.isJavaIdentifierPart((int)c);
    }

    public static boolean isJavaIdentifierPart(int n) {
        return CharacterData.of(n).isJavaIdentifierPart(n);
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return Character.isUnicodeIdentifierStart((int)c);
    }

    public static boolean isUnicodeIdentifierStart(int n) {
        return CharacterData.of(n).isUnicodeIdentifierStart(n);
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        return Character.isUnicodeIdentifierPart((int)c);
    }

    public static boolean isUnicodeIdentifierPart(int n) {
        return CharacterData.of(n).isUnicodeIdentifierPart(n);
    }

    public static boolean isIdentifierIgnorable(char c) {
        return Character.isIdentifierIgnorable((int)c);
    }

    public static boolean isIdentifierIgnorable(int n) {
        return CharacterData.of(n).isIdentifierIgnorable(n);
    }

    public static char toLowerCase(char c) {
        return (char)Character.toLowerCase((int)c);
    }

    public static int toLowerCase(int n) {
        return CharacterData.of(n).toLowerCase(n);
    }

    public static char toUpperCase(char c) {
        return (char)Character.toUpperCase((int)c);
    }

    public static int toUpperCase(int n) {
        return CharacterData.of(n).toUpperCase(n);
    }

    public static char toTitleCase(char c) {
        return (char)Character.toTitleCase((int)c);
    }

    public static int toTitleCase(int n) {
        return CharacterData.of(n).toTitleCase(n);
    }

    public static int digit(char c, int n) {
        return Character.digit((int)c, n);
    }

    public static int digit(int n, int n2) {
        return CharacterData.of(n).digit(n, n2);
    }

    public static int getNumericValue(char c) {
        return Character.getNumericValue((int)c);
    }

    public static int getNumericValue(int n) {
        return CharacterData.of(n).getNumericValue(n);
    }

    @Deprecated
    public static boolean isSpace(char c) {
        return c <= ' ' && (4294981120L >> c & 1L) != 0L;
    }

    public static boolean isSpaceChar(char c) {
        return Character.isSpaceChar((int)c);
    }

    public static boolean isSpaceChar(int n) {
        return (28672 >> Character.getType(n) & 1) != 0;
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace((int)c);
    }

    public static boolean isWhitespace(int n) {
        return CharacterData.of(n).isWhitespace(n);
    }

    public static boolean isISOControl(char c) {
        return Character.isISOControl((int)c);
    }

    public static boolean isISOControl(int n) {
        return n >= 0 && n <= 31 || n >= 127 && n <= 159;
    }

    public static int getType(char c) {
        return Character.getType((int)c);
    }

    public static int getType(int n) {
        return CharacterData.of(n).getType(n);
    }

    public static char forDigit(int n, int n2) {
        if (n >= n2 || n < 0) {
            return '\u0000';
        }
        if (n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(87 + n);
    }

    public static byte getDirectionality(char c) {
        return Character.getDirectionality((int)c);
    }

    public static byte getDirectionality(int n) {
        return CharacterData.of(n).getDirectionality(n);
    }

    public static boolean isMirrored(char c) {
        return Character.isMirrored((int)c);
    }

    public static boolean isMirrored(int n) {
        return CharacterData.of(n).isMirrored(n);
    }

    @Override
    public int compareTo(Character c) {
        return this.value - c.value;
    }

    static int toUpperCaseEx(int n) {
        assert (Character.isValidCodePoint(n));
        return CharacterData.of(n).toUpperCaseEx(n);
    }

    static char[] toUpperCaseCharArray(int n) {
        assert (Character.isValidCodePoint(n) && !Character.isSupplementaryCodePoint(n));
        return CharacterData.of(n).toUpperCaseCharArray(n);
    }

    public static char reverseBytes(char c) {
        return (char)((c & 0xFF00) >> 8 | c << 8);
    }

    private static class CharacterCache {
        static final Character[] cache = new Character[128];

        private CharacterCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                CharacterCache.cache[i] = new Character((char)i);
            }
        }
    }

    public static final class UnicodeBlock
    extends Subset {
        private static Map map = new HashMap();
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("BASIC_LATIN", new String[]{"Basic Latin", "BasicLatin"});
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT", new String[]{"Latin-1 Supplement", "Latin-1Supplement"});
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A", new String[]{"Latin Extended-A", "LatinExtended-A"});
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B", new String[]{"Latin Extended-B", "LatinExtended-B"});
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS", new String[]{"IPA Extensions", "IPAExtensions"});
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS", new String[]{"Spacing Modifier Letters", "SpacingModifierLetters"});
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS", new String[]{"Combining Diacritical Marks", "CombiningDiacriticalMarks"});
        public static final UnicodeBlock GREEK = new UnicodeBlock("GREEK", new String[]{"Greek and Coptic", "GreekandCoptic"});
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("CYRILLIC");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("ARMENIAN");
        public static final UnicodeBlock HEBREW = new UnicodeBlock("HEBREW");
        public static final UnicodeBlock ARABIC = new UnicodeBlock("ARABIC");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("DEVANAGARI");
        public static final UnicodeBlock BENGALI = new UnicodeBlock("BENGALI");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("GURMUKHI");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("GUJARATI");
        public static final UnicodeBlock ORIYA = new UnicodeBlock("ORIYA");
        public static final UnicodeBlock TAMIL = new UnicodeBlock("TAMIL");
        public static final UnicodeBlock TELUGU = new UnicodeBlock("TELUGU");
        public static final UnicodeBlock KANNADA = new UnicodeBlock("KANNADA");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("MALAYALAM");
        public static final UnicodeBlock THAI = new UnicodeBlock("THAI");
        public static final UnicodeBlock LAO = new UnicodeBlock("LAO");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("TIBETAN");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("GEORGIAN");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO", new String[]{"Hangul Jamo", "HangulJamo"});
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL", new String[]{"Latin Extended Additional", "LatinExtendedAdditional"});
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED", new String[]{"Greek Extended", "GreekExtended"});
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION", new String[]{"General Punctuation", "GeneralPunctuation"});
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS", new String[]{"Superscripts and Subscripts", "SuperscriptsandSubscripts"});
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS", new String[]{"Currency Symbols", "CurrencySymbols"});
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS", new String[]{"Combining Diacritical Marks for Symbols", "CombiningDiacriticalMarksforSymbols", "Combining Marks for Symbols", "CombiningMarksforSymbols"});
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS", new String[]{"Letterlike Symbols", "LetterlikeSymbols"});
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS", new String[]{"Number Forms", "NumberForms"});
        public static final UnicodeBlock ARROWS = new UnicodeBlock("ARROWS");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS", new String[]{"Mathematical Operators", "MathematicalOperators"});
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL", new String[]{"Miscellaneous Technical", "MiscellaneousTechnical"});
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES", new String[]{"Control Pictures", "ControlPictures"});
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION", new String[]{"Optical Character Recognition", "OpticalCharacterRecognition"});
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS", new String[]{"Enclosed Alphanumerics", "EnclosedAlphanumerics"});
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("BOX_DRAWING", new String[]{"Box Drawing", "BoxDrawing"});
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS", new String[]{"Block Elements", "BlockElements"});
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES", new String[]{"Geometric Shapes", "GeometricShapes"});
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS", new String[]{"Miscellaneous Symbols", "MiscellaneousSymbols"});
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("DINGBATS");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION", new String[]{"CJK Symbols and Punctuation", "CJKSymbolsandPunctuation"});
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("HIRAGANA");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("KATAKANA");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("BOPOMOFO");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO", new String[]{"Hangul Compatibility Jamo", "HangulCompatibilityJamo"});
        public static final UnicodeBlock KANBUN = new UnicodeBlock("KANBUN");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS", new String[]{"Enclosed CJK Letters and Months", "EnclosedCJKLettersandMonths"});
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY", new String[]{"CJK Compatibility", "CJKCompatibility"});
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS", new String[]{"CJK Unified Ideographs", "CJKUnifiedIdeographs"});
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES", new String[]{"Hangul Syllables", "HangulSyllables"});
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA", new String[]{"Private Use Area", "PrivateUseArea"});
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS", new String[]{"CJK Compatibility Ideographs", "CJKCompatibilityIdeographs"});
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS", new String[]{"Alphabetic Presentation Forms", "AlphabeticPresentationForms"});
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A", new String[]{"Arabic Presentation Forms-A", "ArabicPresentationForms-A"});
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS", new String[]{"Combining Half Marks", "CombiningHalfMarks"});
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS", new String[]{"CJK Compatibility Forms", "CJKCompatibilityForms"});
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS", new String[]{"Small Form Variants", "SmallFormVariants"});
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B", new String[]{"Arabic Presentation Forms-B", "ArabicPresentationForms-B"});
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS", new String[]{"Halfwidth and Fullwidth Forms", "HalfwidthandFullwidthForms"});
        public static final UnicodeBlock SPECIALS = new UnicodeBlock("SPECIALS");
        @Deprecated
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock("SURROGATES_AREA");
        public static final UnicodeBlock SYRIAC = new UnicodeBlock("SYRIAC");
        public static final UnicodeBlock THAANA = new UnicodeBlock("THAANA");
        public static final UnicodeBlock SINHALA = new UnicodeBlock("SINHALA");
        public static final UnicodeBlock MYANMAR = new UnicodeBlock("MYANMAR");
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock("ETHIOPIC");
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock("CHEROKEE");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", new String[]{"Unified Canadian Aboriginal Syllabics", "UnifiedCanadianAboriginalSyllabics"});
        public static final UnicodeBlock OGHAM = new UnicodeBlock("OGHAM");
        public static final UnicodeBlock RUNIC = new UnicodeBlock("RUNIC");
        public static final UnicodeBlock KHMER = new UnicodeBlock("KHMER");
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock("MONGOLIAN");
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock("BRAILLE_PATTERNS", new String[]{"Braille Patterns", "BraillePatterns"});
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock("CJK_RADICALS_SUPPLEMENT", new String[]{"CJK Radicals Supplement", "CJKRadicalsSupplement"});
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock("KANGXI_RADICALS", new String[]{"Kangxi Radicals", "KangxiRadicals"});
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock("IDEOGRAPHIC_DESCRIPTION_CHARACTERS", new String[]{"Ideographic Description Characters", "IdeographicDescriptionCharacters"});
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock("BOPOMOFO_EXTENDED", new String[]{"Bopomofo Extended", "BopomofoExtended"});
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", new String[]{"CJK Unified Ideographs Extension A", "CJKUnifiedIdeographsExtensionA"});
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock("YI_SYLLABLES", new String[]{"Yi Syllables", "YiSyllables"});
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock("YI_RADICALS", new String[]{"Yi Radicals", "YiRadicals"});
        public static final UnicodeBlock CYRILLIC_SUPPLEMENTARY = new UnicodeBlock("CYRILLIC_SUPPLEMENTARY", new String[]{"Cyrillic Supplementary", "CyrillicSupplementary", "Cyrillic Supplement", "CyrillicSupplement"});
        public static final UnicodeBlock TAGALOG = new UnicodeBlock("TAGALOG");
        public static final UnicodeBlock HANUNOO = new UnicodeBlock("HANUNOO");
        public static final UnicodeBlock BUHID = new UnicodeBlock("BUHID");
        public static final UnicodeBlock TAGBANWA = new UnicodeBlock("TAGBANWA");
        public static final UnicodeBlock LIMBU = new UnicodeBlock("LIMBU");
        public static final UnicodeBlock TAI_LE = new UnicodeBlock("TAI_LE", new String[]{"Tai Le", "TaiLe"});
        public static final UnicodeBlock KHMER_SYMBOLS = new UnicodeBlock("KHMER_SYMBOLS", new String[]{"Khmer Symbols", "KhmerSymbols"});
        public static final UnicodeBlock PHONETIC_EXTENSIONS = new UnicodeBlock("PHONETIC_EXTENSIONS", new String[]{"Phonetic Extensions", "PhoneticExtensions"});
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", new String[]{"Miscellaneous Mathematical Symbols-A", "MiscellaneousMathematicalSymbols-A"});
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_A = new UnicodeBlock("SUPPLEMENTAL_ARROWS_A", new String[]{"Supplemental Arrows-A", "SupplementalArrows-A"});
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_B = new UnicodeBlock("SUPPLEMENTAL_ARROWS_B", new String[]{"Supplemental Arrows-B", "SupplementalArrows-B"});
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", new String[]{"Miscellaneous Mathematical Symbols-B", "MiscellaneousMathematicalSymbols-B"});
        public static final UnicodeBlock SUPPLEMENTAL_MATHEMATICAL_OPERATORS = new UnicodeBlock("SUPPLEMENTAL_MATHEMATICAL_OPERATORS", new String[]{"Supplemental Mathematical Operators", "SupplementalMathematicalOperators"});
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_ARROWS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS_AND_ARROWS", new String[]{"Miscellaneous Symbols and Arrows", "MiscellaneousSymbolsandArrows"});
        public static final UnicodeBlock KATAKANA_PHONETIC_EXTENSIONS = new UnicodeBlock("KATAKANA_PHONETIC_EXTENSIONS", new String[]{"Katakana Phonetic Extensions", "KatakanaPhoneticExtensions"});
        public static final UnicodeBlock YIJING_HEXAGRAM_SYMBOLS = new UnicodeBlock("YIJING_HEXAGRAM_SYMBOLS", new String[]{"Yijing Hexagram Symbols", "YijingHexagramSymbols"});
        public static final UnicodeBlock VARIATION_SELECTORS = new UnicodeBlock("VARIATION_SELECTORS", new String[]{"Variation Selectors", "VariationSelectors"});
        public static final UnicodeBlock LINEAR_B_SYLLABARY = new UnicodeBlock("LINEAR_B_SYLLABARY", new String[]{"Linear B Syllabary", "LinearBSyllabary"});
        public static final UnicodeBlock LINEAR_B_IDEOGRAMS = new UnicodeBlock("LINEAR_B_IDEOGRAMS", new String[]{"Linear B Ideograms", "LinearBIdeograms"});
        public static final UnicodeBlock AEGEAN_NUMBERS = new UnicodeBlock("AEGEAN_NUMBERS", new String[]{"Aegean Numbers", "AegeanNumbers"});
        public static final UnicodeBlock OLD_ITALIC = new UnicodeBlock("OLD_ITALIC", new String[]{"Old Italic", "OldItalic"});
        public static final UnicodeBlock GOTHIC = new UnicodeBlock("GOTHIC");
        public static final UnicodeBlock UGARITIC = new UnicodeBlock("UGARITIC");
        public static final UnicodeBlock DESERET = new UnicodeBlock("DESERET");
        public static final UnicodeBlock SHAVIAN = new UnicodeBlock("SHAVIAN");
        public static final UnicodeBlock OSMANYA = new UnicodeBlock("OSMANYA");
        public static final UnicodeBlock CYPRIOT_SYLLABARY = new UnicodeBlock("CYPRIOT_SYLLABARY", new String[]{"Cypriot Syllabary", "CypriotSyllabary"});
        public static final UnicodeBlock BYZANTINE_MUSICAL_SYMBOLS = new UnicodeBlock("BYZANTINE_MUSICAL_SYMBOLS", new String[]{"Byzantine Musical Symbols", "ByzantineMusicalSymbols"});
        public static final UnicodeBlock MUSICAL_SYMBOLS = new UnicodeBlock("MUSICAL_SYMBOLS", new String[]{"Musical Symbols", "MusicalSymbols"});
        public static final UnicodeBlock TAI_XUAN_JING_SYMBOLS = new UnicodeBlock("TAI_XUAN_JING_SYMBOLS", new String[]{"Tai Xuan Jing Symbols", "TaiXuanJingSymbols"});
        public static final UnicodeBlock MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeBlock("MATHEMATICAL_ALPHANUMERIC_SYMBOLS", new String[]{"Mathematical Alphanumeric Symbols", "MathematicalAlphanumericSymbols"});
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", new String[]{"CJK Unified Ideographs Extension B", "CJKUnifiedIdeographsExtensionB"});
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", new String[]{"CJK Compatibility Ideographs Supplement", "CJKCompatibilityIdeographsSupplement"});
        public static final UnicodeBlock TAGS = new UnicodeBlock("TAGS");
        public static final UnicodeBlock VARIATION_SELECTORS_SUPPLEMENT = new UnicodeBlock("VARIATION_SELECTORS_SUPPLEMENT", new String[]{"Variation Selectors Supplement", "VariationSelectorsSupplement"});
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_A = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_A", new String[]{"Supplementary Private Use Area-A", "SupplementaryPrivateUseArea-A"});
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_B = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_B", new String[]{"Supplementary Private Use Area-B", "SupplementaryPrivateUseArea-B"});
        public static final UnicodeBlock HIGH_SURROGATES = new UnicodeBlock("HIGH_SURROGATES", new String[]{"High Surrogates", "HighSurrogates"});
        public static final UnicodeBlock HIGH_PRIVATE_USE_SURROGATES = new UnicodeBlock("HIGH_PRIVATE_USE_SURROGATES", new String[]{"High Private Use Surrogates", "HighPrivateUseSurrogates"});
        public static final UnicodeBlock LOW_SURROGATES = new UnicodeBlock("LOW_SURROGATES", new String[]{"Low Surrogates", "LowSurrogates"});
        public static final UnicodeBlock ARABIC_SUPPLEMENT = new UnicodeBlock("ARABIC_SUPPLEMENT", new String[]{"Arabic Supplement", "ArabicSupplement"});
        public static final UnicodeBlock NKO = new UnicodeBlock("NKO");
        public static final UnicodeBlock ETHIOPIC_SUPPLEMENT = new UnicodeBlock("ETHIOPIC_SUPPLEMENT", new String[]{"Ethiopic Supplement", "EthiopicSupplement"});
        public static final UnicodeBlock NEW_TAI_LUE = new UnicodeBlock("NEW_TAI_LUE", new String[]{"New Tai Lue", "NewTaiLue"});
        public static final UnicodeBlock BUGINESE = new UnicodeBlock("BUGINESE");
        public static final UnicodeBlock BALINESE = new UnicodeBlock("BALINESE");
        public static final UnicodeBlock SUNDANESE = new UnicodeBlock("SUNDANESE");
        public static final UnicodeBlock LEPCHA = new UnicodeBlock("LEPCHA");
        public static final UnicodeBlock OL_CHIKI = new UnicodeBlock("OL_CHIKI", new String[]{"Ol Chiki", "OlChiki"});
        public static final UnicodeBlock PHONETIC_EXTENSIONS_SUPPLEMENT = new UnicodeBlock("PHONETIC_EXTENSIONS_SUPPLEMENT", new String[]{"Phonetic Extensions Supplement", "PhoneticExtensionsSupplement"});
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS_SUPPLEMENT = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS_SUPPLEMENT", new String[]{"Combining Diacritical Marks Supplement", "CombiningDiacriticalMarksSupplement"});
        public static final UnicodeBlock GLAGOLITIC = new UnicodeBlock("GLAGOLITIC");
        public static final UnicodeBlock LATIN_EXTENDED_C = new UnicodeBlock("LATIN_EXTENDED_C", new String[]{"Latin Extended-C", "LatinExtended-C"});
        public static final UnicodeBlock COPTIC = new UnicodeBlock("COPTIC");
        public static final UnicodeBlock GEORGIAN_SUPPLEMENT = new UnicodeBlock("GEORGIAN_SUPPLEMENT", new String[]{"Georgian Supplement", "GeorgianSupplement"});
        public static final UnicodeBlock TIFINAGH = new UnicodeBlock("TIFINAGH");
        public static final UnicodeBlock ETHIOPIC_EXTENDED = new UnicodeBlock("ETHIOPIC_EXTENDED", new String[]{"Ethiopic Extended", "EthiopicExtended"});
        public static final UnicodeBlock CYRILLIC_EXTENDED_A = new UnicodeBlock("CYRILLIC_EXTENDED_A", new String[]{"Cyrillic Extended-A", "CyrillicExtended-A"});
        public static final UnicodeBlock SUPPLEMENTAL_PUNCTUATION = new UnicodeBlock("SUPPLEMENTAL_PUNCTUATION", new String[]{"Supplemental Punctuation", "SupplementalPunctuation"});
        public static final UnicodeBlock CJK_STROKES = new UnicodeBlock("CJK_STROKES", new String[]{"CJK Strokes", "CJKStrokes"});
        public static final UnicodeBlock VAI = new UnicodeBlock("VAI");
        public static final UnicodeBlock CYRILLIC_EXTENDED_B = new UnicodeBlock("CYRILLIC_EXTENDED_B", new String[]{"Cyrillic Extended-B", "CyrillicExtended-B"});
        public static final UnicodeBlock MODIFIER_TONE_LETTERS = new UnicodeBlock("MODIFIER_TONE_LETTERS", new String[]{"Modifier Tone Letters", "ModifierToneLetters"});
        public static final UnicodeBlock LATIN_EXTENDED_D = new UnicodeBlock("LATIN_EXTENDED_D", new String[]{"Latin Extended-D", "LatinExtended-D"});
        public static final UnicodeBlock SYLOTI_NAGRI = new UnicodeBlock("SYLOTI_NAGRI", new String[]{"Syloti Nagri", "SylotiNagri"});
        public static final UnicodeBlock PHAGS_PA = new UnicodeBlock("PHAGS_PA", new String[]{"Phags-pa"});
        public static final UnicodeBlock SAURASHTRA = new UnicodeBlock("SAURASHTRA");
        public static final UnicodeBlock KAYAH_LI = new UnicodeBlock("KAYAH_LI", new String[]{"Kayah Li", "KayahLi"});
        public static final UnicodeBlock REJANG = new UnicodeBlock("REJANG");
        public static final UnicodeBlock CHAM = new UnicodeBlock("CHAM");
        public static final UnicodeBlock VERTICAL_FORMS = new UnicodeBlock("VERTICAL_FORMS", new String[]{"Vertical Forms", "VerticalForms"});
        public static final UnicodeBlock ANCIENT_GREEK_NUMBERS = new UnicodeBlock("ANCIENT_GREEK_NUMBERS", new String[]{"Ancient Greek Numbers", "AncientGreekNumbers"});
        public static final UnicodeBlock ANCIENT_SYMBOLS = new UnicodeBlock("ANCIENT_SYMBOLS", new String[]{"Ancient Symbols", "AncientSymbols"});
        public static final UnicodeBlock PHAISTOS_DISC = new UnicodeBlock("PHAISTOS_DISC", new String[]{"Phaistos Disc", "PhaistosDisc"});
        public static final UnicodeBlock LYCIAN = new UnicodeBlock("LYCIAN");
        public static final UnicodeBlock CARIAN = new UnicodeBlock("CARIAN");
        public static final UnicodeBlock OLD_PERSIAN = new UnicodeBlock("OLD_PERSIAN", new String[]{"Old Persian", "OldPersian"});
        public static final UnicodeBlock PHOENICIAN = new UnicodeBlock("PHOENICIAN");
        public static final UnicodeBlock LYDIAN = new UnicodeBlock("LYDIAN");
        public static final UnicodeBlock KHAROSHTHI = new UnicodeBlock("KHAROSHTHI");
        public static final UnicodeBlock CUNEIFORM = new UnicodeBlock("CUNEIFORM");
        public static final UnicodeBlock CUNEIFORM_NUMBERS_AND_PUNCTUATION = new UnicodeBlock("CUNEIFORM_NUMBERS_AND_PUNCTUATION", new String[]{"Cuneiform Numbers and Punctuation", "CuneiformNumbersandPunctuation"});
        public static final UnicodeBlock ANCIENT_GREEK_MUSICAL_NOTATION = new UnicodeBlock("ANCIENT_GREEK_MUSICAL_NOTATION", new String[]{"Ancient Greek Musical Notation", "AncientGreekMusicalNotation"});
        public static final UnicodeBlock COUNTING_ROD_NUMERALS = new UnicodeBlock("COUNTING_ROD_NUMERALS", new String[]{"Counting Rod Numerals", "CountingRodNumerals"});
        public static final UnicodeBlock MAHJONG_TILES = new UnicodeBlock("MAHJONG_TILES", new String[]{"Mahjong Tiles", "MahjongTiles"});
        public static final UnicodeBlock DOMINO_TILES = new UnicodeBlock("DOMINO_TILES", new String[]{"Domino Tiles", "DominoTiles"});
        private static final int[] blockStarts = new int[]{0, 128, 256, 384, 592, 688, 768, 880, 1024, 1280, 1328, 1424, 1536, 1792, 1872, 1920, 1984, 2048, 2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584, 3712, 3840, 4096, 4256, 4352, 4608, 4992, 5024, 5120, 5760, 5792, 5888, 5920, 5952, 5984, 6016, 6144, 6320, 6400, 6480, 6528, 6624, 6656, 6688, 6912, 7040, 7104, 7168, 7248, 7296, 7424, 7552, 7616, 7680, 7936, 8192, 8304, 8352, 8400, 8448, 8528, 8592, 8704, 8960, 9216, 9280, 9312, 9472, 9600, 9632, 9728, 9984, 10176, 10224, 10240, 10496, 10624, 10752, 11008, 11264, 11360, 11392, 11520, 11568, 11648, 11744, 11776, 11904, 12032, 12256, 12272, 12288, 12352, 12448, 12544, 12592, 12688, 12704, 12736, 12784, 12800, 13056, 13312, 19904, 19968, 40960, 42128, 42192, 42240, 42560, 42656, 42752, 42784, 43008, 43056, 43072, 43136, 43232, 43264, 43312, 43360, 43520, 43616, 44032, 55216, 55296, 56192, 56320, 57344, 63744, 64256, 64336, 65024, 65040, 65056, 65072, 65104, 65136, 65280, 65520, 65536, 65664, 65792, 65856, 65936, 66000, 66048, 66176, 66208, 66272, 66304, 66352, 66384, 66432, 66464, 66528, 66560, 66640, 66688, 66736, 67584, 67648, 67840, 67872, 67904, 68096, 68192, 73728, 74752, 74880, 118784, 119040, 119296, 119376, 119552, 119648, 119680, 119808, 120832, 126976, 127024, 127136, 131072, 173792, 194560, 195104, 917504, 917632, 917760, 918000, 983040, 0x100000};
        private static final UnicodeBlock[] blocks = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, CYRILLIC_SUPPLEMENTARY, ARMENIAN, HEBREW, ARABIC, SYRIAC, ARABIC_SUPPLEMENT, THAANA, NKO, null, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, ETHIOPIC_SUPPLEMENT, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, TAGALOG, HANUNOO, BUHID, TAGBANWA, KHMER, MONGOLIAN, null, LIMBU, TAI_LE, NEW_TAI_LUE, KHMER_SYMBOLS, BUGINESE, null, BALINESE, SUNDANESE, null, LEPCHA, OL_CHIKI, null, PHONETIC_EXTENSIONS, PHONETIC_EXTENSIONS_SUPPLEMENT, COMBINING_DIACRITICAL_MARKS_SUPPLEMENT, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, SUPPLEMENTAL_ARROWS_A, BRAILLE_PATTERNS, SUPPLEMENTAL_ARROWS_B, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, SUPPLEMENTAL_MATHEMATICAL_OPERATORS, MISCELLANEOUS_SYMBOLS_AND_ARROWS, GLAGOLITIC, LATIN_EXTENDED_C, COPTIC, GEORGIAN_SUPPLEMENT, TIFINAGH, ETHIOPIC_EXTENDED, CYRILLIC_EXTENDED_A, SUPPLEMENTAL_PUNCTUATION, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, null, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, CJK_STROKES, KATAKANA_PHONETIC_EXTENSIONS, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, YIJING_HEXAGRAM_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, null, VAI, CYRILLIC_EXTENDED_B, null, MODIFIER_TONE_LETTERS, LATIN_EXTENDED_D, SYLOTI_NAGRI, null, PHAGS_PA, SAURASHTRA, null, KAYAH_LI, REJANG, null, CHAM, null, HANGUL_SYLLABLES, null, HIGH_SURROGATES, HIGH_PRIVATE_USE_SURROGATES, LOW_SURROGATES, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, VARIATION_SELECTORS, VERTICAL_FORMS, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS, LINEAR_B_SYLLABARY, LINEAR_B_IDEOGRAMS, AEGEAN_NUMBERS, ANCIENT_GREEK_NUMBERS, ANCIENT_SYMBOLS, PHAISTOS_DISC, null, LYCIAN, CARIAN, null, OLD_ITALIC, GOTHIC, null, UGARITIC, OLD_PERSIAN, null, DESERET, SHAVIAN, OSMANYA, null, CYPRIOT_SYLLABARY, null, PHOENICIAN, LYDIAN, null, KHAROSHTHI, null, CUNEIFORM, CUNEIFORM_NUMBERS_AND_PUNCTUATION, null, BYZANTINE_MUSICAL_SYMBOLS, MUSICAL_SYMBOLS, ANCIENT_GREEK_MUSICAL_NOTATION, null, TAI_XUAN_JING_SYMBOLS, COUNTING_ROD_NUMERALS, null, MATHEMATICAL_ALPHANUMERIC_SYMBOLS, null, MAHJONG_TILES, DOMINO_TILES, null, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, null, CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, null, TAGS, null, VARIATION_SELECTORS_SUPPLEMENT, null, SUPPLEMENTARY_PRIVATE_USE_AREA_A, SUPPLEMENTARY_PRIVATE_USE_AREA_B};

        private UnicodeBlock(String string) {
            super(string);
            map.put(string.toUpperCase(Locale.US), this);
        }

        private UnicodeBlock(String string, String string2) {
            this(string);
            map.put(string2.toUpperCase(Locale.US), this);
        }

        private UnicodeBlock(String string, String[] stringArray) {
            this(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    map.put(stringArray[i].toUpperCase(Locale.US), this);
                }
            }
        }

        public static UnicodeBlock of(char c) {
            return UnicodeBlock.of((int)c);
        }

        public static UnicodeBlock of(int n) {
            if (!Character.isValidCodePoint(n)) {
                throw new IllegalArgumentException();
            }
            int n2 = 0;
            int n3 = blockStarts.length;
            int n4 = n3 / 2;
            while (n3 - n2 > 1) {
                if (n >= blockStarts[n4]) {
                    n2 = n4;
                } else {
                    n3 = n4;
                }
                n4 = (n3 + n2) / 2;
            }
            return blocks[n4];
        }

        public static final UnicodeBlock forName(String string) {
            UnicodeBlock unicodeBlock = (UnicodeBlock)map.get(string.toUpperCase(Locale.US));
            if (unicodeBlock == null) {
                throw new IllegalArgumentException();
            }
            return unicodeBlock;
        }
    }

    public static class Subset {
        private String name;

        protected Subset(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            this.name = string;
        }

        public final boolean equals(Object object) {
            return this == object;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

