/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.SerializationTester;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TooManyListenersException;

public abstract class DragGestureRecognizer
implements Serializable {
    private static final long serialVersionUID = 8996673345831063337L;
    protected DragSource dragSource;
    protected Component component;
    protected transient DragGestureListener dragGestureListener;
    protected int sourceActions;
    protected ArrayList<InputEvent> events = new ArrayList(1);

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        this.dragSource = dragSource;
        this.component = component;
        this.sourceActions = n & 0x40000003;
        try {
            if (dragGestureListener != null) {
                this.addDragGestureListener(dragGestureListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected DragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public synchronized Component getComponent() {
        return this.component;
    }

    public synchronized void setComponent(Component component) {
        if (this.component != null && this.dragGestureListener != null) {
            this.unregisterListeners();
        }
        this.component = component;
        if (this.component != null && this.dragGestureListener != null) {
            this.registerListeners();
        }
    }

    public synchronized int getSourceActions() {
        return this.sourceActions;
    }

    public synchronized void setSourceActions(int n) {
        this.sourceActions = n & 0x40000003;
    }

    public InputEvent getTriggerEvent() {
        return this.events.isEmpty() ? null : this.events.get(0);
    }

    public void resetRecognizer() {
        this.events.clear();
    }

    public synchronized void addDragGestureListener(DragGestureListener dragGestureListener) throws TooManyListenersException {
        if (this.dragGestureListener != null) {
            throw new TooManyListenersException();
        }
        this.dragGestureListener = dragGestureListener;
        if (this.component != null) {
            this.registerListeners();
        }
    }

    public synchronized void removeDragGestureListener(DragGestureListener dragGestureListener) {
        if (this.dragGestureListener == null || !this.dragGestureListener.equals(dragGestureListener)) {
            throw new IllegalArgumentException();
        }
        this.dragGestureListener = null;
        if (this.component != null) {
            this.unregisterListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fireDragGestureRecognized(int n, Point point) {
        try {
            if (this.dragGestureListener != null) {
                this.dragGestureListener.dragGestureRecognized(new DragGestureEvent(this, n, point, this.events));
            }
            Object var4_3 = null;
            this.events.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.events.clear();
            throw throwable;
        }
    }

    protected synchronized void appendEvent(InputEvent inputEvent) {
        this.events.add(inputEvent);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializationTester.test(this.dragGestureListener) ? this.dragGestureListener : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.dragGestureListener = (DragGestureListener)objectInputStream.readObject();
    }
}

