/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.event;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ReceiverBuffer {
    private List<TargetedNotification> notifList = new ArrayList<TargetedNotification>();
    private long start = 0L;
    private int lost = 0;
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "ReceiverBuffer");

    public void addNotifs(NotificationResult notificationResult) {
        if (notificationResult == null) {
            return;
        }
        TargetedNotification[] targetedNotificationArray = notificationResult.getTargetedNotifications();
        if (logger.traceOn()) {
            logger.trace("addNotifs", "" + targetedNotificationArray.length);
        }
        long l = notificationResult.getEarliestSequenceNumber();
        long l2 = l - this.start;
        this.start = notificationResult.getNextSequenceNumber();
        if (l2 > 0L) {
            if (logger.traceOn()) {
                logger.trace("addNotifs", "lost: " + l2);
            }
            this.lost = (int)((long)this.lost + l2);
        }
        Collections.addAll(this.notifList, notificationResult.getTargetedNotifications());
    }

    public TargetedNotification[] removeNotifs() {
        if (logger.traceOn()) {
            logger.trace("removeNotifs", String.valueOf(this.notifList.size()));
        }
        if (this.notifList.size() == 0) {
            return null;
        }
        TargetedNotification[] targetedNotificationArray = this.notifList.toArray(new TargetedNotification[0]);
        this.notifList.clear();
        return targetedNotificationArray;
    }

    public int size() {
        return this.notifList.size();
    }

    public int removeLost() {
        int n = this.lost;
        this.lost = 0;
        return n;
    }
}

