/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.xml;

import fr.jayasoft.ivy.ConflictManager;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.circular.CircularDependencyStrategy;
import fr.jayasoft.ivy.status.StatusManager;
import fr.jayasoft.ivy.url.URLHandlerRegistry;
import fr.jayasoft.ivy.util.Configurator;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlIvyConfigurationParser
extends DefaultHandler {
    private Configurator _configurator;
    private List _configuratorTags = Arrays.asList("resolvers", "namespaces", "parsers", "latest-strategies", "conflict-managers", "outputters", "version-matchers", "statuses", "circular-dependency-strategies", "triggers");
    private Ivy _ivy;
    private String _defaultResolver;
    private String _defaultCM;
    private String _defaultLatest;
    private String _defaultCircular;
    private String _currentConfiguratorTag;

    public XmlIvyConfigurationParser(Ivy ivy) {
        this._ivy = ivy;
    }

    public void parse(URL configuration) throws ParseException, IOException {
        this._configurator = new Configurator();
        Map typeDefs = this._ivy.getTypeDefs();
        Iterator iter = typeDefs.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this._configurator.typeDef(name, (Class)typeDefs.get(name));
        }
        this.doParse(configuration);
    }

    private void doParse(URL configuration) throws IOException, ParseException {
        InputStream stream = null;
        try {
            stream = URLHandlerRegistry.getDefault().openStream(configuration);
            SAXParserFactory.newInstance().newSAXParser().parse(stream, (DefaultHandler)this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            ParseException pe = new ParseException("failed to configure with " + configuration + ": " + e.getMessage(), 0);
            pe.initCause(e);
            throw pe;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void parse(Configurator configurator, URL configuration) throws IOException, ParseException {
        this._configurator = configurator;
        this.doParse(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
        block64: {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (int i = 0; i < att.getLength(); ++i) {
                attributes.put(att.getQName(i), att.getValue(i));
            }
            try {
                if (this._configurator.getCurrent() != null) {
                    if ("macrodef".equals(this._currentConfiguratorTag) && this._configurator.getTypeDef(qName) != null) {
                        String name = (String)attributes.get("name");
                        if (name == null) {
                            attributes.put("name", "@{name}");
                        } else if (this._configurator.isTopLevelMacroRecord() && name.indexOf("@{name}") != -1) {
                            attributes.put("name", name);
                        } else {
                            attributes.put("name", "@{name}-" + name);
                        }
                    }
                    if (attributes.get("ref") != null) {
                        if (attributes.size() != 1) {
                            throw new IllegalArgumentException("ref attribute should be the only one ! found " + attributes.size() + " in " + qName);
                        }
                        String name = (String)attributes.get("ref");
                        Object child = null;
                        if ("resolvers".equals(this._currentConfiguratorTag)) {
                            child = this._ivy.getResolver(name);
                            if (child == null) {
                                throw new IllegalArgumentException("unknown resolver " + name + ": resolver should be defined before being referenced");
                            }
                        } else if ("latest-strategies".equals(this._currentConfiguratorTag)) {
                            child = this._ivy.getLatestStrategy(name);
                            if (child == null) {
                                throw new IllegalArgumentException("unknown latest strategy " + name + ": latest strategy should be defined before being referenced");
                            }
                        } else if ("conflict-managers".equals(this._currentConfiguratorTag) && (child = this._ivy.getConflictManager(name)) == null) {
                            throw new IllegalArgumentException("unknown conflict manager " + name + ": conflict manager should be defined before being referenced");
                        }
                        if (child == null) {
                            throw new IllegalArgumentException("bad reference " + name);
                        }
                        this._configurator.addChild(qName, child);
                    } else {
                        this._configurator.startCreateChild(qName);
                        Iterator iter = attributes.keySet().iterator();
                        while (iter.hasNext()) {
                            String attName = (String)iter.next();
                            this._configurator.setAttribute(attName, this._ivy.substitute((String)attributes.get(attName)));
                        }
                    }
                    break block64;
                }
                if ("classpath".equals(qName)) {
                    String urlStr = this._ivy.substitute((String)attributes.get("url"));
                    URL url = null;
                    if (urlStr == null) {
                        String file = this._ivy.substitute((String)attributes.get("file"));
                        if (file == null) {
                            throw new IllegalArgumentException("either url or file should be given for classpath element");
                        }
                        url = new File(file).toURL();
                    } else {
                        url = new URL(urlStr);
                    }
                    this._ivy.addClasspathURL(url);
                    break block64;
                }
                if ("typedef".equals(qName)) {
                    String name = this._ivy.substitute((String)attributes.get("name"));
                    String className = this._ivy.substitute((String)attributes.get("classname"));
                    Class clazz = this._ivy.typeDef(name, className);
                    this._configurator.typeDef(name, clazz);
                    break block64;
                }
                if ("property".equals(qName)) {
                    String name = this._ivy.substitute((String)attributes.get("name"));
                    String value = this._ivy.substitute((String)attributes.get("value"));
                    String override = this._ivy.substitute((String)attributes.get("override"));
                    if (name == null) {
                        throw new IllegalArgumentException("missing attribute name on property tag");
                    }
                    if (value == null) {
                        throw new IllegalArgumentException("missing attribute value on property tag");
                    }
                    this._ivy.setVariable(name, value, override == null ? true : Boolean.valueOf(override));
                    break block64;
                }
                if ("properties".equals(qName)) {
                    String propFilePath = this._ivy.substitute((String)attributes.get("file"));
                    String override = this._ivy.substitute((String)attributes.get("override"));
                    try {
                        Message.verbose("loading properties: " + propFilePath);
                        this._ivy.loadProperties(new File(propFilePath), override == null ? true : Boolean.valueOf(override));
                        break block64;
                    }
                    catch (Exception fileEx) {
                        Message.verbose("failed to load properties as file: trying as url: " + propFilePath);
                        try {
                            this._ivy.loadProperties(new URL(propFilePath), override == null ? true : Boolean.valueOf(override));
                            break block64;
                        }
                        catch (Exception urlEx) {
                            throw new IllegalArgumentException("unable to load properties from " + propFilePath + ". Tried both as an url and a file, with no success. File exception: " + fileEx + ". URL exception: " + urlEx);
                        }
                    }
                }
                if ("include".equals(qName)) {
                    HashMap variables = new HashMap(this._ivy.getVariables());
                    try {
                        String propFilePath = this._ivy.substitute((String)attributes.get("file"));
                        URL ivyconfURL = null;
                        if (propFilePath == null) {
                            propFilePath = this._ivy.substitute((String)attributes.get("url"));
                            if (propFilePath == null) {
                                Message.error("bad include tag: specify file or url to include");
                                return;
                            }
                            Message.verbose("including url: " + propFilePath);
                            ivyconfURL = new URL(propFilePath);
                            this._ivy.setConfigurationVariables(ivyconfURL);
                        } else {
                            File incFile = new File(propFilePath);
                            if (!incFile.exists()) {
                                Message.error("impossible to include " + incFile + ": file does not exist");
                                return;
                            }
                            Message.verbose("including file: " + propFilePath);
                            this._ivy.setConfigurationVariables(incFile);
                            ivyconfURL = incFile.toURL();
                        }
                        new XmlIvyConfigurationParser(this._ivy).parse(this._configurator, ivyconfURL);
                        break block64;
                    }
                    finally {
                        this._ivy.setVariables(variables);
                    }
                }
                if ("conf".equals(qName)) {
                    String useRemoteConfig;
                    String cacheArtPattern;
                    String cacheIvyPattern;
                    String up2d;
                    String validate;
                    String defaultBranch;
                    String cache = (String)attributes.get("defaultCache");
                    if (cache != null) {
                        this._ivy.setDefaultCache(new File(this._ivy.substitute(cache)));
                    }
                    if ((defaultBranch = (String)attributes.get("defaultBranch")) != null) {
                        this._ivy.setDefaultBranch(this._ivy.substitute(defaultBranch));
                    }
                    if ((validate = (String)attributes.get("validate")) != null) {
                        this._ivy.setValidate(Boolean.valueOf(this._ivy.substitute(validate)));
                    }
                    if ((up2d = (String)attributes.get("checkUpToDate")) != null) {
                        this._ivy.setCheckUpToDate(Boolean.valueOf(this._ivy.substitute(up2d)));
                    }
                    if ((cacheIvyPattern = (String)attributes.get("cacheIvyPattern")) != null) {
                        this._ivy.setCacheIvyPattern(this._ivy.substitute(cacheIvyPattern));
                    }
                    if ((cacheArtPattern = (String)attributes.get("cacheArtifactPattern")) != null) {
                        this._ivy.setCacheArtifactPattern(this._ivy.substitute(cacheArtPattern));
                    }
                    if ((useRemoteConfig = (String)attributes.get("useRemoteConfig")) != null) {
                        this._ivy.setUseRemoteConfig(Boolean.valueOf(this._ivy.substitute(useRemoteConfig)));
                    }
                    this._defaultResolver = (String)attributes.get("defaultResolver");
                    this._defaultCM = (String)attributes.get("defaultConflictManager");
                    this._defaultLatest = (String)attributes.get("defaultLatestStrategy");
                    this._defaultCircular = (String)attributes.get("circularDependencyStrategy");
                } else if ("version-matchers".equals(qName)) {
                    this._currentConfiguratorTag = qName;
                    this._configurator.setRoot(this._ivy);
                    if ("true".equals(this._ivy.substitute((String)attributes.get("usedefaults")))) {
                        this._ivy.configureDefaultVersionMatcher();
                    }
                } else if ("statuses".equals(qName)) {
                    this._currentConfiguratorTag = qName;
                    StatusManager m = new StatusManager();
                    String defaultStatus = this._ivy.substitute((String)attributes.get("default"));
                    if (defaultStatus != null) {
                        m.setDefaultStatus(defaultStatus);
                    }
                    this._ivy.setStatusManager(m);
                    this._configurator.setRoot(m);
                } else if (this._configuratorTags.contains(qName)) {
                    this._currentConfiguratorTag = qName;
                    this._configurator.setRoot(this._ivy);
                } else if ("macrodef".equals(qName)) {
                    this._currentConfiguratorTag = qName;
                    Configurator.MacroDef macrodef = this._configurator.startMacroDef((String)attributes.get("name"));
                    macrodef.addAttribute("name", null);
                } else if ("module".equals(qName)) {
                    String organisation = this._ivy.substitute((String)attributes.get("organisation"));
                    String module = this._ivy.substitute((String)attributes.get("name"));
                    String resolver = this._ivy.substitute((String)attributes.get("resolver"));
                    String branch = this._ivy.substitute((String)attributes.get("branch"));
                    String cm = this._ivy.substitute((String)attributes.get("conflict-manager"));
                    String matcher = this._ivy.substitute((String)attributes.get("matcher"));
                    matcher = matcher == null ? "exactOrRegexp" : matcher;
                    this._ivy.addModuleConfiguration(new ModuleId(organisation, module), this._ivy.getMatcher(matcher), resolver, branch, cm);
                }
            }
            catch (Exception ex) {
                throw new SAXException("problem in config file: " + ex.getMessage(), ex);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._configurator.getCurrent() != null) {
            if (this._configuratorTags.contains(qName) && this._configurator.getDepth() == 1) {
                this._configurator.clear();
                this._currentConfiguratorTag = null;
            } else if ("macrodef".equals(qName) && this._configurator.getDepth() == 1) {
                this._configurator.endMacroDef();
                this._currentConfiguratorTag = null;
            } else {
                this._configurator.endCreateChild();
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this._defaultResolver != null) {
            this._ivy.setDefaultResolver(this._ivy.substitute(this._defaultResolver));
        }
        if (this._defaultCM != null) {
            ConflictManager conflictManager = this._ivy.getConflictManager(this._ivy.substitute(this._defaultCM));
            if (conflictManager == null) {
                throw new IllegalArgumentException("unknown conflict manager " + this._ivy.substitute(this._defaultCM));
            }
            this._ivy.setDefaultConflictManager(conflictManager);
        }
        if (this._defaultLatest != null) {
            LatestStrategy latestStrategy = this._ivy.getLatestStrategy(this._ivy.substitute(this._defaultLatest));
            if (latestStrategy == null) {
                throw new IllegalArgumentException("unknown latest strategy " + this._ivy.substitute(this._defaultLatest));
            }
            this._ivy.setDefaultLatestStrategy(latestStrategy);
        }
        if (this._defaultCircular != null) {
            CircularDependencyStrategy strategy = this._ivy.getCircularDependencyStrategy(this._ivy.substitute(this._defaultCircular));
            if (strategy == null) {
                throw new IllegalArgumentException("unknown circular dependency strategy " + this._ivy.substitute(this._defaultCircular));
            }
            this._ivy.setCircularDependencyStrategy(strategy);
        }
    }
}

