/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.jpeg;

public class JPEGQTable {
    private int[] table;
    public static final JPEGQTable K1Luminance = new JPEGQTable(new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99}, false);
    public static final JPEGQTable K1Div2Luminance = K1Luminance.getScaledInstance(0.5f, true);
    public static final JPEGQTable K2Chrominance = new JPEGQTable(new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99}, false);
    public static final JPEGQTable K2Div2Chrominance = K2Chrominance.getScaledInstance(0.5f, true);

    public JPEGQTable(int[] nArray) {
        this(JPEGQTable.checkTable(nArray), true);
    }

    private JPEGQTable(int[] nArray, boolean bl) {
        this.table = bl ? (int[])nArray.clone() : nArray;
    }

    private static int[] checkTable(int[] nArray) {
        if (nArray == null || nArray.length != 64) {
            throw new IllegalArgumentException("invalid JPEG quantization table");
        }
        return nArray;
    }

    public int[] getTable() {
        return (int[])this.table.clone();
    }

    public JPEGQTable getScaledInstance(float f, boolean bl) {
        int[] nArray = this.getTable();
        int n = bl ? 255 : Short.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Math.round(f * (float)nArray[i]);
            if (nArray[i] < 1) {
                nArray[i] = 1;
                continue;
            }
            if (nArray[i] <= n) continue;
            nArray[i] = n;
        }
        return new JPEGQTable(nArray, false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JPEGQTable:\n");
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append("        ");
            for (int j = 0; j < 8; ++j) {
                stringBuffer.append(this.table[i * 8 + j] + " ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

